/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jce;

import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.jce.ECDSAHelper;
import de.governikus.csl.uom.jce.RAWAlgorithmParameterSpec;
import de.governikus.csl.uom.jcebase.XMLOIDJCEAlgorithmMapper;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1SequenceParser;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SignatureValue
extends ASN1Object {
    public static final int SEQUENCE_IDX_DIGEST = 0;
    public static final int SEQUENCE_IDX_SIGNATURE = 1;
    public static final int SEQUENCE_IDX_SUBJECT_PUBLIC_KEY_INFO = 2;
    public static final int SEQUENCE_IDX_CERTIFICATE = 3;
    private DigestInfo digest;
    private DigestInfo signature;
    private SubjectPublicKeyInfo subjectPublicKeyInfo;
    private DigestInfo certificate;
    public static final DigestInfoHandler DIGEST_INFO_HANDLER_FULL = digestInfo -> {
        try {
            return digestInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    };
    public static final DigestInfoHandler DIGEST_INFO_HANDLER_DIGEST_ONLY = digestInfo -> digestInfo.getDigest();

    public SignatureValue(DigestInfo digest, DigestInfo signature, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this(digest, signature, subjectPublicKeyInfo, null);
    }

    public SignatureValue(DigestInfo digest, DigestInfo signature, SubjectPublicKeyInfo subjectPublicKeyInfo, DigestInfo certificate) {
        this.digest = Objects.requireNonNull(digest);
        this.signature = Objects.requireNonNull(signature);
        this.subjectPublicKeyInfo = Objects.requireNonNull(subjectPublicKeyInfo);
        this.certificate = certificate;
        this.checkInit();
    }

    private void checkInit() {
        this.getPublicKey();
    }

    public SignatureValue(ASN1Sequence seq) {
        try {
            ASN1Sequence lseq = Objects.requireNonNull(seq);
            if (seq.size() > 4) {
                throw new IllegalArgumentException("too many sequence elements, maximum: 3, found: " + seq.size());
            }
            this.digest = DigestInfo.getInstance((Object)lseq.getObjectAt(0));
            this.signature = DigestInfo.getInstance((Object)lseq.getObjectAt(1));
            this.subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)lseq.getObjectAt(2));
            if (lseq.size() >= 4) {
                this.certificate = DigestInfo.getInstance((Object)lseq.getObjectAt(3));
            }
            this.checkInit();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public byte[] getSignatureValue() {
        return this.signature.getDigest();
    }

    public boolean verify() throws SignatureException, InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, InvalidAlgorithmParameterException, CoreException {
        return this.verify(this.getDefaultSignature(), DIGEST_INFO_HANDLER_DIGEST_ONLY);
    }

    public boolean verify(Signature signature, DigestInfoHandler digestInfoHandler) throws SignatureException {
        signature.update(digestInfoHandler == null ? this.digest.getDigest() : digestInfoHandler.handle(this.digest));
        byte[] signatureBytes = this.signature.getDigest();
        try {
            if ("NONEwithECDSA".equals(signature.getAlgorithm()) && !ECDSAHelper.isASN1SequenceECDSACandidate(signatureBytes)) {
                signatureBytes = ECDSAHelper.convertXMLDSIGtoASN1(signatureBytes);
            }
        }
        catch (IOException e) {
            return false;
        }
        return signature.verify(signatureBytes);
    }

    public Signature getDefaultSignature() throws NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, InvalidAlgorithmParameterException, CoreException {
        Signature signatureInstance = Signature.getInstance("RAW", "CPP");
        String signatureAlgorithmURI = XMLOIDJCEAlgorithmMapper.getMapper().getURI(this.signature.getAlgorithmId());
        String digestAlgorithmURI = XMLOIDJCEAlgorithmMapper.getMapper().getURI(this.digest.getAlgorithmId());
        signatureInstance.setParameter(new RAWAlgorithmParameterSpec(signatureAlgorithmURI, digestAlgorithmURI, true));
        signatureInstance.initVerify(this.getPublicKey());
        return signatureInstance;
    }

    public PublicKey getPublicKey() {
        return SignatureValue.getPublicKey(this.subjectPublicKeyInfo);
    }

    public static PublicKey getPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        if (subjectPublicKeyInfo == null) {
            return null;
        }
        try {
            return BouncyCastleProvider.getPublicKey((SubjectPublicKeyInfo)subjectPublicKeyInfo);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.digest);
        v.add((ASN1Encodable)this.signature);
        v.add((ASN1Encodable)this.subjectPublicKeyInfo);
        if (this.certificate != null) {
            v.add((ASN1Encodable)this.certificate);
        }
        return new DERSequence(v);
    }

    public static SignatureValue getInstance(Object obj) {
        ASN1Primitive primitive;
        if (obj == null || obj instanceof SignatureValue) {
            return (SignatureValue)((Object)obj);
        }
        if (obj instanceof ASN1Sequence) {
            return new SignatureValue((ASN1Sequence)obj);
        }
        if (obj instanceof ASN1SequenceParser) {
            return new SignatureValue(ASN1Sequence.getInstance((Object)((ASN1SequenceParser)obj).toASN1Primitive()));
        }
        if (obj instanceof byte[]) {
            try {
                return new SignatureValue(ASN1Sequence.getInstance((Object)ASN1Sequence.fromByteArray((byte[])((byte[])obj))));
            }
            catch (IOException | ArrayIndexOutOfBoundsException e) {
                throw new IllegalArgumentException("failed to construct SignatureValue from byte[]: " + e.getMessage());
            }
        }
        if (obj instanceof ASN1Encodable && (primitive = ((ASN1Encodable)obj).toASN1Primitive()) instanceof ASN1Sequence) {
            return new SignatureValue((ASN1Sequence)primitive);
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    public DigestInfo getCertificate() {
        return this.certificate;
    }

    public void setCertificate(DigestInfo certificate) {
        this.certificate = certificate;
    }

    public DigestInfo getDigest() {
        return this.digest;
    }

    public void setDigest(DigestInfo digest) {
        this.digest = Objects.requireNonNull(digest, "digest required");
    }

    public DigestInfo getSignature() {
        return this.signature;
    }

    public void setSignature(DigestInfo signature) {
        this.signature = Objects.requireNonNull(signature, "signature required");
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public void setSubjectPublicKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        SignatureValue.getPublicKey(subjectPublicKeyInfo);
        this.subjectPublicKeyInfo = Objects.requireNonNull(subjectPublicKeyInfo, "SubjectPublicKeyInfo required");
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.digest.hashCode();
        result = 31 * result + this.signature.hashCode();
        result = 31 * result + this.subjectPublicKeyInfo.hashCode();
        result = 31 * result + (this.certificate == null ? 0 : this.certificate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return ((Object)((Object)this)).getClass() == obj.getClass();
    }

    public static interface DigestInfoHandler {
        public byte[] handle(DigestInfo var1);
    }
}

