/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jce;

import de.governikus.csl.uom.jce.Bound;
import de.governikus.csl.uom.jce.BoundType;

public class Range<T extends Number> {
    private final Bound<T> min;
    private final Bound<T> max;

    public Bound<T> getMin() {
        return this.min;
    }

    public Bound<T> getMax() {
        return this.max;
    }

    public Range(T minValue, T maxValue) {
        this(minValue == null ? null : new Bound<T>(minValue, BoundType.INCLUSIVE), maxValue == null ? null : new Bound<T>(maxValue, BoundType.INCLUSIVE));
    }

    public Range(T value) {
        this(new Bound<T>(value, BoundType.INCLUSIVE));
    }

    public Range(Bound<T> bound) {
        this(bound, bound);
    }

    public Range(Bound<T> min, Bound<T> max) {
        if (min != null && max != null && ((Comparable)min.getValue()).compareTo(max.getValue()) > 0) {
            throw new IllegalArgumentException("min and max bound are not in valid order");
        }
        this.min = min;
        this.max = max;
    }

    public String toString() {
        return "Range " + (this.min == null || this.min.isInclusive() ? "[" : "(") + "min=" + (this.min == null ? null : this.min.getValue()) + ", max=" + (this.max == null ? null : this.max.getValue()) + (this.max == null || this.max.isInclusive() ? "]" : ")");
    }

    public boolean isValueValid(T value) {
        if (value == null) {
            return this.isValueValidMin(value) || this.isValueValidMax(value);
        }
        return this.isValueValidMin(value) && this.isValueValidMax(value);
    }

    private boolean isValueValidMax(T value) {
        if (this.max == null) {
            return true;
        }
        if (value == null) {
            return false;
        }
        int compare = ((Comparable)this.max.getValue()).compareTo(value);
        if (compare == 0 && this.max.isInclusive()) {
            return true;
        }
        return compare > 0;
    }

    private boolean isValueValidMin(T value) {
        if (this.min == null) {
            return true;
        }
        if (value == null) {
            return false;
        }
        int compare = ((Comparable)this.min.getValue()).compareTo(value);
        if (compare == 0 && this.min.isInclusive()) {
            return true;
        }
        return compare < 0;
    }
}

