/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jce;

import de.governikus.csl.uom.jcebase.XMLOIDJCEAlgorithmMapper;
import java.security.InvalidParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Objects;

public final class RAWAlgorithmParameterSpec
implements AlgorithmParameterSpec {
    private static final int IDX_CSV_ALGORITHM = 0;
    private static final int IDX_CSV_DIGEST_ALGORITHM = 1;
    private static final int IDX_CSV_DIGEST_TO_BE_SIGNED = 2;
    public static final String JCE_SIGNATURE_INSTANCE_PARAM_NAME = RAWAlgorithmParameterSpec.class.getName();
    public static final boolean DEFAULT_DIGEST_TO_BE_SIGNED = false;
    public static final String RAW_ALGORITHM_PARAMETER_SPEC_VALUE_CSV_SEPARATOR = ";";
    private final String algorithmURI;
    private final boolean digestToBeSigned;
    private final String digestAlgorithmURI;

    public RAWAlgorithmParameterSpec(String algorithmURI, String digestAlgorithmURI) {
        this(algorithmURI, digestAlgorithmURI, false);
    }

    public RAWAlgorithmParameterSpec(String algorithmURI, String digestAlgorithmURI, boolean digestToBeSigned) {
        Objects.requireNonNull(algorithmURI, "URI of algorithm can not be null");
        if (algorithmURI.isEmpty()) {
            throw new IllegalArgumentException("URI of algorithm can not be an empty String");
        }
        String lAlgorithmURI = XMLOIDJCEAlgorithmMapper.getCSLAlgorithmURI((String)algorithmURI);
        Objects.requireNonNull(XMLOIDJCEAlgorithmMapper.getMapper().mapXMLAlgorithmJCE(lAlgorithmURI), "URI of algorithm must be mappable to JCE by XMLOIDJCEAlgorithmMapper: " + lAlgorithmURI + "/" + algorithmURI);
        this.algorithmURI = lAlgorithmURI;
        this.digestAlgorithmURI = digestAlgorithmURI;
        this.digestToBeSigned = digestToBeSigned;
    }

    public final String getAlgorithmURI() {
        return this.algorithmURI;
    }

    public boolean isDigestToBeSigned() {
        return this.digestToBeSigned;
    }

    public String toCSVValue() {
        return this.algorithmURI + RAW_ALGORITHM_PARAMETER_SPEC_VALUE_CSV_SEPARATOR + this.digestAlgorithmURI + RAW_ALGORITHM_PARAMETER_SPEC_VALUE_CSV_SEPARATOR + this.digestToBeSigned;
    }

    public static RAWAlgorithmParameterSpec fromParameterValue(String param, Object value) {
        if (JCE_SIGNATURE_INSTANCE_PARAM_NAME.equals(param)) {
            try {
                return RAWAlgorithmParameterSpec.from(value.toString());
            }
            catch (Exception e) {
                throw new InvalidParameterException(e.getMessage());
            }
        }
        throw new InvalidParameterException();
    }

    public static RAWAlgorithmParameterSpec from(Object csv) {
        if (csv == null) {
            throw new NullPointerException("can not create a RAWAlgorithmParameterSpec from null");
        }
        String csvString = csv.toString();
        if (csvString == null) {
            throw new IllegalArgumentException("can not create a RAWAlgorithmParameterSpec from null");
        }
        if (csvString.isEmpty()) {
            throw new IllegalArgumentException("can not create a RAWAlgorithmParameterSpec from empty String");
        }
        String[] values = csvString.split(RAW_ALGORITHM_PARAMETER_SPEC_VALUE_CSV_SEPARATOR);
        String digestAlgorithm = null;
        if (values.length > 1) {
            digestAlgorithm = values[1];
        }
        boolean digestToBeSigned = false;
        if (values.length > 2) {
            digestToBeSigned = Boolean.parseBoolean(values[2]);
        }
        return new RAWAlgorithmParameterSpec(values[0], digestAlgorithm, digestToBeSigned);
    }

    public String getDigestAlgorithmURI() {
        return this.digestAlgorithmURI;
    }
}

