/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jce;

import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.jce.CSLJCECipherException;
import de.governikus.csl.uom.jce.CSLJCESignatureException;
import de.governikus.csl.uom.jce.Range;
import de.governikus.csl.uom.jce.TempPrivateKeyResourceUtil;
import de.governikus.csl.uom.jce.remote.CSLJCERemoteCipherException;
import de.governikus.csl.uom.jce.remote.CSLJCERemoteSignatureException;
import de.governikus.csl.uom.res.KeyResource;
import de.governikus.csl.uom.res.PrivateKeyResource;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class JceHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JceHelper.class.getName());
    public static final String JCE_PURPOSE_SIGNING = "signing";
    public static final String JCE_PURPOSE_VERIFYING = "verifying";
    public static final String JCE_PURPOSE_ENCRYPTING = "encrypting";
    public static final String JCE_PURPOSE_DECRYPTING = "decrypting";
    public static final String LOGGING_ACCOUNTING = "accounting";

    protected static int getKeySize(Key key) throws InvalidKeyException {
        if (key instanceof RSAPrivateCrtKey) {
            ((RSAPrivateCrtKey)key).getModulus().bitLength();
        } else if (key instanceof RSAPrivateKey) {
            ((RSAPrivateKey)key).getModulus().bitLength();
        } else if (key instanceof RSAPublicKey) {
            ((RSAPublicKey)key).getModulus().bitLength();
        }
        return 4096;
    }

    private JceHelper() {
    }

    private static String getName(KeyResource<?> keyResource) {
        return keyResource == null ? "not named key" : keyResource.getReference().getName();
    }

    public static void logDoFinalStart(Logger logger, String jcePurpose, KeyResource<?> keyResource) {
        if (logger.isInfoEnabled()) {
            logger.info(String.format("start %s with key...%s", jcePurpose, JceHelper.getName(keyResource)));
        }
        JceHelper.logAccounting(logger, jcePurpose, keyResource);
    }

    public static void logAccounting(Logger logger, String jcePurpose, KeyResource<?> keyResource) {
        MDC.put((String)LOGGING_ACCOUNTING, (String)Boolean.TRUE.toString());
        if (logger.isInfoEnabled()) {
            logger.info(String.format("start %s with key...%s", jcePurpose, JceHelper.getName(keyResource)));
        }
        MDC.remove((String)LOGGING_ACCOUNTING);
    }

    public static void logDoFinalEnd(Logger logger, String jcePurpose, KeyResource<?> keyResource) {
        if (logger.isInfoEnabled()) {
            logger.info(jcePurpose + " finished..." + JceHelper.getName(keyResource));
        }
    }

    public static Range<Integer> getSignatureValueLength(PublicKey publicKey, String signatureAlgorithm) {
        return JceHelper.getSignatureValueLength(publicKey, !signatureAlgorithm.contains("-ansi"));
    }

    public static Range<Integer> getSignatureValueLength(PublicKey publicKey, boolean cvc) {
        if (publicKey instanceof ECPublicKey) {
            int l = 2 * (((ECPublicKey)publicKey).getParams().getGenerator().getAffineX().toByteArray().length - 1);
            if (cvc) {
                return new Range<Integer>(l, l + 2);
            }
            return new Range<Integer>(l + 6, l + 6 + 2);
        }
        int l = 256;
        if (publicKey instanceof RSAPublicKey) {
            return new Range<Integer>(((RSAPublicKey)publicKey).getModulus().toByteArray().length - 1);
        }
        return new Range<Integer>(l);
    }

    public static PublicKey checkGetPublicKey(Key key) throws InvalidKeyException {
        if (!PublicKey.class.isInstance(key)) {
            String msg = "only PublicKey supported: " + key.getClass();
            InvalidKeyException ike = new InvalidKeyException(msg);
            LOGGER.error("msg", (Throwable)ike);
            throw ike;
        }
        return (PublicKey)key;
    }

    public static KeyResource<?> checkGetKeyResource(Key key) throws InvalidKeyException {
        if (!(KeyResource.class.isInstance(key) || key instanceof PrivateKey || key instanceof PublicKey)) {
            String msg = "only KeyResource/PrivateKey/PublicKey supported: " + key.getClass();
            InvalidKeyException ike = new InvalidKeyException(msg);
            LOGGER.error("msg", (Throwable)ike);
            throw ike;
        }
        KeyResource keyResource = null;
        if (KeyResource.class.isInstance(key)) {
            keyResource = (KeyResource)KeyResource.class.cast(key);
        } else if (key instanceof PrivateKey) {
            keyResource = TempPrivateKeyResourceUtil.createTempPrivateKeyResource((PrivateKey)key);
        } else if (key instanceof PublicKey) {
            keyResource = TempPrivateKeyResourceUtil.createTempPublicKeyResource((PublicKey)key);
        }
        return keyResource;
    }

    public static PrivateKeyResource checkGetPrivateKeyResource(Key key) throws InvalidKeyException {
        if (!PrivateKeyResource.class.isInstance(key) && !(key instanceof PrivateKey)) {
            String msg = "only PrivateKeyResource/PrivateKey supported: " + (key == null ? null : key.getClass());
            InvalidKeyException ike = new InvalidKeyException(msg);
            LOGGER.error("msg", (Throwable)ike);
            throw ike;
        }
        PrivateKeyResource keyResource = null;
        keyResource = PrivateKeyResource.class.isInstance(key) ? (PrivateKeyResource)PrivateKeyResource.class.cast(key) : TempPrivateKeyResourceUtil.createTempPrivateKeyResource((PrivateKey)key);
        return keyResource;
    }

    public static CSLJCESignatureException throwSignatureException(boolean throwException, boolean remote, String message) throws CSLJCESignatureException, CSLJCERemoteSignatureException {
        if (throwException) {
            if (remote) {
                throw new CSLJCERemoteSignatureException(message);
            }
            throw new CSLJCESignatureException(message);
        }
        return null;
    }

    public static CSLJCESignatureException throwSignatureException(Throwable e, boolean remote) throws CSLJCESignatureException, CSLJCERemoteSignatureException {
        return JceHelper.throwSignatureException(e, remote, null);
    }

    public static CSLJCESignatureException throwSignatureException(Throwable e, boolean remote, String message) throws CSLJCESignatureException, CSLJCERemoteSignatureException {
        if (e instanceof CSLJCESignatureException) {
            throw (CSLJCESignatureException)e;
        }
        if (e instanceof CSLJCERemoteSignatureException) {
            throw (CSLJCERemoteSignatureException)e;
        }
        if (message == null || message.isEmpty()) {
            if (remote) {
                throw new CSLJCERemoteSignatureException(e);
            }
            throw new CSLJCESignatureException(e);
        }
        if (remote) {
            throw new CSLJCERemoteSignatureException(message, e);
        }
        throw new CSLJCESignatureException(message, e);
    }

    public static CSLJCECipherException throwCipherException(boolean throwException, boolean remote, String message) throws CSLJCECipherException, CSLJCERemoteCipherException {
        if (throwException) {
            if (remote) {
                throw new CSLJCERemoteCipherException(message);
            }
            throw new CSLJCECipherException(message);
        }
        return null;
    }

    public static CSLJCECipherException throwCipherException(Throwable e, boolean remote) throws CSLJCECipherException, CSLJCERemoteCipherException {
        return JceHelper.throwCipherException(e, remote, null);
    }

    public static CSLJCECipherException throwCipherException(Throwable e, boolean remote, String message) throws CSLJCECipherException, CSLJCERemoteCipherException {
        if (e instanceof CSLJCECipherException) {
            throw (CSLJCECipherException)e;
        }
        if (e instanceof CSLJCERemoteCipherException) {
            throw (CSLJCERemoteCipherException)e;
        }
        if (message == null || message.isEmpty()) {
            if (remote) {
                throw new CSLJCERemoteCipherException(e);
            }
            throw new CSLJCECipherException(e);
        }
        if (remote) {
            throw new CSLJCERemoteCipherException(message, e);
        }
        throw new CSLJCECipherException(message, e);
    }

    public static CoreException toCoreException(String string) {
        return new CoreException(string, null);
    }

    public static CoreException toCoreException(String string, Exception e) {
        return new CoreException(string, (Throwable)e);
    }
}

