/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jce;

import java.security.spec.AlgorithmParameterSpec;
import java.util.LinkedHashMap;
import java.util.Map;

public class JCEAlgorithmDefinition {
    private static final String[] DEFAULT_PROVIDER = new String[]{null};
    final String algorithmName;
    AlgorithmParameterSpec algorithmParameterSpec;
    final String[] providerNames;

    public static Map<String, JCEAlgorithmDefinition> toMap(JCEAlgorithmDefinition ... algorithmDefinitions) {
        if (algorithmDefinitions == null) {
            throw new IllegalArgumentException("null array is not valid, at least one entry is required");
        }
        if (algorithmDefinitions.length == 0) {
            throw new IllegalArgumentException("empty array is not valid, at least one entry is required");
        }
        LinkedHashMap<String, JCEAlgorithmDefinition> map = new LinkedHashMap<String, JCEAlgorithmDefinition>();
        for (JCEAlgorithmDefinition algorithmDefinition : algorithmDefinitions) {
            for (String providerName : algorithmDefinition.providerNames) {
                map.put(providerName, algorithmDefinition);
            }
        }
        if (!map.keySet().contains(null)) {
            throw new IllegalArgumentException("no default specified, algorithm of null key/unknown provider should be defined");
        }
        return map;
    }

    public JCEAlgorithmDefinition(String algorithmName) {
        this(algorithmName, (AlgorithmParameterSpec)null, DEFAULT_PROVIDER);
    }

    public JCEAlgorithmDefinition(String algorithmName, AlgorithmParameterSpec algorithmParameterSpec) {
        this(algorithmName, algorithmParameterSpec, DEFAULT_PROVIDER);
    }

    public JCEAlgorithmDefinition(String algorithmName, AlgorithmParameterSpec algorithmParameterSpec, String ... providerNames) {
        this.algorithmName = algorithmName;
        if (providerNames == null) {
            throw new IllegalArgumentException("null array is not valid, at least one entry is required for providers");
        }
        if (providerNames.length == 0) {
            throw new IllegalArgumentException("empty array is not valid, at least one entry is required for providers");
        }
        this.providerNames = providerNames;
        this.algorithmParameterSpec = algorithmParameterSpec;
    }

    public JCEAlgorithmDefinition(String algorithmName, String ... providerNames) {
        this(algorithmName, (AlgorithmParameterSpec)null, providerNames);
    }
}

