/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jce;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.xml.security.algorithms.implementations.ECDSAUtils;
import org.bouncycastle.asn1.ASN1Sequence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ECDSAHelper {
    private static final Logger LOG = LoggerFactory.getLogger((String)ECDSAHelper.class.getName());
    public static final int ASN1_CONSTRUCTED_SEQUENCE = 48;
    public static final int ASN1_CONSTRUCTED_SEQUENCE_ECDSA_SIGNATURE_VALUE_MINIMUM_LENGTH = 2;

    private ECDSAHelper() {
    }

    public static byte[] convertASN1toXMLDSIG(byte[] signatureValue) throws IOException {
        if (!ECDSAHelper.isASN1SequenceECDSACandidate(signatureValue)) {
            ECDSAHelper.convertXMLDSIGtoASN1(signatureValue);
            return signatureValue;
        }
        return ECDSAUtils.convertASN1toXMLDSIG((byte[])signatureValue, (int)-1);
    }

    public static void checkECDSDASignatureValueBytes(byte[] ecdsaSignatureValueBytes) throws IOException {
        if (ecdsaSignatureValueBytes == null || ecdsaSignatureValueBytes.length == 0) {
            throw new IOException("bytes does not represent ECDSA signature value (not a XML ECDSA Signature value or a ANSI X9.62 ECDSA Signature value");
        }
    }

    public static boolean isASN1SequenceECDSACandidate(byte[] bytes) throws IOException {
        ECDSAHelper.checkECDSDASignatureValueBytes(bytes);
        if (bytes.length >= 2 && bytes[0] == 48) {
            if (bytes[1] < 128 && bytes.length == bytes[1] + 2) {
                return true;
            }
            if (bytes[1] == 128) {
                return false;
            }
            if (bytes[1] == 129 && bytes.length == ECDSAHelper.abs(bytes[2]) + 3) {
                return true;
            }
        }
        return false;
    }

    public static byte[] convertXMLDSIGtoASN1(byte[] xmldsigBytes) throws IOException {
        if (ECDSAHelper.isASN1SequenceECDSACandidate(xmldsigBytes)) {
            ASN1Sequence.fromByteArray((byte[])xmldsigBytes);
            return xmldsigBytes;
        }
        return ECDSAUtils.convertXMLDSIGtoASN1((byte[])xmldsigBytes);
    }

    public static int abs(byte b) {
        return b == 0 ? 0 : b + (b > 0 ? 0 : 256);
    }

    public static void main(String[] args) throws Exception {
        int i;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(48);
        baos.write(-127);
        baos.write(-127);
        for (i = 0; i <= 128; ++i) {
            baos.write(1);
        }
        ASN1Sequence.fromByteArray((byte[])baos.toByteArray());
        for (i = 0; i < 256; ++i) {
            byte b = (byte)i;
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("{} -> {}", (Object)b, (Object)ECDSAHelper.abs(b));
        }
    }
}

