/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jce;

import de.governikus.csl.uom.jcebase.X509AttributeCertificateFacade;
import de.governikus.csl.uom.jcebase.X509CertificateFacade;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle.asn1.x509.KeyUsage;

public final class CertUtil {
    public static final String CERT_STORE_TYPE_COLLECTION = "Collection";

    private CertUtil() {
    }

    public static X509AttributeCertificateFacade generateAttributeCertificate(InputStream stream) throws CertificateException, NoSuchProviderException {
        return CertUtil.generateSpecificCertificate(X509AttributeCertificateFacade.class, stream);
    }

    public static Certificate generateCertificate(InputStream stream) throws CertificateException, NoSuchProviderException {
        if (stream == null) {
            throw new IllegalArgumentException("stream can not be null");
        }
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "CPP");
        return cf.generateCertificate(stream);
    }

    public static <C> C generateSpecificCertificate(Class<C> certClass, InputStream stream) throws CertificateException, NoSuchProviderException {
        if (certClass == null) {
            throw new IllegalArgumentException("certificate class can not be null");
        }
        Certificate generateCertificate = CertUtil.generateCertificate(stream);
        if (certClass.isInstance(generateCertificate)) {
            return certClass.cast(generateCertificate);
        }
        if (generateCertificate == null) {
            throw new CertificateException("generated certificate is null");
        }
        throw new CertificateException("generated certificate not from expected type: " + certClass.getName() + ", generated: " + generateCertificate.getClass().getName());
    }

    public static X509CertificateFacade generateX509Certificate(InputStream stream) throws CertificateException, NoSuchProviderException {
        return CertUtil.generateSpecificCertificate(X509CertificateFacade.class, stream);
    }

    public static boolean[] getKeyUsage(Certificate certificate) {
        boolean[] keyUsage = X509CertificateFacade.NO_KEY_USAGE_EMPTY;
        if (certificate instanceof X509Certificate) {
            keyUsage = ((X509Certificate)certificate).getKeyUsage();
        } else if (certificate instanceof X509CertificateFacade) {
            keyUsage = ((X509CertificateFacade)certificate).getKeyUsage();
        }
        return keyUsage;
    }

    public static void checkKeyUsageByCertificate(Certificate certificate, boolean[] ... acceptableKeyUsages) {
        if (certificate == null) {
            return;
        }
        CertUtil.checkKeyUsage(CertUtil.getKeyUsage(certificate), acceptableKeyUsages);
    }

    public static void checkKeyUsage(boolean[] keyUsageToCheck, boolean[] ... acceptableKeyUsages) {
        if (acceptableKeyUsages == null || acceptableKeyUsages.length == 0) {
            return;
        }
        if (keyUsageToCheck == null || keyUsageToCheck.length == 0) {
            throw new IllegalArgumentException("no key usage defined");
        }
        for (boolean[] acceptableKeyUsage : acceptableKeyUsages) {
            if (acceptableKeyUsage == null || acceptableKeyUsage.length == 0) {
                return;
            }
            if (!new KeyUsage(CertUtil.convert(keyUsageToCheck)).hasUsages(CertUtil.convert(acceptableKeyUsage))) continue;
            return;
        }
        throw new IllegalArgumentException("required key usage not given");
    }

    public static int convert(boolean[] b) {
        if (b == null) {
            return 0;
        }
        int l = b.length;
        if (l == 0) {
            return 0;
        }
        int n = 0;
        for (int i = l - 1; i >= 0; --i) {
            n = (n << 1) + (b[i] ? 1 : 0);
        }
        return n;
    }

    public static CertStore createCertStore(List<Object> certificates, String ... providerNames) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        CollectionCertStoreParameters certStoreParameters = new CollectionCertStoreParameters(certificates);
        if (providerNames == null || providerNames.length == 0) {
            return CertStore.getInstance(CERT_STORE_TYPE_COLLECTION, certStoreParameters);
        }
        List<String> providerNamesList = Arrays.asList(providerNames);
        for (String providerName : providerNames) {
            try {
                return CertStore.getInstance(CERT_STORE_TYPE_COLLECTION, (CertStoreParameters)certStoreParameters, providerName);
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException | NoSuchProviderException e) {
                if (providerNamesList.indexOf(providerName) != providerNamesList.size() - 1) continue;
                throw e;
            }
        }
        return null;
    }

    public static CertStore createBCCertStore(List<Object> certificates) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, NoSuchProviderException {
        return CertUtil.createCertStore(certificates, "BC");
    }
}

