/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jce;

import de.bos_bremen.algorithm_identifier.AlgorithmService;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.governikus.csl.uom.jce.CSLJCESignatureException;
import de.governikus.csl.uom.jce.ECDSAHelper;
import de.governikus.csl.uom.jce.JCEAlgorithmDefinition;
import de.governikus.csl.uom.jce.JceHelper;
import de.governikus.csl.uom.jce.remote.CSLJCERemoteSignatureException;
import de.governikus.csl.uom.jce.remote.RemoteSignature;
import de.governikus.csl.uom.jce.remote.RemoteSignaturePrivateKey;
import de.governikus.csl.uom.jcebase.JceInstanceHelper;
import de.governikus.csl.uom.res.PrivateKeyResource;
import de.governikus.csl.uom.res.ResourceFailedException;
import de.governikus.csl.utils.CryptoProviderUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureSpi;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PSSParameterSpec;
import java.util.Arrays;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSLSignatureSpi
extends SignatureSpi {
    public static final String ACCOUNTING_MSG = "accounting";
    private static final String JCE_PROVIDER_BC = "BC";
    private static final String JCE_PROVIDER_OCF = "OCF";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CSLSignatureSpi.class.getName());
    protected String algorithmName;
    private final Map<String, JCEAlgorithmDefinition> algorithms;
    private AlgorithmParameterSpec delegateParameterSpec;
    private Signature delegateSignature;
    private PrivateKeyResource keyResource;
    private String digestAlgorithmURI;
    private String signatureAlgorithmURI;
    private static final Boolean NO_SIGNATURE_MATCH_CHECK_CAN_BE_DONE = null;

    CSLSignatureSpi(String algorithmName, String signatureAlgorithmURI, String digestAlgorithmURI) {
        this(algorithmName, algorithmName, signatureAlgorithmURI, digestAlgorithmURI);
    }

    CSLSignatureSpi(String algorithmName, JCEAlgorithmDefinition delegateSignatureAlgorithm, String signatureAlgorithmURI, String digestAlgorithmURI) {
        this(algorithmName, JCEAlgorithmDefinition.toMap(delegateSignatureAlgorithm), signatureAlgorithmURI, digestAlgorithmURI);
    }

    CSLSignatureSpi(String algorithmName, Map<String, JCEAlgorithmDefinition> algorithms, String signatureAlgorithmURI, String digestAlgorithmURI) {
        if (algorithmName == null || algorithmName.isEmpty()) {
            throw new IllegalArgumentException("algorithm name can not be null or empty");
        }
        if (algorithms == null || algorithms.isEmpty()) {
            throw new IllegalArgumentException("algorithms can not be null or empty");
        }
        if (!algorithms.containsKey(null)) {
            throw new IllegalArgumentException("default algorithm for key null, any provider must be specified");
        }
        if (signatureAlgorithmURI == null || signatureAlgorithmURI.isEmpty()) {
            throw new IllegalArgumentException("signature algorithm URI can not be null or empty");
        }
        if (digestAlgorithmURI == null || digestAlgorithmURI.isEmpty()) {
            throw new IllegalArgumentException("digest algorithm URI can not be null or empty");
        }
        this.algorithmName = algorithmName;
        this.signatureAlgorithmURI = signatureAlgorithmURI;
        this.digestAlgorithmURI = digestAlgorithmURI;
        this.algorithms = algorithms;
        this.delegateParameterSpec = null;
    }

    CSLSignatureSpi(String algorithmName, String delegateSignatureAlgorithm, String signatureAlgorithmURI, String digestAlgorithmURI) {
        this(algorithmName, new JCEAlgorithmDefinition(delegateSignatureAlgorithm), signatureAlgorithmURI, digestAlgorithmURI);
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String param) {
        return this.delegateSignature.getParameter(param);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return this.delegateSignature.getParameters();
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engineInitSign(privateKey, null);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        PrivateKey signPrivateKey = this.prepareDelegateSignature(privateKey, PrivateKey.class);
        if (random == null) {
            this.delegateSignature.initSign(signPrivateKey);
        } else {
            this.delegateSignature.initSign(signPrivateKey, random);
        }
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        PublicKey verifyPublicKey = this.prepareDelegateVerify(publicKey, PublicKey.class);
        this.delegateSignature.initVerify(verifyPublicKey);
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        this.delegateParameterSpec = params;
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String param, Object value) {
        this.delegateSignature.setParameter(param, value);
    }

    @Override
    protected byte[] engineSign() throws CSLJCESignatureException, CSLJCERemoteSignatureException {
        byte[] signatureValue = null;
        try {
            JceHelper.logDoFinalStart(LOGGER, "signing", this.keyResource);
            signatureValue = this.delegateSignature.sign();
            CSLSignatureSpi.doSignatureValueMathCheck(this.keyResource, this.signatureAlgorithmURI, this.digestAlgorithmURI, null, signatureValue, this.delegateSignature instanceof RemoteSignature, true);
            byte[] byArray = signatureValue;
            return byArray;
        }
        catch (CSLJCESignatureException | CSLJCERemoteSignatureException e) {
            throw e;
        }
        catch (Exception e) {
            throw JceHelper.throwSignatureException(e, this.delegateSignature instanceof RemoteSignature);
        }
        finally {
            JceHelper.logDoFinalEnd(LOGGER, "signing", this.keyResource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int engineSign(byte[] outbuf, int offset, int len) throws CSLJCESignatureException, CSLJCERemoteSignatureException {
        try {
            JceHelper.logDoFinalStart(LOGGER, "signing", this.keyResource);
            int n = this.delegateSignature.sign(outbuf, offset, len);
            return n;
        }
        catch (CSLJCESignatureException | CSLJCERemoteSignatureException e) {
            throw e;
        }
        catch (Exception e) {
            JceHelper.throwSignatureException(e, this.delegateSignature instanceof RemoteSignature);
        }
        finally {
            JceHelper.logDoFinalEnd(LOGGER, "signing", this.keyResource);
        }
        return 0;
    }

    @Override
    protected void engineUpdate(byte b) throws CSLJCESignatureException, CSLJCERemoteSignatureException {
        if (this.delegateParameterSpec instanceof DigestValueToASN1AlgorithmSpec) {
            throw JceHelper.throwSignatureException(true, this.delegateSignature instanceof RemoteSignature, "on digest signing do not update digest value byte by byte, use byte[]-array or ByteBuffer method instead to update with digest value in a single step");
        }
        try {
            this.delegateSignature.update(b);
        }
        catch (CSLJCESignatureException | CSLJCERemoteSignatureException e) {
            throw e;
        }
        catch (Exception e) {
            throw JceHelper.throwSignatureException(e, this.delegateSignature instanceof RemoteSignature);
        }
    }

    @Override
    protected void engineUpdate(byte[] b, int off, int len) throws CSLJCESignatureException, CSLJCERemoteSignatureException {
        try {
            if (!(this.delegateSignature instanceof RemoteSignature) && this.delegateParameterSpec instanceof DigestValueToASN1AlgorithmSpec && off == 0 && len == b.length) {
                byte[] b2 = b;
                try {
                    b2 = ((DigestValueToASN1AlgorithmSpec)this.delegateParameterSpec).modifyDigest(b).getEncoded();
                }
                catch (IOException e) {
                    throw JceHelper.throwSignatureException(e, this.delegateSignature instanceof RemoteSignature, "failed to convert digest to a DigestInfo");
                }
                this.delegateSignature.update(b2, 0, b2.length);
                return;
            }
            this.delegateSignature.update(b, off, len);
        }
        catch (CSLJCESignatureException | CSLJCERemoteSignatureException e) {
            throw e;
        }
        catch (Exception e) {
            throw JceHelper.throwSignatureException(e, this.delegateSignature instanceof RemoteSignature);
        }
    }

    @Override
    protected void engineUpdate(ByteBuffer input) {
        if (!(this.delegateSignature instanceof RemoteSignature) && this.delegateParameterSpec instanceof DigestValueToASN1AlgorithmSpec) {
            byte[] b2 = null;
            try {
                b2 = ((DigestValueToASN1AlgorithmSpec)this.delegateParameterSpec).modifyDigest(Arrays.copyOfRange(input.array(), input.position(), input.limit())).getEncoded();
            }
            catch (Exception e) {
                throw new ProviderException("failed to convert digest to a DigestInfo", e);
            }
            try {
                this.delegateSignature.update(b2, 0, b2.length);
            }
            catch (Exception e) {
                throw new ProviderException("failed to update delegate digest instance: " + e.getMessage(), e);
            }
            return;
        }
        try {
            this.delegateSignature.update(input);
        }
        catch (Exception e) {
            throw new ProviderException("failed to update delegate digest instance: " + e.getMessage(), e);
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws CSLJCESignatureException, CSLJCERemoteSignatureException {
        try {
            JceHelper.logDoFinalStart(LOGGER, "verifying", this.keyResource);
            boolean bl = this.delegateSignature.verify(sigBytes);
            return bl;
        }
        catch (CSLJCESignatureException | CSLJCERemoteSignatureException e) {
            throw e;
        }
        catch (Exception e) {
            throw JceHelper.throwSignatureException(e, false);
        }
        finally {
            JceHelper.logDoFinalEnd(LOGGER, "verifying", this.keyResource);
        }
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes, int offset, int length) throws CSLJCESignatureException, CSLJCERemoteSignatureException {
        try {
            JceHelper.logDoFinalStart(LOGGER, "verifying", this.keyResource);
            boolean bl = this.delegateSignature.verify(sigBytes, offset, length);
            return bl;
        }
        catch (CSLJCESignatureException | CSLJCERemoteSignatureException e) {
            throw e;
        }
        catch (Exception e) {
            throw JceHelper.throwSignatureException(e, false);
        }
        finally {
            JceHelper.logDoFinalEnd(LOGGER, "verifying", this.keyResource);
        }
    }

    protected JCEAlgorithmDefinition getJCEAlgorithmDefinition(String jceProviderName) throws InvalidKeyException {
        JCEAlgorithmDefinition jceAlgorithmDefinition = this.algorithms.get(jceProviderName);
        if (jceAlgorithmDefinition == null && jceProviderName != null) {
            jceAlgorithmDefinition = this.algorithms.get(null);
        }
        if (jceAlgorithmDefinition == null) {
            throw new InvalidKeyException("no algorithm definition for provider: " + jceProviderName);
        }
        return jceAlgorithmDefinition;
    }

    private <K extends Key> K prepareDelegateSignature(Key key, Class<K> keyClass) throws InvalidKeyException {
        String jceProviderName = null;
        this.keyResource = JceHelper.checkGetPrivateKeyResource(key);
        jceProviderName = this.keyResource.getJCEProviderName();
        JCEAlgorithmDefinition jceAlgorithmDefinition = this.getJCEAlgorithmDefinition(jceProviderName);
        AlgorithmParameterSpec defSpec = jceAlgorithmDefinition.algorithmParameterSpec;
        if (this.delegateParameterSpec == null) {
            this.delegateParameterSpec = defSpec;
        }
        String algorithm = jceAlgorithmDefinition.algorithmName;
        try {
            this.delegateSignature = this.keyResource.isKeyAccessible() && this.keyResource.getKey() instanceof RemoteSignaturePrivateKey ? new RemoteSignature(this.algorithmName, this.signatureAlgorithmURI, this.digestAlgorithmURI, this.delegateParameterSpec) : JceInstanceHelper.getSignature((String)algorithm, (String)jceProviderName);
            if (this.delegateParameterSpec != null && !(this.delegateParameterSpec instanceof DigestValueToASN1AlgorithmSpec)) {
                this.delegateSignature.setParameter(this.delegateParameterSpec);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidKeyException((Throwable)JceHelper.toCoreException("failed to create delegate signature instance using algorithm'" + algorithm + "': " + e.getMessage(), e));
        }
        catch (NoSuchProviderException e) {
            throw new InvalidKeyException((Throwable)JceHelper.toCoreException("failed to create delegate signature instance using provider '" + jceProviderName + "': " + e.getMessage(), e));
        }
        catch (Exception e) {
            throw new InvalidKeyException((Throwable)JceHelper.toCoreException("failed to create delegate signature instance using provider '" + jceProviderName + "' and algorithm '" + algorithm + "': " + e.getMessage(), e));
        }
        Key delegateKey = null;
        try {
            delegateKey = this.keyResource.getKey();
        }
        catch (ResourceFailedException e) {
            throw new InvalidKeyException((Throwable)JceHelper.toCoreException("failed to get key of resource: " + e.getMessage(), (Exception)((Object)e)));
        }
        if (!keyClass.isInstance(delegateKey)) {
            throw new InvalidKeyException((Throwable)JceHelper.toCoreException("key of resource must be a " + keyClass.getName() + ": " + key.getClass().getName() + ", key to use for signing: " + delegateKey));
        }
        return (K)((Key)keyClass.cast(delegateKey));
    }

    private <K extends Key> K prepareDelegateVerify(Key key, Class<K> keyClass) throws InvalidKeyException {
        JceHelper.checkGetPublicKey(key);
        JCEAlgorithmDefinition jceAlgorithmDefinition = this.getJCEAlgorithmDefinition(CryptoProviderUtil.PROVIDER);
        try {
            AlgorithmParameterSpec defSpec = jceAlgorithmDefinition.algorithmParameterSpec;
            if (this.delegateParameterSpec == null) {
                this.delegateParameterSpec = defSpec;
            }
            this.delegateSignature = Signature.getInstance(jceAlgorithmDefinition.algorithmName, CryptoProviderUtil.PROVIDER);
            if (this.delegateParameterSpec != null && !(this.delegateParameterSpec instanceof DigestValueToASN1AlgorithmSpec)) {
                this.delegateSignature.setParameter(this.delegateParameterSpec);
            }
        }
        catch (Exception e) {
            throw new InvalidKeyException("failed to create delegate signature instance: " + e.getMessage(), e);
        }
        Key delegateKey = key;
        if (!keyClass.isInstance(key)) {
            throw new InvalidKeyException("key must be a " + keyClass.getName() + ": " + key.getClass().getName());
        }
        return (K)((Key)keyClass.cast(delegateKey));
    }

    public static Boolean doSignatureValueMathCheck(PrivateKeyResource privateKeyResource, String signatureAlgorithmURI, String digestAlgorithmURI, byte[] digestValue, byte[] signatureValue, boolean remote, boolean throwException) throws CSLJCESignatureException, CSLJCERemoteSignatureException {
        if (signatureValue == null || signatureValue.length == 0) {
            JceHelper.throwSignatureException(true, remote, "illegal signature value detected");
        }
        if (privateKeyResource == null) {
            JceHelper.throwSignatureException(throwException, remote, "key resource not available");
            return NO_SIGNATURE_MATCH_CHECK_CAN_BE_DONE;
        }
        if (privateKeyResource.getCertificateChain().certificates().isEmpty()) {
            return Boolean.TRUE;
        }
        Certificate signerCertificate = privateKeyResource.getCertificate().certificate();
        if (signerCertificate == null) {
            JceHelper.throwSignatureException(throwException, remote, "signer certificate not available");
            return NO_SIGNATURE_MATCH_CHECK_CAN_BE_DONE;
        }
        PublicKey signerPublicKey = signerCertificate.getPublicKey();
        if (signerPublicKey == null) {
            JceHelper.throwSignatureException(throwException, remote, "signer public key not available");
            return NO_SIGNATURE_MATCH_CHECK_CAN_BE_DONE;
        }
        return Boolean.TRUE;
    }

    public static class RsaSha3x512Spi
    extends CSLSignatureSpi {
        public RsaSha3x512Spi() {
            super("SHA3-512withRSA", "http://www.w3.org/2007/05/xmldsig-more#rsa-sha3-512", "http://www.w3.org/2007/05/xmldsig-more#sha3-512");
        }
    }

    public static class RsaSha3x512PssSpi
    extends CSLSignatureSpi {
        public RsaSha3x512PssSpi() {
            super("SHA3-512withRSAandMGF1", "http://www.w3.org/2007/05/xmldsig-more#sha3-512-rsa-MGF1", "http://www.w3.org/2007/05/xmldsig-more#sha3-512");
        }
    }

    public static class RsaSha3x512PssHashSpi
    extends CSLSignatureSpi {
        public RsaSha3x512PssHashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA3-512hashedWithRSAandMGF1", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("RAWRSASSA-PSS", Signature.getInstance("SHA3-512withRSAandMGF1", CSLSignatureSpi.JCE_PROVIDER_BC).getParameters().getParameterSpec(PSSParameterSpec.class), null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA3-512hashedWithRSAandMGF1", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2007/05/xmldsig-more#sha3-512-rsa-MGF1", "http://www.w3.org/2007/05/xmldsig-more#sha3-512");
        }
    }

    public static class RsaSha3x512HashSpi
    extends CSLSignatureSpi {
        public RsaSha3x512HashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA3-512hashedWithRSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithRSA", new DigestValueToASN1AlgorithmSpec("SHA3-512"), null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA3-512hashedWithRSA", CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2007/05/xmldsig-more#rsa-sha3-512", "http://www.w3.org/2007/05/xmldsig-more#sha3-512");
        }
    }

    public static class RsaSha3x384Spi
    extends CSLSignatureSpi {
        public RsaSha3x384Spi() {
            super("SHA3-384withRSA", "http://www.w3.org/2007/05/xmldsig-more#rsa-sha3-384", "http://www.w3.org/2007/05/xmldsig-more#sha3-384");
        }
    }

    public static class RsaSha3x384PssSpi
    extends CSLSignatureSpi {
        public RsaSha3x384PssSpi() {
            super("SHA3-384withRSAandMGF1", "http://www.w3.org/2007/05/xmldsig-more#sha3-384-rsa-MGF1", "http://www.w3.org/2007/05/xmldsig-more#sha3-384");
        }
    }

    public static class RsaSha3x384PssHashSpi
    extends CSLSignatureSpi {
        public RsaSha3x384PssHashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA3-384hashedWithRSAandMGF1", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("RAWRSASSA-PSS", Signature.getInstance("SHA3-384withRSAandMGF1", CSLSignatureSpi.JCE_PROVIDER_BC).getParameters().getParameterSpec(PSSParameterSpec.class), null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA3-384hashedWithRSAandMGF1", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2007/05/xmldsig-more#sha3-384-rsa-MGF1", "http://www.w3.org/2007/05/xmldsig-more#sha3-384");
        }
    }

    public static class RsaSha3x384HashSpi
    extends CSLSignatureSpi {
        public RsaSha3x384HashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA3-384hashedWithRSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithRSA", new DigestValueToASN1AlgorithmSpec("SHA3-384"), null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA3-384hashedWithRSA", CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2007/05/xmldsig-more#rsa-sha3-384", "http://www.w3.org/2007/05/xmldsig-more#sha3-384");
        }
    }

    public static class RsaSha3x256Spi
    extends CSLSignatureSpi {
        public RsaSha3x256Spi() {
            super("SHA3-256withRSA", "http://www.w3.org/2007/05/xmldsig-more#rsa-sha3-256", "http://www.w3.org/2007/05/xmldsig-more#sha3-256");
        }
    }

    public static class RsaSha3x256PssSpi
    extends CSLSignatureSpi {
        public RsaSha3x256PssSpi() {
            super("SHA3-256withRSAandMGF1", "http://www.w3.org/2007/05/xmldsig-more#sha3-256-rsa-MGF1", "http://www.w3.org/2007/05/xmldsig-more#sha3-256");
        }
    }

    public static class RsaSha3x256PssHashSpi
    extends CSLSignatureSpi {
        public RsaSha3x256PssHashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA3-256hashedWithRSAandMGF1", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("RAWRSASSA-PSS", Signature.getInstance("SHA3-256withRSAandMGF1", CSLSignatureSpi.JCE_PROVIDER_BC).getParameters().getParameterSpec(PSSParameterSpec.class), null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA3-256hashedWithRSAandMGF1", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2007/05/xmldsig-more#sha3-256-rsa-MGF1", "http://www.w3.org/2007/05/xmldsig-more#sha3-256");
        }
    }

    public static class RsaSha3x256HashSpi
    extends CSLSignatureSpi {
        public RsaSha3x256HashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA3-256hashedWithRSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithRSA", new DigestValueToASN1AlgorithmSpec("SHA3-256"), null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA3-256hashedWithRSA", CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2007/05/xmldsig-more#rsa-sha3-256", "http://www.w3.org/2007/05/xmldsig-more#sha3-256");
        }
    }

    public static class RsaSha3x224Spi
    extends CSLSignatureSpi {
        public RsaSha3x224Spi() {
            super("SHA3-224withRSA", "http://www.w3.org/2007/05/xmldsig-more#rsa-sha3-224", "http://www.w3.org/2007/05/xmldsig-more#sha3-224");
        }
    }

    public static class RsaSha3x224PssSpi
    extends CSLSignatureSpi {
        public RsaSha3x224PssSpi() {
            super("SHA3-224withRSAandMGF1", "http://www.w3.org/2007/05/xmldsig-more#sha3-224-rsa-MGF1", "http://www.w3.org/2007/05/xmldsig-more#sha3-224");
        }
    }

    public static class RsaSha3x224PssHashSpi
    extends CSLSignatureSpi {
        public RsaSha3x224PssHashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA3-224hashedWithRSAandMGF1", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("RAWRSASSA-PSS", Signature.getInstance("SHA3-224withRSAandMGF1", CSLSignatureSpi.JCE_PROVIDER_BC).getParameters().getParameterSpec(PSSParameterSpec.class), null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA3-224hashedWithRSAandMGF1", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2007/05/xmldsig-more#sha3-224-rsa-MGF1", "http://www.w3.org/2007/05/xmldsig-more#sha3-224");
        }
    }

    public static class RsaSha3x224HashSpi
    extends CSLSignatureSpi {
        public RsaSha3x224HashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA3-224hashedWithRSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithRSA", new DigestValueToASN1AlgorithmSpec("SHA3-224"), null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA3-224hashedWithRSA", CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2007/05/xmldsig-more#rsa-sha3-224", "http://www.w3.org/2007/05/xmldsig-more#sha3-224");
        }
    }

    public static class RsaSha2x512Spi
    extends CSLSignatureSpi {
        public RsaSha2x512Spi() {
            super("SHA512withRSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", "http://www.w3.org/2001/04/xmlenc#sha512");
        }
    }

    public static class RsaSha2x512PssSpi
    extends CSLSignatureSpi {
        public RsaSha2x512PssSpi() {
            super("SHA512withRSAandMGF1", "http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1", "http://www.w3.org/2001/04/xmlenc#sha512");
        }
    }

    public static class RsaSha2x512PssHashSpi
    extends CSLSignatureSpi {
        public RsaSha2x512PssHashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA512hashedWithRSAandMGF1", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("RAWRSASSA-PSS", Signature.getInstance("SHA512withRSAandMGF1", CSLSignatureSpi.JCE_PROVIDER_BC).getParameters().getParameterSpec(PSSParameterSpec.class), null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA512withRSAandMGF1", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1", "http://www.w3.org/2001/04/xmlenc#sha512");
        }
    }

    public static class RsaSha2x512HashSpi
    extends CSLSignatureSpi {
        public RsaSha2x512HashSpi() {
            super("SHA512hashedWithRSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithRSA", new DigestValueToASN1AlgorithmSpec("SHA512"), null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA512hashedWithRSAandMGF1", CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", "http://www.w3.org/2001/04/xmlenc#sha512");
        }
    }

    public static class RsaSha2x384Spi
    extends CSLSignatureSpi {
        public RsaSha2x384Spi() {
            super("SHA384withRSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384", "http://www.w3.org/2001/04/xmldsig-more#sha384");
        }
    }

    public static class RsaSha2x384PssSpi
    extends CSLSignatureSpi {
        public RsaSha2x384PssSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA384withRSAandMGF1", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("SHA384withRSAandMGF1", Signature.getInstance("SHA384withRSAandMGF1", CSLSignatureSpi.JCE_PROVIDER_BC).getParameters().getParameterSpec(PSSParameterSpec.class), null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA384withRSAandMGF1", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2007/05/xmldsig-more#sha384-rsa-MGF1", "http://www.w3.org/2001/04/xmldsig-more#sha384");
        }
    }

    public static class RsaSha2x384PssHashSpi
    extends CSLSignatureSpi {
        public RsaSha2x384PssHashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA384hashedWithRSAandMGF1", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("RAWRSASSA-PSS", Signature.getInstance("SHA384withRSAandMGF1", CSLSignatureSpi.JCE_PROVIDER_BC).getParameters().getParameterSpec(PSSParameterSpec.class), null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("NONEwithRSA", Signature.getInstance("SHA384withRSAandMGF1", CSLSignatureSpi.JCE_PROVIDER_BC).getParameters().getParameterSpec(PSSParameterSpec.class), "SunMSCAPI"), new JCEAlgorithmDefinition("SHA384hashedWithRSAandMGF1", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2007/05/xmldsig-more#sha384-rsa-MGF1", "http://www.w3.org/2001/04/xmldsig-more#sha384");
        }
    }

    public static class RsaSha2x384HashSpi
    extends CSLSignatureSpi {
        public RsaSha2x384HashSpi() {
            super("SHA384hashedWithRSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithRSA", new DigestValueToASN1AlgorithmSpec("SHA384"), null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA384hashedWithRSA", CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384", "http://www.w3.org/2001/04/xmldsig-more#sha384");
        }
    }

    public static class RsaSha2x256Spi
    extends CSLSignatureSpi {
        public RsaSha2x256Spi() {
            super("SHA256withRSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "http://www.w3.org/2001/04/xmlenc#sha256");
        }
    }

    public static class RsaSha2x256PssSpi
    extends CSLSignatureSpi {
        public RsaSha2x256PssSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA256withRSAandMGF1", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("SHA256withRSAandMGF1", Signature.getInstance("SHA256withRSAandMGF1", CSLSignatureSpi.JCE_PROVIDER_BC).getParameters().getParameterSpec(PSSParameterSpec.class), null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA256withRSAandMGF1", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1", "http://www.w3.org/2001/04/xmlenc#sha256");
        }
    }

    public static class RsaSha2x256PssHashSpi
    extends CSLSignatureSpi {
        public RsaSha2x256PssHashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA256hashedWithRSAandMGF1", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("RAWRSASSA-PSS", Signature.getInstance("SHA256withRSAandMGF1", CSLSignatureSpi.JCE_PROVIDER_BC).getParameters().getParameterSpec(PSSParameterSpec.class), null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("NONEwithRSA", Signature.getInstance("SHA256withRSAandMGF1", CSLSignatureSpi.JCE_PROVIDER_BC).getParameters().getParameterSpec(PSSParameterSpec.class), "SunMSCAPI"), new JCEAlgorithmDefinition("SHA256hashedWithRSAandMGF1", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1", "http://www.w3.org/2001/04/xmlenc#sha256");
        }
    }

    public static class RsaSha2x256HashSpi
    extends CSLSignatureSpi {
        public RsaSha2x256HashSpi() {
            super("SHA256hashedWithRSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithRSA", new DigestValueToASN1AlgorithmSpec("SHA256"), null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA256hashedWithRSA", CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", "http://www.w3.org/2001/04/xmlenc#sha256");
        }
    }

    public static class RsaSha2x224Spi
    extends CSLSignatureSpi {
        public RsaSha2x224Spi() {
            super("SHA224withRSA", "http://www.w3.org/2007/05/xmldsig-more#rsa-sha224", "http://www.w3.org/2001/04/xmldsig-more#sha224");
        }
    }

    public static class RsaSha2x224PssSpi
    extends CSLSignatureSpi {
        public RsaSha2x224PssSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA224withRSAandMGF1", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("SHA224withRSAandMGF1", Signature.getInstance("SHA224withRSAandMGF1", CSLSignatureSpi.JCE_PROVIDER_BC).getParameters().getParameterSpec(PSSParameterSpec.class), null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA224withRSAandMGF1", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2007/05/xmldsig-more#sha224-rsa-MGF1", "http://www.w3.org/2001/04/xmldsig-more#sha224");
        }
    }

    public static class RsaSha2x224PssHashSpi
    extends CSLSignatureSpi {
        public RsaSha2x224PssHashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA224hashedWithRSAandMGF1", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("RAWRSASSA-PSS", Signature.getInstance("SHA224withRSAandMGF1", CSLSignatureSpi.JCE_PROVIDER_BC).getParameters().getParameterSpec(PSSParameterSpec.class), null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("NONEwithRSA", Signature.getInstance("SHA224withRSAandMGF1", CSLSignatureSpi.JCE_PROVIDER_BC).getParameters().getParameterSpec(PSSParameterSpec.class), "SunMSCAPI"), new JCEAlgorithmDefinition("SHA224hashedWithRSAandMGF1", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2007/05/xmldsig-more#sha224-rsa-MGF1", "http://www.w3.org/2001/04/xmldsig-more#sha224");
        }
    }

    public static class RsaSha2x224HashSpi
    extends CSLSignatureSpi {
        public RsaSha2x224HashSpi() {
            super("SHA224hashedWithRSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithRSA", new DigestValueToASN1AlgorithmSpec("SHA224"), null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA224hashedWithRSA", CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2007/05/xmldsig-more#rsa-sha224", "http://www.w3.org/2001/04/xmldsig-more#sha224");
        }
    }

    public static class RsaSha1Spi
    extends CSLSignatureSpi {
        public RsaSha1Spi() {
            super("SHA1withRSA", "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2000/09/xmldsig#sha1");
        }
    }

    public static class RsaSha1PssSpi
    extends CSLSignatureSpi {
        public RsaSha1PssSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA1withRSAandMGF1", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("SHA1withRSAandMGF1", Signature.getInstance("SHA1withRSAandMGF1", CSLSignatureSpi.JCE_PROVIDER_BC).getParameters().getParameterSpec(PSSParameterSpec.class), null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA1withRSAandMGF1", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2007/05/xmldsig-more#sha1-rsa-MGF1", "http://www.w3.org/2000/09/xmldsig#sha1");
        }
    }

    public static class RsaSha1PssHashSpi
    extends CSLSignatureSpi {
        public RsaSha1PssHashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA1hashedWithRSAandMGF1", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("RAWRSASSA-PSS", Signature.getInstance("SHA1withRSAandMGF1", CSLSignatureSpi.JCE_PROVIDER_BC).getParameters().getParameterSpec(PSSParameterSpec.class), null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("NONEwithRSA", Signature.getInstance("SHA1withRSAandMGF1", CSLSignatureSpi.JCE_PROVIDER_BC).getParameters().getParameterSpec(PSSParameterSpec.class), "SunMSCAPI"), new JCEAlgorithmDefinition("SHA1hashedWithRSAandMGF1", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2007/05/xmldsig-more#sha1-rsa-MGF1", "http://www.w3.org/2000/09/xmldsig#sha1");
        }
    }

    public static class RsaSha1HashSpi
    extends CSLSignatureSpi {
        public RsaSha1HashSpi() {
            super("SHA1hashedWithRSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithRSA", new DigestValueToASN1AlgorithmSpec("SHA1"), null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA1hashedWithRSA", CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2000/09/xmldsig#rsa-sha1", "http://www.w3.org/2000/09/xmldsig#sha1");
        }
    }

    public static class RsaRipemd160Spi
    extends CSLSignatureSpi {
        public RsaRipemd160Spi() {
            super("RIPEMD160withRSA", "http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160", "http://www.w3.org/2001/04/xmlenc#ripemd160");
        }
    }

    public static class RsaRipemd160HashSpi
    extends CSLSignatureSpi {
        public RsaRipemd160HashSpi() {
            super("RIPEMD160hashedWithRSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithRSA", new DigestValueToASN1AlgorithmSpec("RIPEMD160"), null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("RIPEMD160hashedWithRSA", CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160", "http://www.w3.org/2001/04/xmlenc#ripemd160");
        }
    }

    public static class EcdsaSha3x512Spi
    extends CSLSignatureSpi {
        public EcdsaSha3x512Spi() {
            super("SHA3-512withECDSA", "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-512-ansi", "http://www.w3.org/2007/05/xmldsig-more#sha3-512");
        }
    }

    public static class EcdsaSha3x512HashSpi
    extends CSLSignatureSpi {
        public EcdsaSha3x512HashSpi() {
            super("SHA3-512hashedWithECDSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithECDSA", (AlgorithmParameterSpec)null, null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA3-512hashedWithECDSA", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-512-ansi", "http://www.w3.org/2007/05/xmldsig-more#sha3-512");
        }
    }

    public static class EcdsaSha3x512CvcSpi
    extends BaseCSLWithCVCECDSASignatureSpi {
        public EcdsaSha3x512CvcSpi() {
            super("SHA3-512withCVC-ECDSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("SHA3-512withECDSA", (AlgorithmParameterSpec)null, null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA3-512hashedWithCVC-ECDSA", CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-512", "http://www.w3.org/2007/05/xmldsig-more#sha3-512");
        }
    }

    public static class EcdsaSha3x512CvcHashSpi
    extends BaseCSLWithCVCECDSASignatureSpi {
        public EcdsaSha3x512CvcHashSpi() {
            super("SHA3-512hashedWithCVC-ECDSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithECDSA", (AlgorithmParameterSpec)null, null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA3-512hashedWithCVC-ECDSA", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-512", "http://www.w3.org/2007/05/xmldsig-more#sha3-512");
        }
    }

    public static class EcdsaSha3x384Spi
    extends CSLSignatureSpi {
        public EcdsaSha3x384Spi() {
            super("SHA3-384withECDSA", "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-384-ansi", "http://www.w3.org/2007/05/xmldsig-more#sha3-384");
        }
    }

    public static class EcdsaSha3x384HashSpi
    extends CSLSignatureSpi {
        public EcdsaSha3x384HashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA3-384hashedWithECDSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithECDSA", (AlgorithmParameterSpec)null, null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA3-384hashedWithECDSA", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-384-ansi", "http://www.w3.org/2007/05/xmldsig-more#sha3-384");
        }
    }

    public static class EcdsaSha3x384CvcSpi
    extends BaseCSLWithCVCECDSASignatureSpi {
        public EcdsaSha3x384CvcSpi() {
            super("SHA3-384withCVC-ECDSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("SHA3-384withECDSA", (AlgorithmParameterSpec)null, null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA3-384withCVC-ECDSA", CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-384", "http://www.w3.org/2007/05/xmldsig-more#sha3-384");
        }
    }

    public static class EcdsaSha3x384CvcHashSpi
    extends BaseCSLWithCVCECDSASignatureSpi {
        public EcdsaSha3x384CvcHashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA3-384hashedWithCVC-ECDSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithECDSA", (AlgorithmParameterSpec)null, null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA3-384hashedWithCVC-ECDSA", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-384", "http://www.w3.org/2007/05/xmldsig-more#sha3-384");
        }
    }

    public static class EcdsaSha3x256Spi
    extends CSLSignatureSpi {
        public EcdsaSha3x256Spi() {
            super("SHA3-256withECDSA", "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-256-ansi", "http://www.w3.org/2007/05/xmldsig-more#sha3-256");
        }
    }

    public static class EcdsaSha3x256HashSpi
    extends CSLSignatureSpi {
        public EcdsaSha3x256HashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA3-256hashedWithECDSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithECDSA", (AlgorithmParameterSpec)null, null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA3-256hashedWithECDSA", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-256-ansi", "http://www.w3.org/2007/05/xmldsig-more#sha3-256");
        }
    }

    public static class EcdsaSha3x256CvcSpi
    extends BaseCSLWithCVCECDSASignatureSpi {
        public EcdsaSha3x256CvcSpi() {
            super("SHA3-256withCVC-ECDSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("SHA3-256withECDSA", (AlgorithmParameterSpec)null, null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA3-256withCVC-ECDSA", CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-256", "http://www.w3.org/2007/05/xmldsig-more#sha3-256");
        }
    }

    public static class EcdsaSha3x256CvcHashSpi
    extends BaseCSLWithCVCECDSASignatureSpi {
        public EcdsaSha3x256CvcHashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA3-256hashedWithCVC-ECDSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithECDSA", (AlgorithmParameterSpec)null, null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA3-256hashedWithCVC-ECDSA", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-256", "http://www.w3.org/2007/05/xmldsig-more#sha3-256");
        }
    }

    public static class EcdsaSha3x224Spi
    extends CSLSignatureSpi {
        public EcdsaSha3x224Spi() {
            super("SHA3-224withECDSA", "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-224-ansi", "http://www.w3.org/2007/05/xmldsig-more#sha3-224");
        }
    }

    public static class EcdsaSha3x224HashSpi
    extends CSLSignatureSpi {
        public EcdsaSha3x224HashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA3-224hashedWithECDSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithECDSA", (AlgorithmParameterSpec)null, null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA3-224hashedWithECDSA", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-224-ansi", "http://www.w3.org/2007/05/xmldsig-more#sha3-224");
        }
    }

    public static class EcdsaSha3x224CvcSpi
    extends BaseCSLWithCVCECDSASignatureSpi {
        public EcdsaSha3x224CvcSpi() {
            super("SHA3-224withCVC-ECDSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("SHA3-224withECDSA", (AlgorithmParameterSpec)null, null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA3-224withCVC-ECDSA", CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-224", "http://www.w3.org/2007/05/xmldsig-more#sha3-224");
        }
    }

    public static class EcdsaSha3x224CvcHashSpi
    extends BaseCSLWithCVCECDSASignatureSpi {
        public EcdsaSha3x224CvcHashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA3-224hashedWithCVC-ECDSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithECDSA", (AlgorithmParameterSpec)null, null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA3-224hashedWithCVC-ECDSA", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2017/08/xmldsig-more#ecdsa-sha3-224", "http://www.w3.org/2007/05/xmldsig-more#sha3-224");
        }
    }

    public static class EcdsaSha2x512Spi
    extends CSLSignatureSpi {
        public EcdsaSha2x512Spi() {
            super("SHA512withECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512-ansi", "http://www.w3.org/2001/04/xmlenc#sha512");
        }
    }

    public static class EcdsaSha2x512HashSpi
    extends CSLSignatureSpi {
        public EcdsaSha2x512HashSpi() {
            super("SHA512hashedWithECDSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithECDSA", (AlgorithmParameterSpec)null, null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA512withECDSA", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512-ansi", "http://www.w3.org/2001/04/xmlenc#sha512");
        }
    }

    public static class EcdsaSha2x512CvcSpi
    extends CSLSignatureSpi {
        public EcdsaSha2x512CvcSpi() {
            super("SHA512withCVC-ECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512", "http://www.w3.org/2001/04/xmlenc#sha512");
        }
    }

    public static class EcdsaSha2x512CvcHashSpi
    extends BaseCSLWithCVCECDSASignatureSpi {
        public EcdsaSha2x512CvcHashSpi() {
            super("SHA512hashedWithCVC-ECDSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithECDSA", (AlgorithmParameterSpec)null, null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA512hashedWithCVC-ECDSA", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512", "http://www.w3.org/2001/04/xmlenc#sha512");
        }
    }

    public static class EcdsaSha2x384Spi
    extends CSLSignatureSpi {
        public EcdsaSha2x384Spi() {
            super("SHA384withECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384-ansi", "http://www.w3.org/2001/04/xmldsig-more#sha384");
        }
    }

    public static class EcdsaSha2x384HashSpi
    extends CSLSignatureSpi {
        public EcdsaSha2x384HashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA384hashedWithECDSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithECDSA", (AlgorithmParameterSpec)null, null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA384hashedWithECDSA", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384-ansi", "http://www.w3.org/2001/04/xmldsig-more#sha384");
        }
    }

    public static class EcdsaSha2x384CvcSpi
    extends CSLSignatureSpi {
        public EcdsaSha2x384CvcSpi() {
            super("SHA384withCVC-ECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384", "http://www.w3.org/2001/04/xmldsig-more#sha384");
        }
    }

    public static class EcdsaSha2x384CvcHashSpi
    extends BaseCSLWithCVCECDSASignatureSpi {
        public EcdsaSha2x384CvcHashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA384hashedWithCVC-ECDSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithECDSA", (AlgorithmParameterSpec)null, null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA384hashedWithCVC-ECDSA", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384", "http://www.w3.org/2001/04/xmldsig-more#sha384");
        }
    }

    public static class EcdsaSha2x256Spi
    extends CSLSignatureSpi {
        public EcdsaSha2x256Spi() {
            super("SHA256withECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256-ansi", "http://www.w3.org/2001/04/xmlenc#sha256");
        }
    }

    public static class EcdsaSha2x256HashSpi
    extends CSLSignatureSpi {
        public EcdsaSha2x256HashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA256hashedWithECDSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithECDSA", (AlgorithmParameterSpec)null, null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA256hashedWithECDSA", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256-ansi", "http://www.w3.org/2001/04/xmlenc#sha256");
        }
    }

    public static class EcdsaSha2x256CvcSpi
    extends CSLSignatureSpi {
        public EcdsaSha2x256CvcSpi() {
            super("SHA256withCVC-ECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", "http://www.w3.org/2001/04/xmlenc#sha256");
        }
    }

    public static class EcdsaSha2x256CvcHashSpi
    extends BaseCSLWithCVCECDSASignatureSpi {
        public EcdsaSha2x256CvcHashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA256hashedWithCVC-ECDSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithECDSA", (AlgorithmParameterSpec)null, null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA256hashedWithCVC-ECDSA", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", "http://www.w3.org/2001/04/xmlenc#sha256");
        }
    }

    public static class EcdsaSha2x224Spi
    extends CSLSignatureSpi {
        public EcdsaSha2x224Spi() {
            super("SHA224withECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224-ansi", "http://www.w3.org/2001/04/xmldsig-more#sha224");
        }
    }

    public static class EcdsaSha2x224HashSpi
    extends CSLSignatureSpi {
        public EcdsaSha2x224HashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA224hashedWithECDSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithECDSA", (AlgorithmParameterSpec)null, null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA224hashedWithECDSA", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224-ansi", "http://www.w3.org/2001/04/xmldsig-more#sha224");
        }
    }

    public static class EcdsaSha2x224CvcSpi
    extends CSLSignatureSpi {
        public EcdsaSha2x224CvcSpi() {
            super("SHA224withCVC-ECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224", "http://www.w3.org/2001/04/xmldsig-more#sha224");
        }
    }

    public static class EcdsaSha2x224CvcHashSpi
    extends BaseCSLWithCVCECDSASignatureSpi {
        public EcdsaSha2x224CvcHashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA224hashedWithCVC-ECDSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithECDSA", (AlgorithmParameterSpec)null, null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA224hashedWithCVC-ECDSA", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224", "http://www.w3.org/2001/04/xmldsig-more#sha224");
        }
    }

    public static class EcdsaSha1Spi
    extends CSLSignatureSpi {
        public EcdsaSha1Spi() {
            super("SHA1withECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1-ansi", "http://www.w3.org/2000/09/xmldsig#sha1");
        }
    }

    public static class EcdsaSha1HashSpi
    extends CSLSignatureSpi {
        public EcdsaSha1HashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA1hashedWithECDSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithECDSA", (AlgorithmParameterSpec)null, null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA1hashedWithECDSA", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1-ansi", "http://www.w3.org/2000/09/xmldsig#sha1");
        }
    }

    public static class EcdsaSha1CvcSpi
    extends CSLSignatureSpi {
        public EcdsaSha1CvcSpi() {
            super("SHA1withCVC-ECDSA", "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1", "http://www.w3.org/2000/09/xmldsig#sha1");
        }
    }

    public static class EcdsaSha1CvcHashSpi
    extends BaseCSLWithCVCECDSASignatureSpi {
        public EcdsaSha1CvcHashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("SHA1hashedWithCVC-ECDSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithECDSA", (AlgorithmParameterSpec)null, null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("SHA1hashedWithCVC-ECDSA", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1", "http://www.w3.org/2000/09/xmldsig#sha1");
        }
    }

    public static class EcdsaRipemd160Spi
    extends CSLSignatureSpi {
        public EcdsaRipemd160Spi() {
            super("RIPEMD160withECDSA", "http://www.w3.org/2007/05/xmldsig-more#ecdsa-ripemd160-ansi", "http://www.w3.org/2001/04/xmlenc#ripemd160");
        }
    }

    public static class EcdsaRipemd160HashSpi
    extends CSLSignatureSpi {
        public EcdsaRipemd160HashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("RIPEMD160hashedWithECDSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithECDSA", (AlgorithmParameterSpec)null, null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("RIPEMD160hashedWithECDSA", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2007/05/xmldsig-more#ecdsa-ripemd160-ansi", "http://www.w3.org/2001/04/xmlenc#ripemd160");
        }
    }

    public static class EcdsaRipemd160CvcSpi
    extends BaseCSLWithCVCECDSASignatureSpi {
        public EcdsaRipemd160CvcSpi() {
            super("RIPEMD160withECDSA", "http://www.w3.org/2007/05/xmldsig-more#ecdsa-ripemd160", "http://www.w3.org/2001/04/xmlenc#ripemd160");
        }
    }

    public static class EcdsaRipemd160CvcHashSpi
    extends BaseCSLWithCVCECDSASignatureSpi {
        public EcdsaRipemd160CvcHashSpi() throws InvalidParameterSpecException, NoSuchAlgorithmException, NoSuchProviderException {
            super("RIPEMD160hashedWithECDSA", JCEAlgorithmDefinition.toMap(new JCEAlgorithmDefinition("NONEwithECDSA", (AlgorithmParameterSpec)null, null, CSLSignatureSpi.JCE_PROVIDER_BC), new JCEAlgorithmDefinition("RIPEMD160hashedWithCVC-ECDSA", (AlgorithmParameterSpec)null, CSLSignatureSpi.JCE_PROVIDER_OCF)), "http://www.w3.org/2007/05/xmldsig-more#ecdsa-ripemd160", "http://www.w3.org/2001/04/xmlenc#ripemd160");
        }

        @Override
        protected boolean engineVerify(byte[] sigBytes) throws CSLJCESignatureException, CSLJCERemoteSignatureException {
            byte[] lSigBytes = null;
            try {
                lSigBytes = ECDSAHelper.convertXMLDSIGtoASN1(sigBytes);
            }
            catch (IOException e) {
                throw JceHelper.throwSignatureException(e, false);
            }
            return super.engineVerify(lSigBytes);
        }
    }

    public static class DigestValueToASN1AlgorithmSpec
    implements AlgorithmParameterSpec {
        private final String digestAlgorithm;

        public DigestValueToASN1AlgorithmSpec(String digestAlgorithm) {
            this.digestAlgorithm = digestAlgorithm;
        }

        public DigestInfo modifyDigest(byte[] digest) throws IOException {
            DigestAlgorithm digestAlg = AlgorithmService.getDigestForJCAName((String)this.digestAlgorithm);
            if (digestAlg == null) {
                throw new IOException("no digest algorithm can be found to check digest size: " + this.digestAlgorithm);
            }
            int digestSize = digestAlg.getDigestSize();
            if (digestSize != digest.length) {
                throw new IOException("digest length not with expected digest size: " + digest.length + ", expected: " + digestSize);
            }
            AlgorithmIdentifier algorithmIdentifier = new DefaultDigestAlgorithmIdentifierFinder().find(this.digestAlgorithm);
            if (algorithmIdentifier.getParameters() == null) {
                algorithmIdentifier = new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), (ASN1Encodable)DERNull.INSTANCE);
            }
            return new DigestInfo(algorithmIdentifier, digest);
        }

        public byte[] getDigest(byte[] digestInfoBytes) throws IOException {
            if (digestInfoBytes == null || digestInfoBytes.length == 0) {
                throw new IOException("DigestInfo decoding impossible from null or empty byte[]-array");
            }
            DigestInfo digestInfo = null;
            try {
                digestInfo = DigestInfo.getInstance((Object)digestInfoBytes);
            }
            catch (IllegalArgumentException e) {
                return digestInfoBytes;
            }
            if (digestInfo == null) {
                throw new IOException("decoding DigestInfo failed");
            }
            return digestInfo.getDigest();
        }
    }

    public static class BaseCSLWithCVCECDSASignatureSpi
    extends CSLSignatureSpi {
        public BaseCSLWithCVCECDSASignatureSpi(String algorithmName, String signatureAlgorithmURI, String digestAlgorithmURI) {
            this(algorithmName, algorithmName, signatureAlgorithmURI, digestAlgorithmURI);
        }

        public BaseCSLWithCVCECDSASignatureSpi(String algorithmName, JCEAlgorithmDefinition delegateSignatureAlgorithm, String signatureAlgorithmURI, String digestAlgorithmURI) {
            super(algorithmName, delegateSignatureAlgorithm, signatureAlgorithmURI, digestAlgorithmURI);
        }

        public BaseCSLWithCVCECDSASignatureSpi(String algorithmName, Map<String, JCEAlgorithmDefinition> algorithms, String signatureAlgorithmURI, String digestAlgorithmURI) {
            super(algorithmName, algorithms, signatureAlgorithmURI, digestAlgorithmURI);
        }

        public BaseCSLWithCVCECDSASignatureSpi(String algorithmName, String delegateSignatureAlgorithm, String signatureAlgorithmURI, String digestAlgorithmURI) {
            super(algorithmName, delegateSignatureAlgorithm, signatureAlgorithmURI, digestAlgorithmURI);
        }

        @Override
        protected final byte[] engineSign() throws CSLJCESignatureException, CSLJCERemoteSignatureException {
            byte[] signatureValue = super.engineSign();
            LOGGER.info("signature value format must be converted from X9.62 (ANSI) to plain/XML format, when required");
            try {
                return ECDSAHelper.convertASN1toXMLDSIG(signatureValue);
            }
            catch (IOException e) {
                throw JceHelper.throwSignatureException(e, ((CSLSignatureSpi)this).delegateSignature instanceof RemoteSignature);
            }
        }

        @Override
        protected boolean engineVerify(byte[] sigBytes) throws CSLJCESignatureException, CSLJCERemoteSignatureException {
            JCEAlgorithmDefinition jceAlgorithmDefinition;
            byte[] lSigBytes = sigBytes;
            try {
                jceAlgorithmDefinition = this.getJCEAlgorithmDefinition(CryptoProviderUtil.PROVIDER);
            }
            catch (InvalidKeyException e) {
                throw JceHelper.throwSignatureException(e, false);
            }
            if (this.algorithmName.contains("SHA3-") && this.algorithmName.contains("CVC-ECDSA") || jceAlgorithmDefinition != null && "NONEwithECDSA".equals(jceAlgorithmDefinition.algorithmName) || this.algorithmName.equals("RIPEMD160withECDSA")) {
                LOGGER.info("signature value format not supported: converting signature value to X9.62 (ANSI) for verification using BouncyCastle provided signature instance, {}", (Object)"SHA3-Digest, CVC, Hash signature or RIPEMD160");
                try {
                    lSigBytes = ECDSAHelper.convertXMLDSIGtoASN1(sigBytes);
                }
                catch (IOException e) {
                    throw JceHelper.throwSignatureException(e, false);
                }
            }
            return super.engineVerify(lSigBytes);
        }
    }
}

