/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jce;

import de.governikus.csl.uom.jce.CSLJCESignatureException;
import de.governikus.csl.uom.jce.JceHelper;
import de.governikus.csl.uom.jce.JceRAWSpiState;
import de.governikus.csl.uom.jce.RAWAlgorithmParameterSpec;
import de.governikus.csl.uom.jce.remote.CSLJCERemoteSignatureException;
import de.governikus.csl.uom.jce.remote.RemoteSignature;
import de.governikus.csl.uom.jce.remote.RemoteSignaturePrivateKey;
import de.governikus.csl.uom.jcebase.XMLOIDJCEAlgorithmMapper;
import de.governikus.csl.uom.res.PrivateKeyResource;
import de.governikus.csl.uom.res.ResourceFailedException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureSpi;
import java.security.cert.Certificate;
import java.security.spec.AlgorithmParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSLRAWSignatureSpi
extends SignatureSpi {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CSLRAWSignatureSpi.class.getName());
    private RAWAlgorithmParameterSpec spec = null;
    private Signature delegate = null;
    private JceRAWSpiState state = JceRAWSpiState.INIT;
    private PrivateKeyResource keyResource = null;
    private static final Boolean NO_SIGNATURE_MATCH_CHECK_CAN_BE_DONE = null;

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.checkCurrentState(JceRAWSpiState.SPEC_SET, false);
        this.prepareDelegateVerify(publicKey);
        try {
            this.checkCurrentState(JceRAWSpiState.DELEGATE_INSTANCE_CREATED, false);
            this.delegate.initVerify(publicKey);
            this.changeState(JceRAWSpiState.DELEGATE_INSTANCE_INITIALIZED);
        }
        catch (InvalidKeyException e) {
            this.changeState(JceRAWSpiState.ERROR);
            throw e;
        }
    }

    private void checkCurrentState(JceRAWSpiState expectedState, boolean ignoreError) {
        if (this.state != expectedState) {
            switch (expectedState) {
                case ERROR: {
                    if (ignoreError) break;
                    throw new IllegalStateException("instance not usable");
                }
                case SPEC_SET: {
                    throw new IllegalStateException("algorithm parameters or algorithm spec not set yet, delegate instance not creatable at current state");
                }
                case DELEGATE_INSTANCE_CREATED: {
                    throw new IllegalStateException("delegate instance not created set yet, delegate instance not initializable at current state");
                }
                case DELEGATE_INSTANCE_INITIALIZED: {
                    throw new IllegalStateException("delegate instance not initialized yet, delegate instance not usable at current state");
                }
            }
        }
    }

    @Override
    protected synchronized void engineInitSign(PrivateKey key) throws InvalidKeyException {
        this.prepareDelegateSignature(key);
        try {
            this.checkCurrentState(JceRAWSpiState.DELEGATE_INSTANCE_CREATED, false);
            this.delegate.initSign(key);
            this.changeState(JceRAWSpiState.DELEGATE_INSTANCE_INITIALIZED);
        }
        catch (InvalidKeyException e) {
            this.changeState(JceRAWSpiState.ERROR);
            throw e;
        }
    }

    private void prepareDelegateSignature(Key key) throws InvalidKeyException {
        this.checkCurrentState(JceRAWSpiState.SPEC_SET, false);
        this.keyResource = JceHelper.checkGetPrivateKeyResource(key);
        if (this.delegate != null) {
            return;
        }
        try {
            this.delegate = CSLRAWSignatureSpi.createDelegateInstance(key, this.spec);
            this.changeState(JceRAWSpiState.DELEGATE_INSTANCE_CREATED);
        }
        catch (IllegalArgumentException | InvalidKeyException e) {
            this.changeState(JceRAWSpiState.ERROR);
            throw e;
        }
    }

    private void prepareDelegateVerify(Key key) throws InvalidKeyException {
        this.checkCurrentState(JceRAWSpiState.SPEC_SET, false);
        if (this.delegate != null) {
            return;
        }
        JceHelper.checkGetPublicKey(key);
        try {
            this.delegate = CSLRAWSignatureSpi.createDelegateInstance(key, this.spec);
            this.changeState(JceRAWSpiState.DELEGATE_INSTANCE_CREATED);
        }
        catch (IllegalArgumentException | InvalidKeyException e) {
            this.changeState(JceRAWSpiState.ERROR);
            throw e;
        }
    }

    public static Signature createDelegateInstance(Key key, RAWAlgorithmParameterSpec spec) throws InvalidKeyException {
        if (spec == null) {
            throw new IllegalArgumentException("specification for creating signature required");
        }
        String signatureAlgorithmURI = spec.getAlgorithmURI();
        String signatureAlgorithmJCE = XMLOIDJCEAlgorithmMapper.getMapper().mapXMLAlgorithmJCE(signatureAlgorithmURI);
        if (signatureAlgorithmJCE == null) {
            throw new InvalidKeyException("mapping of signature algorithm URI can not be resolved to a known JCE signature algorithm: " + signatureAlgorithmURI);
        }
        if (spec.isDigestToBeSigned()) {
            signatureAlgorithmJCE = signatureAlgorithmJCE.replaceAll("with", "hashedWith");
        }
        return CSLRAWSignatureSpi.createDelegateInstance(key, signatureAlgorithmJCE, signatureAlgorithmURI, spec.getDigestAlgorithmURI());
    }

    private static Signature createDelegateInstance(Key key, String algorithm, String signatureAlgorithmURI, String digestAlgorithmURI) throws InvalidKeyException {
        PrivateKeyResource keyResource = null;
        if (PrivateKey.class.isInstance(key) && !PrivateKeyResource.class.isInstance(key)) {
            String msg = "only PrivateKeyResource supported for PrivateKey: " + (key == null ? null : key.getClass());
            InvalidKeyException ike = new InvalidKeyException(msg);
            LOGGER.error("msg", (Throwable)ike);
            throw ike;
        }
        if (PrivateKey.class.isInstance(key) && PrivateKeyResource.class.isInstance(key)) {
            keyResource = (PrivateKeyResource)PrivateKeyResource.class.cast(key);
        }
        if (algorithm == null || algorithm.isEmpty()) {
            throw new InvalidKeyException("algorithm can not be null or empty");
        }
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("jceSignatureAlgorithm: %1s", algorithm));
            }
            if (keyResource != null && keyResource.isKeyAccessible() && keyResource.getKey() instanceof RemoteSignaturePrivateKey) {
                return new RemoteSignature(algorithm, signatureAlgorithmURI, digestAlgorithmURI, null);
            }
            return Signature.getInstance(algorithm, "CPP");
        }
        catch (ResourceFailedException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new InvalidKeyException(e);
        }
    }

    @Override
    protected synchronized void engineUpdate(byte b) throws CSLJCESignatureException, CSLJCERemoteSignatureException {
        this.checkCurrentState(JceRAWSpiState.DELEGATE_INSTANCE_INITIALIZED, false);
        try {
            this.delegate.update(b);
        }
        catch (CSLJCESignatureException | CSLJCERemoteSignatureException e) {
            this.changeState(JceRAWSpiState.ERROR);
            throw e;
        }
        catch (Exception e) {
            this.changeState(JceRAWSpiState.ERROR);
            throw JceHelper.throwSignatureException(e, this.delegate instanceof RemoteSignature);
        }
    }

    @Override
    protected synchronized void engineUpdate(byte[] b, int off, int len) throws CSLJCESignatureException, CSLJCERemoteSignatureException {
        this.checkCurrentState(JceRAWSpiState.DELEGATE_INSTANCE_INITIALIZED, false);
        try {
            this.delegate.update(b, off, len);
        }
        catch (CSLJCESignatureException | CSLJCERemoteSignatureException e) {
            this.changeState(JceRAWSpiState.ERROR);
            throw e;
        }
        catch (Exception e) {
            this.changeState(JceRAWSpiState.ERROR);
            throw JceHelper.throwSignatureException(e, this.delegate instanceof RemoteSignature);
        }
    }

    @Override
    protected synchronized void engineSetParameter(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params instanceof RAWAlgorithmParameterSpec) {
            this.spec = (RAWAlgorithmParameterSpec)params;
            this.changeState(JceRAWSpiState.SPEC_SET);
            return;
        }
        this.checkCurrentState(JceRAWSpiState.ERROR, false);
        if (JceRAWSpiState.DELEGATE_INSTANCE_CREATED == this.state && params != null) {
            this.delegate.setParameter(params);
            return;
        }
        this.changeState(JceRAWSpiState.INIT);
        throw new InvalidAlgorithmParameterException("only RAWAlgorithmParameterSpec is supported, reset");
    }

    @Override
    protected synchronized byte[] engineSign() throws CSLJCESignatureException, CSLJCERemoteSignatureException {
        this.checkCurrentState(JceRAWSpiState.DELEGATE_INSTANCE_INITIALIZED, false);
        byte[] signatureValue = null;
        try {
            signatureValue = this.delegate.sign();
            CSLRAWSignatureSpi.doSignatureValueMathCheck(this.keyResource, this.spec.getAlgorithmURI(), this.spec.getDigestAlgorithmURI(), null, signatureValue, this.delegate instanceof RemoteSignature, true);
            return signatureValue;
        }
        catch (CSLJCESignatureException | CSLJCERemoteSignatureException e) {
            this.changeState(JceRAWSpiState.ERROR);
            throw e;
        }
        catch (Exception e) {
            this.changeState(JceRAWSpiState.ERROR);
            throw JceHelper.throwSignatureException(e, this.delegate instanceof RemoteSignature);
        }
    }

    private void changeState(JceRAWSpiState newState) {
        if (this.state == newState) {
            return;
        }
        if (newState.isSpecToBeReset()) {
            this.spec = null;
        }
        if (newState.isSpiToBeReset()) {
            this.delegate = null;
        }
        this.state = newState;
    }

    @Override
    protected boolean engineVerify(byte[] sigBytes) throws CSLJCESignatureException, CSLJCERemoteSignatureException {
        this.checkCurrentState(JceRAWSpiState.DELEGATE_INSTANCE_INITIALIZED, false);
        try {
            return this.delegate.verify(sigBytes);
        }
        catch (CSLJCESignatureException | CSLJCERemoteSignatureException e) {
            this.changeState(JceRAWSpiState.ERROR);
            throw e;
        }
        catch (Exception e) {
            this.changeState(JceRAWSpiState.ERROR);
            throw JceHelper.throwSignatureException(e, this.delegate instanceof RemoteSignature);
        }
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String param, Object value) {
        try {
            this.engineSetParameter(RAWAlgorithmParameterSpec.fromParameterValue(param, value));
        }
        catch (InvalidAlgorithmParameterException e) {
            InvalidParameterException ipe = new InvalidParameterException(e.getMessage());
            ipe.initCause(e);
            throw ipe;
        }
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String param) {
        throw new UnsupportedOperationException();
    }

    public static Boolean doSignatureValueMathCheck(PrivateKeyResource privateKeyResource, String signatureAlgorithmURI, String digestAlgorithmURI, byte[] digestValue, byte[] signatureValue, boolean remote, boolean throwException) throws CSLJCESignatureException, CSLJCERemoteSignatureException {
        if (signatureValue == null || signatureValue.length == 0) {
            JceHelper.throwSignatureException(true, remote, "illegal signature value detected");
        }
        if (privateKeyResource == null) {
            JceHelper.throwSignatureException(throwException, remote, "key resource not available");
            return NO_SIGNATURE_MATCH_CHECK_CAN_BE_DONE;
        }
        Certificate signerCertificate = privateKeyResource.getCertificate().certificate();
        if (signerCertificate == null) {
            JceHelper.throwSignatureException(throwException, remote, "signer certificate not available");
            return NO_SIGNATURE_MATCH_CHECK_CAN_BE_DONE;
        }
        PublicKey signerPublicKey = signerCertificate.getPublicKey();
        if (signerPublicKey == null) {
            JceHelper.throwSignatureException(throwException, remote, "signer public key not available");
            return NO_SIGNATURE_MATCH_CHECK_CAN_BE_DONE;
        }
        return Boolean.TRUE;
    }
}

