/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jce;

import de.governikus.csl.uom.jce.CSLJCECipherException;
import de.governikus.csl.uom.jce.JceHelper;
import de.governikus.csl.uom.jce.JceRAWSpiState;
import de.governikus.csl.uom.jce.RAWAlgorithmParameterSpec;
import de.governikus.csl.uom.jce.remote.CSLJCERemoteCipherException;
import de.governikus.csl.uom.jce.remote.RemoteCipher;
import de.governikus.csl.uom.jce.remote.RemoteCipherKey;
import de.governikus.csl.uom.jcebase.XMLOIDJCEAlgorithmMapper;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSLRAWCipherSpi
extends CipherSpi {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CSLRAWCipherSpi.class.getName());
    private RAWAlgorithmParameterSpec spec = null;
    private Cipher delegate = null;
    private JceRAWSpiState state = JceRAWSpiState.INIT;
    private String mode;
    private String padding;

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.checkCurrentState(JceRAWSpiState.DELEGATE_INSTANCE_INITIALIZED, false);
        return this.delegate.doFinal(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws CSLJCECipherException, CSLJCERemoteCipherException {
        try {
            this.checkCurrentState(JceRAWSpiState.DELEGATE_INSTANCE_INITIALIZED, false);
            return this.delegate.doFinal(input, inputOffset, inputLen);
        }
        catch (CSLJCECipherException | CSLJCERemoteCipherException e) {
            throw e;
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw JceHelper.throwCipherException(e, this.delegate instanceof RemoteCipher);
        }
    }

    @Override
    protected int engineDoFinal(ByteBuffer input, ByteBuffer output) throws CSLJCECipherException, CSLJCERemoteCipherException {
        this.checkCurrentState(JceRAWSpiState.DELEGATE_INSTANCE_INITIALIZED, false);
        try {
            return this.delegate.doFinal(input, output);
        }
        catch (CSLJCECipherException | CSLJCERemoteCipherException e) {
            throw e;
        }
        catch (BadPaddingException | IllegalBlockSizeException | ShortBufferException e) {
            throw JceHelper.throwCipherException(e, this.delegate instanceof RemoteCipher);
        }
    }

    @Override
    protected int engineGetBlockSize() {
        this.checkCurrentState(JceRAWSpiState.DELEGATE_INSTANCE_INITIALIZED, false);
        return this.delegate.getBlockSize();
    }

    @Override
    protected byte[] engineGetIV() {
        this.checkCurrentState(JceRAWSpiState.DELEGATE_INSTANCE_INITIALIZED, false);
        return this.delegate.getIV();
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return JceHelper.getKeySize(key);
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        this.checkCurrentState(JceRAWSpiState.DELEGATE_INSTANCE_INITIALIZED, false);
        return this.delegate.getOutputSize(inputLen);
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        this.checkCurrentState(JceRAWSpiState.DELEGATE_INSTANCE_INITIALIZED, false);
        return this.delegate.getParameters();
    }

    @Override
    protected synchronized void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            try {
                this.spec = params.getParameterSpec(RAWAlgorithmParameterSpec.class);
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidAlgorithmParameterException(e);
            }
            this.changeState(JceRAWSpiState.SPEC_SET);
        }
        this.engineBaseInit();
        this.delegate.init(opmode, key, params, random);
        this.changeState(JceRAWSpiState.DELEGATE_INSTANCE_INITIALIZED);
    }

    @Override
    protected synchronized void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params instanceof RAWAlgorithmParameterSpec) {
            this.spec = (RAWAlgorithmParameterSpec)params;
            this.changeState(JceRAWSpiState.SPEC_SET);
            params = null;
        }
        this.engineBaseInit();
        this.delegate.init(opmode, key, params, random);
        this.changeState(JceRAWSpiState.DELEGATE_INSTANCE_INITIALIZED);
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this.checkCurrentState(JceRAWSpiState.INIT, false);
        this.spec = new RAWAlgorithmParameterSpec(key.getAlgorithm() + "/" + this.mode + this.padding, "");
        this.checkCurrentState(JceRAWSpiState.SPEC_SET, false);
        this.createDelegate(key);
        this.checkCurrentState(JceRAWSpiState.DELEGATE_INSTANCE_INITIALIZED, false);
        this.delegate.init(opmode, key, random);
        this.changeState(JceRAWSpiState.DELEGATE_INSTANCE_INITIALIZED);
    }

    private void engineBaseInit() throws InvalidKeyException {
        this.checkCurrentState(JceRAWSpiState.SPEC_SET, false);
        this.createDelegate(null);
        this.checkCurrentState(JceRAWSpiState.DELEGATE_INSTANCE_CREATED, false);
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        this.mode = mode;
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        this.padding = padding;
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        this.checkCurrentState(JceRAWSpiState.DELEGATE_INSTANCE_INITIALIZED, false);
        return this.delegate.unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        this.checkCurrentState(JceRAWSpiState.DELEGATE_INSTANCE_INITIALIZED, false);
        return this.delegate.update(input, inputOffset, inputLen, output, outputOffset);
    }

    @Override
    protected int engineUpdate(ByteBuffer input, ByteBuffer output) throws ShortBufferException {
        this.checkCurrentState(JceRAWSpiState.DELEGATE_INSTANCE_INITIALIZED, false);
        return this.delegate.update(input, output);
    }

    @Override
    protected void engineUpdateAAD(byte[] src, int offset, int len) {
        this.checkCurrentState(JceRAWSpiState.DELEGATE_INSTANCE_INITIALIZED, false);
        this.delegate.updateAAD(src, offset, len);
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer src) {
        this.checkCurrentState(JceRAWSpiState.DELEGATE_INSTANCE_INITIALIZED, false);
        this.delegate.updateAAD(src);
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return this.delegate.wrap(key);
    }

    private void checkCurrentState(JceRAWSpiState expectedState, boolean ignoreError) {
        if (this.state != expectedState) {
            switch (expectedState) {
                case ERROR: {
                    if (ignoreError) break;
                    throw new IllegalStateException("instance not usable");
                }
                case SPEC_SET: {
                    throw new IllegalStateException("algorithm parameters or algorithm spec not set yet, delegate instance not creatable at current state");
                }
                case DELEGATE_INSTANCE_CREATED: {
                    throw new IllegalStateException("delegate instance not created set yet, delegate instance not initializable at current state");
                }
                case DELEGATE_INSTANCE_INITIALIZED: {
                    throw new IllegalStateException("delegate instance not initialized yet, delegate instance not usable at current state");
                }
            }
        }
    }

    private void createDelegate(Key key) throws InvalidKeyException {
        this.checkCurrentState(JceRAWSpiState.SPEC_SET, false);
        if (this.delegate != null) {
            return;
        }
        try {
            this.delegate = CSLRAWCipherSpi.createDelegateInstance(key, this.spec);
            this.changeState(JceRAWSpiState.DELEGATE_INSTANCE_CREATED);
        }
        catch (IllegalArgumentException | InvalidKeyException e) {
            this.changeState(JceRAWSpiState.ERROR);
            throw e;
        }
    }

    public static Cipher createDelegateInstance(Key key, RAWAlgorithmParameterSpec spec) throws InvalidKeyException {
        if (spec == null) {
            throw new IllegalArgumentException("specification for creating cipher required");
        }
        String algoId = spec.getAlgorithmURI();
        String algorithm = XMLOIDJCEAlgorithmMapper.getMapper().mapXMLAlgorithmJCE(algoId);
        if (algorithm == null) {
            try {
                CSLRAWCipherSpi.createDelegateInstance(key, algoId);
            }
            catch (InvalidKeyException e) {
                throw new InvalidKeyException("mapping for algorithm seems to be incomplete: " + algoId);
            }
        }
        return CSLRAWCipherSpi.createDelegateInstance(key, algorithm);
    }

    private static Cipher createDelegateInstance(Key key, String algorithm) throws InvalidKeyException {
        if (algorithm == null || algorithm.isEmpty()) {
            throw new InvalidKeyException("algorithm can not be null or empty");
        }
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("jceAlgorithm: %1s", algorithm));
            }
            if (key instanceof RemoteCipherKey) {
                return new RemoteCipher(algorithm);
            }
            return Cipher.getInstance(algorithm, "CPP");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new InvalidKeyException(e);
        }
    }

    private void changeState(JceRAWSpiState newState) {
        if (this.state == newState) {
            return;
        }
        if (newState.isSpecToBeReset()) {
            this.spec = null;
        }
        if (newState.isSpiToBeReset()) {
            this.delegate = null;
        }
        this.state = newState;
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        this.checkCurrentState(JceRAWSpiState.DELEGATE_INSTANCE_INITIALIZED, false);
        return this.delegate.update(input, inputOffset, inputLen);
    }
}

