/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jce;

import de.governikus.csl.utils.CryptoProviderUtil;
import java.security.MessageDigest;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;

public class CSLMessageDigestSpi
extends MessageDigestSpi {
    private MessageDigest md;
    public final String DELEGATE_DIGEST_JCE_PROVIDER_NAME = "BC";

    private CSLMessageDigestSpi(String jceDigestName) {
        try {
            this.md = MessageDigest.getInstance(jceDigestName, CryptoProviderUtil.PROVIDER);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void engineUpdate(byte input) {
        this.md.update(input);
    }

    @Override
    protected void engineUpdate(byte[] input, int offset, int len) {
        this.md.update(input, offset, len);
    }

    @Override
    protected byte[] engineDigest() {
        return this.md.digest();
    }

    @Override
    protected void engineReset() {
        this.md.reset();
    }

    public static class SHA3x512
    extends CSLMessageDigestSpi {
        public SHA3x512() {
            super("SHA3-512");
        }
    }

    public static class SHA3x384
    extends CSLMessageDigestSpi {
        public SHA3x384() {
            super("SHA3-384");
        }
    }

    public static class SHA3x256
    extends CSLMessageDigestSpi {
        public SHA3x256() {
            super("SHA3-256");
        }
    }

    public static class SHA3x224
    extends CSLMessageDigestSpi {
        public SHA3x224() {
            super("SHA3-224");
        }
    }

    public static class SHA2x512
    extends CSLMessageDigestSpi {
        public SHA2x512() {
            super("SHA512");
        }
    }

    public static class SHA2x384
    extends CSLMessageDigestSpi {
        public SHA2x384() {
            super("SHA384");
        }
    }

    public static class SHA2x256
    extends CSLMessageDigestSpi {
        public SHA2x256() {
            super("SHA256");
        }
    }

    public static class SHA2x224
    extends CSLMessageDigestSpi {
        public SHA2x224() {
            super("SHA224");
        }
    }

    public static class SHA1
    extends CSLMessageDigestSpi {
        public SHA1() {
            super("SHA1");
        }
    }

    public static class RIPEMD160
    extends CSLMessageDigestSpi {
        public RIPEMD160() {
            super("RIPEMD160");
        }
    }
}

