/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jce;

import de.governikus.csl.uom.jce.CSLCertificateFactory;
import de.governikus.csl.uom.jce.CSLCipherSpi;
import de.governikus.csl.uom.jce.CSLMessageDigestSpi;
import de.governikus.csl.uom.jce.CSLRAWCipherSpi;
import de.governikus.csl.uom.jce.CSLRAWSignatureSpi;
import de.governikus.csl.uom.jce.CSLSignatureSpi;
import de.governikus.csl.uom.jcebase.AlgorithmConstants;
import de.governikus.csl.uom.jcebase.XMLOIDJCEAlgorithmMapper;
import de.governikus.csl.uom.res.KeyResource;
import java.security.MessageDigestSpi;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureSpi;
import javax.crypto.CipherSpi;
import org.bouncycastle.jcajce.provider.asymmetric.rsa.AlgorithmParametersSpi;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class CSLCryptoProvider
extends Provider {
    private static final String ALGORITHM_RAW = "RAW";
    public static final boolean DEFAULT_PUBLIC_KEY_SUPPORTED = false;
    public static final String INFO = "CSL Crypto Provider";
    public static final String JCE_PROVIDER_DIVIDER_KEY = ".";
    public static final String JCE_PROVIDER_DIVIDER_SUPPORTED = " ";
    public static final String JCE_PROVIDER_DIVIDER_SUPPORTED_VALUES = "|";
    public static final String JCE_PROVIDER_KEY_PREFIX_ALG = "Alg.";
    public static final String JCE_PROVIDER_KEY_PREFIX_ALIAS = "Alias.";
    public static final String JCE_PROVIDER_KEY_PREFIX_ALG_ALIAS = "Alg.Alias.";
    public static final String JCE_PROVIDER_KEY_PREFIX_ALGORITHM_OID = "OID.";
    public static final String JCE_PROVIDER_KEY_PREFIX_ALGORITHM_PARAMETERS = "AlgorithmParameters.";
    public static final String JCE_PROVIDER_KEY_PREFIX_CERTIFICATEFACTORY = "CertificateFactory.";
    public static final String JCE_PROVIDER_KEY_PREFIX_CIPHER = "Cipher.";
    public static final String JCE_PROVIDER_KEY_PREFIX_KEYAGREEMENT = "KeyAgreement.";
    public static final String JCE_PROVIDER_KEY_PREFIX_KEYFACTORY = "KeyFactory.";
    public static final String JCE_PROVIDER_KEY_PREFIX_KEYGENERATOR = "KeyGenerator.";
    public static final String JCE_PROVIDER_KEY_PREFIX_KEYPAIRGENERATOR = "KeyPairGenerator.";
    public static final String JCE_PROVIDER_KEY_PREFIX_MAC = "Mac.";
    public static final String JCE_PROVIDER_KEY_PREFIX_MESSAGE_DIGEST = "MessageDigest.";
    public static final String JCE_PROVIDER_KEY_PREFIX_SECRETKEYFACTORY = "SecretKeyFactory.";
    public static final String JCE_PROVIDER_KEY_PREFIX_SIGNATURE = "Signature.";
    public static final String JCE_PROVIDER_SUPPORTED = "Supported";
    public static final String JCE_PROVIDER_SUPPORTED_KEY_CLASSES = " SupportedKeyClasses";
    public static final String JCE_PROVIDER_SUPPORTED_KEY_FORMATS = " SupportedKeyFormats";
    public static final String JCE_PROVIDER_SUPPORTED_MODES = " SupportedModes";
    public static final String JCE_PROVIDER_SUPPORTED_PADDINGS = " SupportedPaddings";
    public static final String JCE_PROVIDER_VALUE_SUPPPORTED_KEY_FORMAT_PCKS8 = "PKCS#8";
    public static final String JCE_PROVIDER_VALUE_SUPPPORTED_KEY_FORMAT_X509 = "X.509";
    public static final String JCE_PROVIDER_VALUE_SUPPPORTED_KEY_FORMATS_VALUE_DEFAULT = "X.509|PKCS#8";
    public static final String PROVIDER_NAME = "CPP";
    public static final long serialVersionUID = 1L;
    public static final double VERSION = 1.0;

    public CSLCryptoProvider() {
        super(PROVIDER_NAME, 1.0, INFO);
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        this.registerSpecial();
        this.registerDigestAlgorithms();
        this.registerSignatureAlgorithms();
        this.registerCipherAlgorithms();
        this.initXMLSecuritySantuario();
    }

    private void registerCipherAlgorithms() {
        this.putCipher(ALGORITHM_RAW, null, CSLRAWCipherSpi.class, true);
        this.putCipher("RSA/ECB/PKCS1Padding", AlgorithmConstants.ID_KEYTRANSPORT_RSA_V1_5, CSLCipherSpi.RsaPkcs1v15Spi.class);
        this.putCipher("RSA/NONE/OAEPWithSHA1AndMGF1Padding", null, CSLCipherSpi.RsaSha1OaepSpi.class);
        this.putCipher("RSA/NONE/OAEPWithSHA224AndMGF1Padding", null, CSLCipherSpi.RsaSha2x224OeapSpi.class);
        this.putCipher("RSA/NONE/OAEPWithSHA256AndMGF1Padding", null, CSLCipherSpi.RsaSha2x256OeapSpi.class);
        this.putCipher("RSA/NONE/OAEPWithSHA384AndMGF1Padding", null, CSLCipherSpi.RsaSha2x384OeapSpi.class);
        this.putCipher("RSA/NONE/OAEPWithSHA512AndMGF1Padding", null, CSLCipherSpi.RsaSha2x512OaepSpi.class);
    }

    private void addAliasAlias(String jceProviderKeyPrefix, String alias, String jceName) {
        if (alias != null && !alias.isEmpty()) {
            super.put(JCE_PROVIDER_KEY_PREFIX_ALG_ALIAS + jceProviderKeyPrefix + alias, jceName);
        }
    }

    private void addAliasOID(String jceProviderKeyPrefix, String oid, String jceName) {
        if (oid != null && !oid.isEmpty()) {
            super.put(JCE_PROVIDER_KEY_PREFIX_ALG_ALIAS + jceProviderKeyPrefix + oid, jceName);
            super.put(JCE_PROVIDER_KEY_PREFIX_ALG_ALIAS + jceProviderKeyPrefix + JCE_PROVIDER_KEY_PREFIX_ALGORITHM_OID + oid, jceName);
        }
    }

    private void initXMLSecuritySantuario() {
    }

    private void putCipher(String jceName, String oid, Class<? extends CipherSpi> cipherSpiClass) {
        this.putCipher(jceName, oid, cipherSpiClass, false);
    }

    private void putCipher(String jceName, String oid, Class<? extends CipherSpi> cipherSpiClass, boolean publicKeySupported) {
        String jceCipherName = JCE_PROVIDER_KEY_PREFIX_CIPHER + jceName;
        super.put(jceCipherName, cipherSpiClass.getName());
        super.put(jceCipherName + JCE_PROVIDER_SUPPORTED_KEY_FORMATS, JCE_PROVIDER_VALUE_SUPPPORTED_KEY_FORMATS_VALUE_DEFAULT);
        super.put(jceCipherName + JCE_PROVIDER_SUPPORTED_KEY_CLASSES, KeyResource.class.getName() + (publicKeySupported ? JCE_PROVIDER_DIVIDER_SUPPORTED_VALUES + PublicKey.class.getName() : ""));
        super.put("Alg.Alias.Cipher." + oid, jceName);
        this.addAliasOID(JCE_PROVIDER_KEY_PREFIX_CIPHER, oid, jceName);
        super.put("Alg.Alias.Cipher." + XMLOIDJCEAlgorithmMapper.getMapper().mapJCEAlgorithmXML(jceName), jceName);
    }

    private void putSignature(String jceName, String oid, Class<? extends SignatureSpi> signatureSpiClass) {
        this.putSignature(jceName, oid, signatureSpiClass, false);
    }

    private void putSignature(String jceName, String oid, Class<? extends SignatureSpi> signatureSpiClass, boolean publicKeySupported) {
        String jceSignatureName = JCE_PROVIDER_KEY_PREFIX_SIGNATURE + jceName;
        super.put(jceSignatureName, signatureSpiClass.getName());
        super.put(jceSignatureName + JCE_PROVIDER_SUPPORTED_KEY_FORMATS, JCE_PROVIDER_VALUE_SUPPPORTED_KEY_FORMATS_VALUE_DEFAULT);
        super.put(jceSignatureName + JCE_PROVIDER_SUPPORTED_KEY_CLASSES, KeyResource.class.getName() + (publicKeySupported ? JCE_PROVIDER_DIVIDER_SUPPORTED_VALUES + PublicKey.class.getName() : ""));
        super.put("Alg.Alias.Signature." + oid, jceName);
        this.addAliasOID(JCE_PROVIDER_KEY_PREFIX_SIGNATURE, oid, jceName);
        super.put("Alg.Alias.Signature." + XMLOIDJCEAlgorithmMapper.getMapper().mapJCEAlgorithmXML(jceName), jceName);
    }

    private void putDigest(String jceName, String alias, String oid, Class<? extends MessageDigestSpi> messageDigestSpiClass) {
        String jceDigestName = JCE_PROVIDER_KEY_PREFIX_MESSAGE_DIGEST + jceName;
        super.put(jceDigestName, messageDigestSpiClass.getName());
        this.addAliasAlias(JCE_PROVIDER_KEY_PREFIX_MESSAGE_DIGEST, alias, jceName);
        this.addAliasOID(JCE_PROVIDER_KEY_PREFIX_MESSAGE_DIGEST, oid, jceName);
        super.put("Alg.Alias.MessageDigest." + XMLOIDJCEAlgorithmMapper.getMapper().mapJCEAlgorithmXML(jceName), jceName);
    }

    private void registerCertificateFactories() {
        this.put("CertificateFactory.X.509", CSLCertificateFactory.class.getName());
    }

    private void registerDigestAlgorithms() {
        this.putDigest("RIPEMD160", null, AlgorithmConstants.ID_DIGEST_RIPEMD160, CSLMessageDigestSpi.RIPEMD160.class);
        this.putDigest("SHA1", "SHA-1", AlgorithmConstants.ID_DIGEST_SHA1, CSLMessageDigestSpi.SHA1.class);
        this.putDigest("SHA224", "SHA-224", AlgorithmConstants.ID_DIGEST_SHA2_224, CSLMessageDigestSpi.SHA2x224.class);
        this.putDigest("SHA256", "SHA-256", AlgorithmConstants.ID_DIGEST_SHA2_256, CSLMessageDigestSpi.SHA2x256.class);
        this.putDigest("SHA384", "SHA-384", AlgorithmConstants.ID_DIGEST_SHA2_384, CSLMessageDigestSpi.SHA2x384.class);
        this.putDigest("SHA512", "SHA-512", AlgorithmConstants.ID_DIGEST_SHA2_512, CSLMessageDigestSpi.SHA2x512.class);
        this.putDigest("SHA3-224", null, AlgorithmConstants.ID_DIGEST_SHA3_224, CSLMessageDigestSpi.SHA3x224.class);
        this.putDigest("SHA3-256", null, AlgorithmConstants.ID_DIGEST_SHA3_256, CSLMessageDigestSpi.SHA3x256.class);
        this.putDigest("SHA3-384", null, AlgorithmConstants.ID_DIGEST_SHA3_384, CSLMessageDigestSpi.SHA3x384.class);
        this.putDigest("SHA3-512", null, AlgorithmConstants.ID_DIGEST_SHA3_512, CSLMessageDigestSpi.SHA3x512.class);
    }

    private void registerParameters() {
        this.put("AlgorithmParameters.PSS", AlgorithmParametersSpi.PSS.class.getName());
        this.put("Alg.Alias.AlgorithmParameters.RSAPSS", "PSS");
        this.put("Alg.Alias.AlgorithmParameters.RSASSA-PSS", "PSS");
        this.putParameters("RIPEMD160");
        this.putParameters("SHA1");
        this.putParameters("SHA224");
        this.putParameters("SHA256");
        this.putParameters("SHA384");
        this.putParameters("SHA512");
        this.putParameters("SHA3-224");
        this.putParameters("SHA3-256");
        this.putParameters("SHA3-384");
        this.putParameters("SHA3-512");
    }

    private void putParameters(String parameters) {
        this.put("Alg.Alias.AlgorithmParameters." + parameters + "withRSA/PSS", "PSS");
        this.put("Alg.Alias.AlgorithmParameters." + parameters + "WITHRSAANDMGF1", "PSS");
    }

    private void registerSignatureAlgorithms() {
        this.putSignature(ALGORITHM_RAW, null, CSLRAWSignatureSpi.class, true);
        this.putSignature("RIPEMD160withRSA", AlgorithmConstants.ID_SIGNATURE_RSA_RIPEMD160, CSLSignatureSpi.RsaRipemd160Spi.class);
        this.putSignature("RIPEMD160hashedWithRSA", null, CSLSignatureSpi.RsaRipemd160HashSpi.class);
        this.putSignature("SHA1withRSA", AlgorithmConstants.ID_SIGNATURE_RSA_SHA1, CSLSignatureSpi.RsaSha1Spi.class);
        this.putSignature("SHA1hashedWithRSA", null, CSLSignatureSpi.RsaSha1HashSpi.class);
        this.putSignature("SHA1withRSAandMGF1", null, CSLSignatureSpi.RsaSha1PssSpi.class);
        this.putSignature("SHA1hashedWithRSAandMGF1", null, CSLSignatureSpi.RsaSha1PssHashSpi.class);
        this.putSignature("SHA224withRSA", AlgorithmConstants.ID_SIGNATURE_RSA_SHA2_224, CSLSignatureSpi.RsaSha2x224Spi.class);
        this.putSignature("SHA224hashedWithRSA", null, CSLSignatureSpi.RsaSha2x224HashSpi.class);
        this.putSignature("SHA224withRSAandMGF1", null, CSLSignatureSpi.RsaSha2x224PssSpi.class);
        this.putSignature("SHA224hashedWithRSAandMGF1", null, CSLSignatureSpi.RsaSha2x224PssHashSpi.class);
        this.putSignature("SHA256withRSA", AlgorithmConstants.ID_SIGNATURE_RSA_SHA2_256, CSLSignatureSpi.RsaSha2x256Spi.class);
        this.putSignature("SHA256hashedWithRSA", null, CSLSignatureSpi.RsaSha2x256HashSpi.class);
        this.putSignature("SHA256withRSAandMGF1", null, CSLSignatureSpi.RsaSha2x256PssSpi.class);
        this.putSignature("SHA256hashedWithRSAandMGF1", null, CSLSignatureSpi.RsaSha2x256PssHashSpi.class);
        this.putSignature("SHA384withRSA", AlgorithmConstants.ID_SIGNATURE_RSA_SHA2_384, CSLSignatureSpi.RsaSha2x384Spi.class);
        this.putSignature("SHA384hashedWithRSA", null, CSLSignatureSpi.RsaSha2x384HashSpi.class);
        this.putSignature("SHA384withRSAandMGF1", null, CSLSignatureSpi.RsaSha2x384PssSpi.class);
        this.putSignature("SHA384hashedWithRSAandMGF1", null, CSLSignatureSpi.RsaSha2x384PssHashSpi.class);
        this.putSignature("SHA512withRSA", AlgorithmConstants.ID_SIGNATURE_RSA_SHA2_512, CSLSignatureSpi.RsaSha2x512Spi.class);
        this.putSignature("SHA512hashedWithRSA", null, CSLSignatureSpi.RsaSha2x512HashSpi.class);
        this.putSignature("SHA512withRSAandMGF1", null, CSLSignatureSpi.RsaSha2x512PssSpi.class);
        this.putSignature("SHA512hashedWithRSAandMGF1", null, CSLSignatureSpi.RsaSha2x512PssHashSpi.class);
        this.putSignature("SHA3-224withRSA", AlgorithmConstants.ID_SIGNATURE_RSA_SHA3_224, CSLSignatureSpi.RsaSha3x224Spi.class);
        this.putSignature("SHA3-224hashedWithRSA", null, CSLSignatureSpi.RsaSha3x224HashSpi.class);
        this.putSignature("SHA3-224withRSAandMGF1", null, CSLSignatureSpi.RsaSha3x224PssSpi.class);
        this.putSignature("SHA3-224hashedWithRSAandMGF1", null, CSLSignatureSpi.RsaSha3x224PssHashSpi.class);
        this.putSignature("SHA3-256withRSA", AlgorithmConstants.ID_SIGNATURE_RSA_SHA3_256, CSLSignatureSpi.RsaSha3x256Spi.class);
        this.putSignature("SHA3-256hashedWithRSA", null, CSLSignatureSpi.RsaSha3x256HashSpi.class);
        this.putSignature("SHA3-256withRSAandMGF1", null, CSLSignatureSpi.RsaSha3x256PssSpi.class);
        this.putSignature("SHA3-256hashedWithRSAandMGF1", null, CSLSignatureSpi.RsaSha3x256PssHashSpi.class);
        this.putSignature("SHA3-384withRSA", AlgorithmConstants.ID_SIGNATURE_RSA_SHA3_384, CSLSignatureSpi.RsaSha3x384Spi.class);
        this.putSignature("SHA3-384hashedWithRSA", null, CSLSignatureSpi.RsaSha3x384HashSpi.class);
        this.putSignature("SHA3-384withRSAandMGF1", null, CSLSignatureSpi.RsaSha3x384PssSpi.class);
        this.putSignature("SHA3-384hashedWithRSAandMGF1", null, CSLSignatureSpi.RsaSha3x384PssHashSpi.class);
        this.putSignature("SHA3-512withRSA", AlgorithmConstants.ID_SIGNATURE_RSA_SHA3_512, CSLSignatureSpi.RsaSha3x512Spi.class);
        this.putSignature("SHA3-512hashedWithRSA", null, CSLSignatureSpi.RsaSha3x512HashSpi.class);
        this.putSignature("SHA3-512withRSAandMGF1", null, CSLSignatureSpi.RsaSha3x512PssSpi.class);
        this.putSignature("SHA3-512hashedWithRSAandMGF1", null, CSLSignatureSpi.RsaSha3x512PssHashSpi.class);
        this.putSignature("RIPEMD160withCVC-ECDSA", AlgorithmConstants.ID_SIGNATURE_ECDSA_RIPEMD160_CVC, CSLSignatureSpi.EcdsaRipemd160CvcSpi.class);
        this.putSignature("RIPEMD160hashedWithCVC-ECDSA", null, CSLSignatureSpi.EcdsaRipemd160CvcHashSpi.class);
        this.putSignature("RIPEMD160withECDSA", AlgorithmConstants.ID_SIGNATURE_ECDSA_RIPEMD160, CSLSignatureSpi.EcdsaRipemd160Spi.class);
        this.putSignature("RIPEMD160hashedWithECDSA", null, CSLSignatureSpi.EcdsaRipemd160HashSpi.class);
        this.putSignature("SHA1withCVC-ECDSA", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA1_CVC, CSLSignatureSpi.EcdsaSha1CvcSpi.class);
        this.putSignature("SHA1hashedWithCVC-ECDSA", null, CSLSignatureSpi.EcdsaSha1CvcHashSpi.class);
        this.putSignature("SHA1withECDSA", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA1, CSLSignatureSpi.EcdsaSha1Spi.class);
        this.putSignature("SHA1hashedWithECDSA", null, CSLSignatureSpi.EcdsaSha1HashSpi.class);
        this.putSignature("SHA224withCVC-ECDSA", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA2_224_CVC, CSLSignatureSpi.EcdsaSha2x224CvcSpi.class);
        this.putSignature("SHA224hashedWithCVC-ECDSA", null, CSLSignatureSpi.EcdsaSha2x224CvcHashSpi.class);
        this.putSignature("SHA224withECDSA", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA2_224, CSLSignatureSpi.EcdsaSha2x224Spi.class);
        this.putSignature("SHA224hashedWithECDSA", null, CSLSignatureSpi.EcdsaSha2x224HashSpi.class);
        this.putSignature("SHA256withCVC-ECDSA", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA2_256_CVC, CSLSignatureSpi.EcdsaSha2x256CvcSpi.class);
        this.putSignature("SHA256hashedWithCVC-ECDSA", null, CSLSignatureSpi.EcdsaSha2x256CvcHashSpi.class);
        this.putSignature("SHA256withECDSA", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA2_256, CSLSignatureSpi.EcdsaSha2x256Spi.class);
        this.putSignature("SHA256hashedWithECDSA", null, CSLSignatureSpi.EcdsaSha2x256HashSpi.class);
        this.putSignature("SHA384withCVC-ECDSA", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA2_384_CVC, CSLSignatureSpi.EcdsaSha2x384CvcSpi.class);
        this.putSignature("SHA384hashedWithCVC-ECDSA", null, CSLSignatureSpi.EcdsaSha2x384CvcHashSpi.class);
        this.putSignature("SHA384withECDSA", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA2_384, CSLSignatureSpi.EcdsaSha2x384Spi.class);
        this.putSignature("SHA384hashedWithECDSA", null, CSLSignatureSpi.EcdsaSha2x384HashSpi.class);
        this.putSignature("SHA512withCVC-ECDSA", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA2_512_CVC, CSLSignatureSpi.EcdsaSha2x512CvcSpi.class);
        this.putSignature("SHA512hashedWithCVC-ECDSA", null, CSLSignatureSpi.EcdsaSha2x512CvcHashSpi.class);
        this.putSignature("SHA512withECDSA", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA2_512, CSLSignatureSpi.EcdsaSha2x512Spi.class);
        this.putSignature("SHA512hashedWithECDSA", null, CSLSignatureSpi.EcdsaSha2x512HashSpi.class);
        this.putSignature("SHA3-224withCVC-ECDSA", null, CSLSignatureSpi.EcdsaSha3x224CvcSpi.class);
        this.putSignature("SHA3-224hashedWithCVC-ECDSA", null, CSLSignatureSpi.EcdsaSha3x224CvcHashSpi.class);
        this.putSignature("SHA3-224withECDSA", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA3_224, CSLSignatureSpi.EcdsaSha3x224Spi.class);
        this.putSignature("SHA3-224hashedWithECDSA", null, CSLSignatureSpi.EcdsaSha3x224HashSpi.class);
        this.putSignature("SHA3-256withCVC-ECDSA", null, CSLSignatureSpi.EcdsaSha3x256CvcSpi.class);
        this.putSignature("SHA3-256hashedWithCVC-ECDSA", null, CSLSignatureSpi.EcdsaSha3x256CvcHashSpi.class);
        this.putSignature("SHA3-256withECDSA", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA3_256, CSLSignatureSpi.EcdsaSha3x256Spi.class);
        this.putSignature("SHA3-256hashedWithECDSA", null, CSLSignatureSpi.EcdsaSha3x256HashSpi.class);
        this.putSignature("SHA3-384withCVC-ECDSA", null, CSLSignatureSpi.EcdsaSha3x384CvcSpi.class);
        this.putSignature("SHA3-384hashedWithCVC-ECDSA", null, CSLSignatureSpi.EcdsaSha3x384CvcHashSpi.class);
        this.putSignature("SHA3-384withECDSA", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA3_384, CSLSignatureSpi.EcdsaSha3x384Spi.class);
        this.putSignature("SHA3-384hashedWithECDSA", null, CSLSignatureSpi.EcdsaSha3x384HashSpi.class);
        this.putSignature("SHA3-512withCVC-ECDSA", null, CSLSignatureSpi.EcdsaSha3x512CvcSpi.class);
        this.putSignature("SHA3-512hashedWithCVC-ECDSA", null, CSLSignatureSpi.EcdsaSha3x512CvcHashSpi.class);
        this.putSignature("SHA3-512withECDSA", AlgorithmConstants.ID_SIGNATURE_ECDSA_SHA3_512, CSLSignatureSpi.EcdsaSha3x512Spi.class);
        this.putSignature("SHA3-512hashedWithECDSA", null, CSLSignatureSpi.EcdsaSha3x512HashSpi.class);
    }

    private void registerSpecial() {
        this.registerParameters();
        this.registerCertificateFactories();
    }
}

