/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jce;

import de.governikus.csl.uom.jce.CSLJCECipherException;
import de.governikus.csl.uom.jce.JCEAlgorithmDefinition;
import de.governikus.csl.uom.jce.JceHelper;
import de.governikus.csl.uom.jce.remote.CSLJCERemoteCipherException;
import de.governikus.csl.uom.jce.remote.RemoteCipher;
import de.governikus.csl.uom.jce.remote.RemoteCipherKey;
import de.governikus.csl.uom.res.KeyResource;
import de.governikus.csl.uom.res.ResourceFailedException;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSLCipherSpi
extends CipherSpi {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CSLCipherSpi.class.getName());
    protected String algorithmName;
    private final Map<String, JCEAlgorithmDefinition> algorithms;
    private AlgorithmParameterSpec delegateParams;
    private Cipher delegateCipher;
    private KeyResource<?> keyResource;
    private String message;

    CSLCipherSpi(String algorithmName) {
        this(algorithmName, algorithmName);
    }

    CSLCipherSpi(String algorithmName, JCEAlgorithmDefinition delegateCipherAlgorithm) {
        this(algorithmName, JCEAlgorithmDefinition.toMap(delegateCipherAlgorithm));
    }

    CSLCipherSpi(String algorithmName, Map<String, JCEAlgorithmDefinition> algorithms) {
        if (algorithmName == null || algorithmName.isEmpty()) {
            throw new IllegalArgumentException("algorithm name can not be null or empty");
        }
        if (algorithms == null || algorithms.isEmpty()) {
            throw new IllegalArgumentException("algorithms can not be null or empty");
        }
        if (!algorithms.containsKey(null)) {
            throw new IllegalArgumentException("default algorithm for key null, any provider must be specified");
        }
        this.algorithmName = algorithmName;
        this.algorithms = algorithms;
        this.delegateParams = null;
    }

    CSLCipherSpi(String algorithmName, String delegateCipherAlgorithm) {
        this(algorithmName, new JCEAlgorithmDefinition(delegateCipherAlgorithm));
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return this.delegateCipher.getParameters();
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Key encryptionDecryptionKey = this.prepareDelegateCipher(key, Key.class);
        if (random == null) {
            this.delegateCipher.init(opmode, encryptionDecryptionKey, params);
        } else {
            this.delegateCipher.init(opmode, encryptionDecryptionKey, params, random);
        }
        switch (opmode) {
            case 1: {
                this.message = "encrypting";
                break;
            }
            default: {
                this.message = "encrypting";
            }
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        Key encryptionDecryptionKey = this.prepareDelegateCipher(key, Key.class);
        if (random == null) {
            this.delegateCipher.init(opmode, encryptionDecryptionKey, params);
        } else {
            this.delegateCipher.init(opmode, encryptionDecryptionKey, params, random);
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            // empty catch block
        }
    }

    protected JCEAlgorithmDefinition getJCEAlgorithmDefinition(String jceProviderName) throws InvalidKeyException {
        JCEAlgorithmDefinition jceAlgorithmDefinition = this.algorithms.get(jceProviderName);
        if (jceAlgorithmDefinition == null && jceProviderName != null) {
            jceAlgorithmDefinition = this.algorithms.get(null);
        }
        if (jceAlgorithmDefinition == null) {
            throw new InvalidKeyException("no algorithm definition for provider: " + jceProviderName);
        }
        return jceAlgorithmDefinition;
    }

    private <K extends Key> K prepareDelegateCipher(Key key, Class<K> keyClass) throws InvalidKeyException {
        this.keyResource = JceHelper.checkGetKeyResource(key);
        String jceProviderName = this.keyResource.getJCEProviderName();
        JCEAlgorithmDefinition jceAlgorithmDefinition = this.getJCEAlgorithmDefinition(jceProviderName);
        AlgorithmParameterSpec defSpec = jceAlgorithmDefinition.algorithmParameterSpec;
        if (this.delegateParams == null) {
            this.delegateParams = defSpec;
        }
        String algorithm = jceAlgorithmDefinition.algorithmName;
        try {
            this.delegateCipher = this.keyResource.getKey() instanceof RemoteCipherKey ? new RemoteCipher(algorithm) : (jceProviderName == null || jceProviderName.isEmpty() ? Cipher.getInstance(algorithm) : Cipher.getInstance(algorithm, jceProviderName));
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidKeyException((Throwable)JceHelper.toCoreException("failed to create delegate signature instance using algorithm'" + algorithm + "': " + e.getMessage(), e));
        }
        catch (NoSuchProviderException e) {
            throw new InvalidKeyException((Throwable)JceHelper.toCoreException("failed to create delegate signature instance using provider '" + jceProviderName + "': " + e.getMessage(), e));
        }
        catch (Exception e) {
            throw new InvalidKeyException((Throwable)JceHelper.toCoreException("failed to create delegate signature instance using provider '" + jceProviderName + "' and algorithm '" + algorithm + "': " + e.getMessage(), e));
        }
        Key delegateKey = null;
        try {
            delegateKey = this.keyResource.getKey();
        }
        catch (ResourceFailedException e) {
            throw new InvalidKeyException((Throwable)JceHelper.toCoreException("failed to get key of resource: " + e.getMessage(), (Exception)((Object)e)));
        }
        if (!keyClass.isInstance(delegateKey)) {
            throw new InvalidKeyException((Throwable)JceHelper.toCoreException("key of resource must be a " + keyClass.getName() + ": " + key.getClass().getName() + ", key to use for signing: " + delegateKey));
        }
        return (K)((Key)keyClass.cast(delegateKey));
    }

    @Override
    protected int engineGetBlockSize() {
        return this.delegateCipher.getBlockSize();
    }

    @Override
    protected byte[] engineGetIV() {
        return this.delegateCipher.getIV();
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.delegateCipher.getOutputSize(inputLen);
    }

    @Override
    protected int engineUpdate(ByteBuffer input, ByteBuffer output) throws ShortBufferException {
        return this.delegateCipher.update(input, output);
    }

    @Override
    protected void engineUpdateAAD(byte[] src, int offset, int len) {
        this.delegateCipher.updateAAD(src, offset, len);
    }

    @Override
    protected void engineUpdateAAD(ByteBuffer src) {
        this.delegateCipher.updateAAD(src);
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        return this.delegateCipher.unwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        return this.delegateCipher.wrap(key);
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return JceHelper.getKeySize(key);
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
    }

    @Override
    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws CSLJCECipherException, CSLJCERemoteCipherException {
        try {
            JceHelper.logDoFinalStart(LOGGER, this.message, this.keyResource);
            byte[] byArray = this.delegateCipher.doFinal(input, inputOffset, inputLen);
            return byArray;
        }
        catch (CSLJCECipherException | CSLJCERemoteCipherException e) {
            throw e;
        }
        catch (Exception e) {
            throw JceHelper.throwCipherException(e, this.delegateCipher instanceof RemoteCipher);
        }
        finally {
            JceHelper.logDoFinalEnd(LOGGER, this.message, this.keyResource);
        }
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws CSLJCECipherException, CSLJCERemoteCipherException {
        try {
            JceHelper.logDoFinalStart(LOGGER, this.message, this.keyResource);
            int n = this.delegateCipher.doFinal(input, inputOffset, inputLen, output, outputOffset);
            return n;
        }
        catch (CSLJCECipherException | CSLJCERemoteCipherException e) {
            throw e;
        }
        catch (Exception e) {
            throw JceHelper.throwCipherException(e, this.delegateCipher instanceof RemoteCipher);
        }
        finally {
            JceHelper.logDoFinalEnd(LOGGER, this.message, this.keyResource);
        }
    }

    @Override
    protected int engineDoFinal(ByteBuffer input, ByteBuffer output) throws CSLJCECipherException, CSLJCERemoteCipherException {
        try {
            JceHelper.logDoFinalStart(LOGGER, this.message, this.keyResource);
            int n = this.delegateCipher.doFinal(input, output);
            return n;
        }
        catch (CSLJCECipherException | CSLJCERemoteCipherException e) {
            throw e;
        }
        catch (Exception e) {
            throw JceHelper.throwCipherException(e, this.delegateCipher instanceof RemoteCipher);
        }
        finally {
            JceHelper.logDoFinalEnd(LOGGER, this.message, this.keyResource);
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        return this.delegateCipher.update(input, inputOffset, inputLen);
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        return this.delegateCipher.update(input, inputOffset, inputLen, output, outputOffset);
    }

    public static class RsaSha2x512OaepSpi
    extends CSLCipherSpi {
        public RsaSha2x512OaepSpi() {
            super("RSA/NONE/OAEPWithSHA512AndMGF1Padding");
        }
    }

    public static class RsaSha1OaepSpi
    extends CSLCipherSpi {
        public RsaSha1OaepSpi() {
            super("RSA/NONE/OAEPWithSHA1AndMGF1Padding");
        }
    }

    public static class RsaPkcs1v15Spi
    extends CSLCipherSpi {
        public RsaPkcs1v15Spi() {
            super("RSA/ECB/PKCS1Padding");
        }
    }

    public static class RsaSha2x384OeapSpi
    extends CSLCipherSpi {
        public RsaSha2x384OeapSpi() {
            super("RSA/NONE/OAEPWithSHA384AndMGF1Padding");
        }
    }

    public static class RsaSha2x256OeapSpi
    extends CSLCipherSpi {
        public RsaSha2x256OeapSpi() {
            super("RSA/NONE/OAEPWithSHA256AndMGF1Padding");
        }
    }

    public static class RsaSha2x224OeapSpi
    extends CSLCipherSpi {
        public RsaSha2x224OeapSpi() {
            super("RSA/NONE/OAEPWithSHA224AndMGF1Padding");
        }
    }
}

