/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jce;

import de.governikus.csl.uom.jcebase.ASN1CertUtil;
import de.governikus.csl.uom.jcebase.X509AttributeCertificateImpl;
import de.governikus.csl.uom.jcebase.X509CertificateImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.x509.AttributeCertificate;
import org.bouncycastle.jcajce.provider.asymmetric.x509.CertificateFactory;

public class CSLCertificateFactory
extends CertificateFactory {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Certificate engineGenerateCertificate(InputStream ainStream) throws CertificateException {
        InputStream inStream = null;
        try {
            inStream = ASN1CertUtil.getLimitedASN1InputStream((InputStream)ainStream);
        }
        catch (IOException e) {
            throw new CertificateException("stream failed pre checks: " + e.getMessage(), e);
        }
        if (inStream == null) {
            return null;
        }
        ASN1Primitive readObject = null;
        ByteArrayInputStream bais = null;
        try {
            readObject = new ASN1StreamParser(inStream).readObject().toASN1Primitive();
            bais = new ByteArrayInputStream(readObject.toASN1Primitive().getEncoded());
        }
        catch (IOException e) {
            throw new CertificateException(e);
        }
        try {
            Throwable throwable = null;
            try (ByteArrayInputStream is = bais;){
                Certificate certificate = super.engineGenerateCertificate((InputStream)is);
                if (certificate instanceof X509Certificate) {
                    X509CertificateImpl x509CertificateImpl = new X509CertificateImpl((X509Certificate)certificate);
                    return x509CertificateImpl;
                }
                Certificate certificate2 = certificate;
                return certificate2;
            }
            catch (CertificateException e) {
                AttributeCertificate ac = null;
                try {
                    ac = AttributeCertificate.getInstance((Object)readObject);
                }
                catch (Exception e1) {
                    throw new CertificateException(e);
                }
                X509AttributeCertificateImpl x509AttributeCertificateImpl = new X509AttributeCertificateImpl(ac);
                return x509AttributeCertificateImpl;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new CertificateException(e);
        }
    }
}

