/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.uom.jce;

import de.governikus.csl.uom.jce.BoundType;
import java.util.Objects;

public class Bound<T extends Number> {
    private final T value;
    private final BoundType boundType;
    public static final BoundType DEFAULT_BOUND_TYPE = BoundType.INCLUSIVE;

    public String toString() {
        return "Bound [value=" + this.value + ", boundType=" + (Object)((Object)this.boundType) + "]";
    }

    public Bound(T value) {
        this(value, DEFAULT_BOUND_TYPE);
    }

    public Bound(T value, BoundType boundType) {
        this.value = (Number)Objects.requireNonNull(value, "value is required");
        this.boundType = boundType;
    }

    public T getValue() {
        return this.value;
    }

    public BoundType getBoundType() {
        return this.boundType;
    }

    public boolean isInclusive() {
        return this.boundType.isInclusive();
    }

    public boolean isExclusive() {
        return this.boundType.isExclusive();
    }
}

