/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.health;

import de.governikus.csl.transport.HttpResponse;
import de.governikus.csl.transport.HttpResponseHandler;
import de.governikus.csl.transport.exception.ResponseException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class PingResponseHandler
implements HttpResponseHandler<Void> {
    private String expectedContent;

    public PingResponseHandler() {
        this.expectedContent = "pong";
    }

    public PingResponseHandler(String expectedContent) {
        this.expectedContent = expectedContent;
    }

    public Void handleResponse(HttpResponse resp) throws IOException {
        int status = resp.getStatus();
        if (status != 200) {
            throw new ResponseException(status);
        }
        try (InputStream is = resp.getContent();){
            String content = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            if (!this.expectedContent.equals(content)) {
                throw new ResponseException(status, "Invalid response:" + content);
            }
        }
        return null;
    }
}

