/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.health;

import de.governikus.csc.health.CSCHealthResult;
import de.governikus.csc.health.HealthSummary;
import de.governikus.csc.health.UnparseableResponse;
import de.governikus.csl.transport.HttpResponse;
import de.governikus.csl.transport.HttpResponseHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;

public class HealthCheckResponseHandler
implements HttpResponseHandler<HealthSummary> {
    private String url;

    /*
     * Exception decompiling
     */
    public HealthSummary handleResponse(HttpResponse resp) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public JsonObject readJson(JsonReader reader) throws UnparseableResponse {
        try {
            return reader.readObject();
        }
        catch (Exception e) {
            throw new UnparseableResponse("Can't read json structure", e);
        }
    }

    private HealthSummary parseSummary(JsonObject obj) throws UnparseableResponse {
        HealthSummary res = new HealthSummary();
        JsonString outcome = this.checkForClassCastException(() -> obj.getJsonString("status"));
        if (outcome == null) {
            outcome = this.checkForClassCastException(() -> obj.getJsonString("outcome"));
        }
        if (outcome == null) {
            throw new UnparseableResponse("Can't get the overall outcome");
        }
        res.setStatus(outcome.getString());
        JsonArray checks = this.checkForClassCastException(() -> obj.getJsonArray("checks"));
        if (checks == null) {
            return res;
        }
        ArrayList<CSCHealthResult> parsedChecks = null;
        for (int i = 0; i < checks.size(); ++i) {
            int ctr = i;
            JsonObject check = this.checkForClassCastException(() -> checks.getJsonObject(ctr));
            CSCHealthResult parsedCheck = this.parseHealthCheck(check);
            if (parsedChecks == null) {
                parsedChecks = new ArrayList<CSCHealthResult>();
            }
            parsedChecks.add(parsedCheck);
        }
        res.setChecks(parsedChecks);
        return res;
    }

    private CSCHealthResult parseHealthCheck(JsonObject jsonObject) throws UnparseableResponse {
        JsonString status;
        CSCHealthResult res = new CSCHealthResult();
        JsonString name = this.checkForClassCastException(() -> jsonObject.getJsonString("name"));
        if (name != null) {
            res.setName(name.getString());
        }
        if ((status = this.checkForClassCastException(() -> jsonObject.getJsonString("status"))) == null && (status = this.checkForClassCastException(() -> jsonObject.getJsonString("state"))) == null) {
            throw new UnparseableResponse("Can't get the status of the check");
        }
        res.setStatus(status.getString());
        return res;
    }

    private <T> T checkForClassCastException(Supplier<T> supplier) throws UnparseableResponse {
        try {
            return supplier.get();
        }
        catch (ClassCastException e) {
            throw new UnparseableResponse("Can't process json structure", e);
        }
    }

    public HealthCheckResponseHandler(String url) {
        this.url = url;
    }
}

