/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.algorithm_catalog.impl;

import de.governikus.csl.algorithm_catalog.impl.PublicKeySupport;
import de.governikus.csl.uom.validate.SignatureAlgorithmParameter;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.List;

public class RSASupport
implements PublicKeySupport {
    @Override
    public List<SignatureAlgorithmParameter> extractParameters(PublicKey publicKey) {
        if (publicKey instanceof RSAPublicKey) {
            RSAPublicKey rsaPublicKey = (RSAPublicKey)publicKey;
            ArrayList<SignatureAlgorithmParameter> params = new ArrayList<SignatureAlgorithmParameter>();
            int moduluslength = rsaPublicKey.getModulus().bitLength();
            SignatureAlgorithmParameter modulusParam = new SignatureAlgorithmParameter("moduluslength", moduluslength);
            params.add(modulusParam);
            int elength = rsaPublicKey.getPublicExponent().intValue();
            SignatureAlgorithmParameter eParam = new SignatureAlgorithmParameter("elength", elength);
            params.add(eParam);
            return params;
        }
        throw new IllegalArgumentException("Only RSA public keys supported");
    }
}

