/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.algorithm_catalog.impl;

import de.governikus.csl.algorithm_catalog.impl.DSASupport;
import de.governikus.csl.algorithm_catalog.impl.ECSupport;
import de.governikus.csl.algorithm_catalog.impl.RSASupport;
import de.governikus.csl.uom.validate.SignatureAlgorithmParameter;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.List;

public interface PublicKeySupport {
    public List<SignatureAlgorithmParameter> extractParameters(PublicKey var1) throws IllegalArgumentException;

    public static class Factory {
        public static List<SignatureAlgorithmParameter> extractParameters(PublicKey publicKey) throws IllegalArgumentException {
            if (publicKey instanceof RSAPublicKey) {
                return new RSASupport().extractParameters(publicKey);
            }
            if (publicKey instanceof DSAPublicKey) {
                return new DSASupport().extractParameters(publicKey);
            }
            if (publicKey instanceof ECPublicKey) {
                return new ECSupport().extractParameters(publicKey);
            }
            throw new IllegalArgumentException("Unsupported public key " + publicKey);
        }
    }
}

