/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.algorithm_catalog.impl;

import de.governikus.csl.algorithm_catalog.impl.PublicKeySupport;
import de.governikus.csl.uom.validate.SignatureAlgorithmParameter;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECField;
import java.security.spec.ECFieldF2m;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.List;

public class ECSupport
implements PublicKeySupport {
    @Override
    public List<SignatureAlgorithmParameter> extractParameters(PublicKey publicKey) throws IllegalArgumentException {
        if (publicKey instanceof ECPublicKey) {
            ECPublicKey ecPublicKey = (ECPublicKey)publicKey;
            ArrayList<SignatureAlgorithmParameter> params = new ArrayList<SignatureAlgorithmParameter>();
            ECParameterSpec ecSpec = ecPublicKey.getParams();
            ECField field = ecSpec.getCurve().getField();
            int fieldSize = field.getFieldSize();
            if (field instanceof ECFieldFp) {
                SignatureAlgorithmParameter plengthParam = new SignatureAlgorithmParameter("plength", fieldSize);
                params.add(plengthParam);
            } else if (field instanceof ECFieldF2m) {
                SignatureAlgorithmParameter mplengthParam = new SignatureAlgorithmParameter("mlength", fieldSize);
                params.add(mplengthParam);
            } else {
                throw new IllegalArgumentException("ECField of unknown type: " + field);
            }
            int generatorOrder = ecSpec.getOrder().bitLength();
            SignatureAlgorithmParameter qplengthParam = new SignatureAlgorithmParameter("qlength", generatorOrder);
            params.add(qplengthParam);
            return params;
        }
        throw new IllegalArgumentException("Only EC public keys supported");
    }
}

