/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.algorithm_catalog.impl;

import de.governikus.csl.algorithm_catalog.impl.PublicKeySupport;
import de.governikus.csl.uom.validate.SignatureAlgorithmParameter;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.util.ArrayList;
import java.util.List;

public class DSASupport
implements PublicKeySupport {
    public static final String DSA = "DSA";

    @Override
    public List<SignatureAlgorithmParameter> extractParameters(PublicKey publicKey) {
        if (publicKey instanceof DSAPublicKey) {
            DSAPublicKey dsaPublicKey = (DSAPublicKey)publicKey;
            ArrayList<SignatureAlgorithmParameter> params = new ArrayList<SignatureAlgorithmParameter>();
            int plength = dsaPublicKey.getParams().getP().bitLength();
            SignatureAlgorithmParameter plengthParam = new SignatureAlgorithmParameter("plength", plength);
            params.add(plengthParam);
            int qlength = dsaPublicKey.getParams().getQ().bitLength();
            SignatureAlgorithmParameter qlengthParam = new SignatureAlgorithmParameter("qlength", qlength);
            params.add(qlengthParam);
            return params;
        }
        throw new IllegalArgumentException("Only DSA public keys supported");
    }
}

