/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.algorithm_catalog;

public enum Usage {
    SIGN_DATA(false, true, "usageAI"),
    SIGN_CERTIFICATE(false, false, "usageAZ"),
    SIGN_OCSP(false, true, "usageAO"),
    SIGN_TIMESTAMP(false, true, "usageAT"),
    VERIFY_CERTIFICATE_SIGNATURE(true, false, "usageDZ"),
    VERIFY_DATA_SIGNATURE(true, true, "usageDI"),
    VERIFY_OCSP_SIGNATURE(true, true, "usageDO"),
    VERIFY_TIMESTAMP_SIGNATURE(true, true, "usageDT");

    private boolean verify;
    private boolean content;
    private String id;

    private Usage(boolean v, boolean c, String id) {
        this.verify = v;
        this.content = c;
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public boolean isVerify() {
        return this.verify;
    }

    public boolean isContentSignature() {
        return this.content;
    }

    public static Usage forID(String id) throws IllegalArgumentException {
        for (Usage usage : Usage.values()) {
            if (!usage.id.equals(id)) continue;
            return usage;
        }
        throw new IllegalArgumentException("Usage with id " + id + " unknown");
    }

    public static Usage forOrdinal(int ordinal) throws IllegalArgumentException {
        if (ordinal < 0 || ordinal >= Usage.values().length) {
            throw new IllegalArgumentException("Usage with ordinal " + ordinal + " unknown");
        }
        return Usage.values()[ordinal];
    }
}

