/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.algorithm_catalog;

import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.governikus.csl.algorithm_catalog.AlgorithmCatalog;
import de.governikus.csl.algorithm_catalog.AlgorithmCatalogException;
import de.governikus.csl.algorithm_catalog.AlgorithmCatalogResponse;
import de.governikus.csl.algorithm_catalog.AlgorithmCatalogs;
import de.governikus.csl.algorithm_catalog.UnsupportedCatalogNameException;
import de.governikus.csl.algorithm_catalog.Usage;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.impl.FileDocumentImpl;
import de.governikus.csl.uom.impl.ResourceDocument;
import de.governikus.csl.uom.validate.SignatureAlgorithmParameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FallbackAlgorithmCatalogManager
extends AlgorithmCatalogs {
    private static final Logger LOGGER = LoggerFactory.getLogger(FallbackAlgorithmCatalogManager.class);
    private AlgorithmCatalog defaultCatalog;

    public AlgorithmCatalog setDefaultCatalog(Document file) throws JAXBException, IOException, AlgorithmCatalogException {
        LOGGER.info("Setting default algorithm catalog");
        try {
            this.defaultCatalog = this.parseCatalog(file);
        }
        catch (XMLStreamException e) {
            throw new AlgorithmCatalogException();
        }
        return this.defaultCatalog;
    }

    public AlgorithmCatalog setDefaultCatalog(String file) throws JAXBException, IOException, AlgorithmCatalogException {
        return this.setDefaultCatalog((Document)new ResourceDocument(file));
    }

    public AlgorithmCatalog setDefaultCatalog(File file) throws JAXBException, IOException, AlgorithmCatalogException {
        return this.setDefaultCatalog((Document)new FileDocumentImpl(file, null));
    }

    private AlgorithmCatalog parseCatalog(Document file) throws JAXBException, IOException, XMLStreamException {
        AlgorithmCatalog catalog = new AlgorithmCatalog();
        try (InputStream is = file.getInputStream();){
            catalog.load(is);
        }
        return catalog;
    }

    @Override
    protected AlgorithmCatalogResponse getAlgorithmValidity(String catalogName, String algorithm, List<SignatureAlgorithmParameter> params, Usage usage) throws UnsupportedCatalogNameException {
        try {
            return super.getAlgorithmValidity(catalogName, algorithm, params, usage);
        }
        catch (UnsupportedCatalogNameException e) {
            if (this.defaultCatalog == null) {
                throw e;
            }
            AlgorithmCatalogResponse expirationDate = this.defaultCatalog.getExpirationInfo(algorithm, params, usage);
            return expirationDate;
        }
    }

    @Override
    public AlgorithmCatalogResponse getAlgorithmValidity(String catalogName, SignatureAlgorithm algorithm, List<SignatureAlgorithmParameter> params, Usage usage) throws UnsupportedCatalogNameException {
        try {
            return super.getAlgorithmValidity(catalogName, algorithm, params, usage);
        }
        catch (UnsupportedCatalogNameException e) {
            if (this.defaultCatalog != null && this.defaultCatalog.getAlgorithmValidities().get(algorithm.getName()) != null) {
                return this.getAlgorithmValidity(catalogName, algorithm.getName(), params, usage);
            }
            return this.getAlgorithmValiditySuite(catalogName, algorithm, params, usage);
        }
    }

    @Override
    public AlgorithmCatalog getAlgorithmCatalog(String catalogName) throws UnsupportedCatalogNameException {
        try {
            return super.getAlgorithmCatalog(catalogName);
        }
        catch (UnsupportedCatalogNameException e) {
            if (this.defaultCatalog != null) {
                return this.defaultCatalog;
            }
            throw e;
        }
    }
}

