/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.algorithm_catalog;

import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.algorithm_identifier.PaddingAlgorithm;
import de.bos_bremen.algorithm_identifier.SignatureAlgorithm;
import de.bos_bremen.algorithm_identifier.gen.SignatureAlgorithmBase;
import de.governikus.csl.algorithm_catalog.AlgorithmCatalog;
import de.governikus.csl.algorithm_catalog.AlgorithmCatalogException;
import de.governikus.csl.algorithm_catalog.AlgorithmCatalogManager;
import de.governikus.csl.algorithm_catalog.AlgorithmCatalogResponse;
import de.governikus.csl.algorithm_catalog.SortableEvaluationType;
import de.governikus.csl.algorithm_catalog.UnsupportedCatalogNameException;
import de.governikus.csl.algorithm_catalog.Usage;
import de.governikus.csl.algorithm_catalog.impl.PublicKeySupport;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.impl.FileDocumentImpl;
import de.governikus.csl.uom.impl.ResourceDocument;
import de.governikus.csl.uom.validate.AlgorithmCatalogMetaInformation;
import de.governikus.csl.uom.validate.SignatureAlgorithmParameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgorithmCatalogs
implements AlgorithmCatalogManager {
    static final String ERROR_MSG_INVALID_CATALOG_NAME = "Invalid catalog name: %s";
    private static final Logger LOGGER = LoggerFactory.getLogger(AlgorithmCatalogs.class);
    private Map<String, AlgorithmCatalog> catalogs = new HashMap<String, AlgorithmCatalog>();

    public AlgorithmCatalog addCatalog(String key, InputStream is) throws JAXBException, IOException, AlgorithmCatalogException {
        LOGGER.debug("Parsing algorithm catalog");
        AlgorithmCatalog catalog = new AlgorithmCatalog();
        try {
            catalog.load(is);
        }
        catch (XMLStreamException e) {
            throw new AlgorithmCatalogException(e);
        }
        this.logAddAlgorithmCatalog(catalog);
        this.catalogs.put(key, catalog);
        return catalog;
    }

    public AlgorithmCatalog addCatalog(String key, Document file) throws JAXBException, IOException, AlgorithmCatalogException {
        try (InputStream is = file.getInputStream();){
            AlgorithmCatalog algorithmCatalog = this.addCatalog(key, is);
            return algorithmCatalog;
        }
    }

    public AlgorithmCatalog addCatalog(Document file) throws JAXBException, IOException, AlgorithmCatalogException {
        try (InputStream is = file.getInputStream();){
            AlgorithmCatalog algorithmCatalog = this.addCatalog(file.getName(), is);
            return algorithmCatalog;
        }
    }

    public AlgorithmCatalog addCatalog(String key, File file) throws JAXBException, IOException, AlgorithmCatalogException {
        if (file == null) {
            throw new IOException();
        }
        return this.addCatalog(key, (Document)new FileDocumentImpl(file, null));
    }

    public AlgorithmCatalog addCatalog(File file) throws JAXBException, IOException, AlgorithmCatalogException {
        return this.addCatalog(file.getName(), file);
    }

    public AlgorithmCatalog addCatalog(String key, String file) throws JAXBException, IOException, AlgorithmCatalogException {
        return this.addCatalog(key, (Document)new ResourceDocument(file));
    }

    public AlgorithmCatalog addCatalog(String file) throws JAXBException, IOException, AlgorithmCatalogException {
        return this.addCatalog(file, (Document)new ResourceDocument(file));
    }

    @Override
    public Map<String, AlgorithmCatalog> getCatalogs() {
        return this.catalogs;
    }

    protected AlgorithmCatalogResponse getAlgorithmValidity(String catalogName, String algorithm, List<SignatureAlgorithmParameter> params, Usage usage) throws UnsupportedCatalogNameException {
        LOGGER.debug("Getting expiration date for algorithm {}", (Object)algorithm);
        if (catalogName == null || !this.catalogs.containsKey(catalogName)) {
            throw new UnsupportedCatalogNameException(String.format(ERROR_MSG_INVALID_CATALOG_NAME, catalogName));
        }
        AlgorithmCatalog algorithmCatalog = this.catalogs.get(catalogName);
        return algorithmCatalog.getExpirationInfo(algorithm, params, usage);
    }

    @Override
    public AlgorithmCatalogResponse getAlgorithmValidity(String catalogName, SignatureAlgorithmBase algorithm, List<SignatureAlgorithmParameter> params, Usage usage) throws UnsupportedCatalogNameException {
        return this.getAlgorithmValidity(catalogName, algorithm.name(), params, usage);
    }

    public AlgorithmCatalogResponse getAlgorithmValidity(String catalogName, SignatureAlgorithmBase algorithm, PublicKey key, Usage usage) throws UnsupportedCatalogNameException {
        List<SignatureAlgorithmParameter> params = PublicKeySupport.Factory.extractParameters(key);
        return this.getAlgorithmValidity(catalogName, algorithm.name(), params, usage);
    }

    @Override
    public AlgorithmCatalogResponse getAlgorithmValidity(String catalogName, PaddingAlgorithm algorithm, List<SignatureAlgorithmParameter> params, Usage usage) throws UnsupportedCatalogNameException {
        return this.getAlgorithmValidity(catalogName, algorithm.getName(), params, usage);
    }

    public AlgorithmCatalogResponse getAlgorithmValidity(String catalogName, PaddingAlgorithm algorithm, PublicKey key, Usage usage) throws UnsupportedCatalogNameException {
        List<SignatureAlgorithmParameter> params = PublicKeySupport.Factory.extractParameters(key);
        return this.getAlgorithmValidity(catalogName, algorithm.getName(), params, usage);
    }

    public AlgorithmCatalogResponse getAlgorithmValidity(String catalogName, PaddingAlgorithm algorithm, Usage usage) throws UnsupportedCatalogNameException {
        return this.getAlgorithmValidity(catalogName, algorithm.getName(), null, usage);
    }

    @Override
    public AlgorithmCatalogResponse getAlgorithmValidity(String catalogName, DigestAlgorithm algorithm, Usage usage) throws UnsupportedCatalogNameException {
        return this.getAlgorithmValidity(catalogName, algorithm.getName(), null, usage);
    }

    @Override
    public AlgorithmCatalogResponse getAlgorithmValidity(String catalogName, SignatureAlgorithm algorithm, List<SignatureAlgorithmParameter> params, Usage usage) throws UnsupportedCatalogNameException {
        LOGGER.debug("Getting expiration date for algorithm {}", (Object)algorithm);
        if (catalogName == null || !this.catalogs.containsKey(catalogName)) {
            throw new UnsupportedCatalogNameException(String.format(ERROR_MSG_INVALID_CATALOG_NAME, catalogName));
        }
        if (this.catalogs.get(catalogName).getAlgorithmValidities().get(algorithm.getName()) != null) {
            return this.getAlgorithmValidity(catalogName, algorithm.getName(), params, usage);
        }
        return this.getAlgorithmValiditySuite(catalogName, algorithm, params, usage);
    }

    protected AlgorithmCatalogResponse getAlgorithmValiditySuite(String catalogName, SignatureAlgorithm algorithm, List<SignatureAlgorithmParameter> params, Usage usage) throws UnsupportedCatalogNameException {
        AlgorithmCatalogResponse padding;
        PaddingAlgorithm paddingAlgorithm = algorithm.getPaddingAlgorithm();
        AlgorithmCatalogResponse algorithmCatalogResponse = padding = paddingAlgorithm == null ? null : this.getAlgorithmValidity(catalogName, paddingAlgorithm, params, usage);
        if (padding != null && padding.getExpirationDate() == null && !padding.isWithoutExpirationDate()) {
            return padding;
        }
        DigestAlgorithm digestAlgorithm = algorithm.getDigestAlgorithm();
        AlgorithmCatalogResponse digest = this.getAlgorithmValidity(catalogName, digestAlgorithm, usage);
        if (digest.getExpirationDate() == null && !digest.isWithoutExpirationDate()) {
            return digest;
        }
        SignatureAlgorithmBase baseAlgorithm = algorithm.getBaseAlgorithm();
        AlgorithmCatalogResponse base = this.getAlgorithmValidity(catalogName, baseAlgorithm, params, usage);
        if (base.getExpirationDate() == null && !base.isWithoutExpirationDate()) {
            return base;
        }
        AlgorithmCatalogResponse result = padding;
        if (result == null || result.getExpirationDate() == null && !result.isWithoutExpirationDate() || result.isWithoutExpirationDate() || digest.getExpirationDate() != null && digest.getExpirationDate().before(result.getExpirationDate())) {
            result = digest;
        }
        if (result.getExpirationDate() == null && !result.isWithoutExpirationDate() || result.isWithoutExpirationDate() || base.getExpirationDate() != null && base.getExpirationDate().before(result.getExpirationDate())) {
            result = base;
        }
        return result;
    }

    public boolean isValid(String catalogName, SignatureAlgorithm algorithm, List<SignatureAlgorithmParameter> params, Usage usage, Date date) throws UnsupportedCatalogNameException {
        AlgorithmCatalogResponse algoCatResp = this.getAlgorithmValidity(catalogName, algorithm, params, usage);
        if (algoCatResp.isWithoutExpirationDate()) {
            return true;
        }
        Date expirationDate = algoCatResp.getExpirationDate();
        return expirationDate != null && !date.after(expirationDate);
    }

    public boolean isValid(String catalogName, DigestAlgorithm algorithm, Usage usage, Date date) throws UnsupportedCatalogNameException {
        AlgorithmCatalogResponse algoCatResp = this.getAlgorithmValidity(catalogName, algorithm, usage);
        if (algoCatResp.isWithoutExpirationDate()) {
            return true;
        }
        Date expirationDate = algoCatResp.getExpirationDate();
        return expirationDate != null && !date.after(expirationDate);
    }

    public boolean isValid(String catalogName, SignatureAlgorithm algorithm, PublicKey key, Usage usage, Date date) throws UnsupportedCatalogNameException {
        List<SignatureAlgorithmParameter> params = PublicKeySupport.Factory.extractParameters(key);
        AlgorithmCatalogResponse algoCatResp = this.getAlgorithmValidity(catalogName, algorithm, params, usage);
        if (algoCatResp.isWithoutExpirationDate()) {
            return true;
        }
        Date expirationDate = algoCatResp.getExpirationDate();
        return expirationDate != null && !date.after(expirationDate);
    }

    Date getPolicyIssueDate(String catalogName) {
        return this.catalogs.get(catalogName).getPolicyIssueDate(catalogName);
    }

    public Map<String, List<SortableEvaluationType>> getAlgorithmValidities(String catalogName) {
        return this.catalogs.get(catalogName).getAlgorithmValidities();
    }

    @Override
    public AlgorithmCatalog getAlgorithmCatalog(String catalogName) throws UnsupportedCatalogNameException {
        if (catalogName == null || !this.catalogs.containsKey(catalogName)) {
            throw new UnsupportedCatalogNameException(String.format(ERROR_MSG_INVALID_CATALOG_NAME, catalogName));
        }
        return this.catalogs.get(catalogName);
    }

    private void logAddAlgorithmCatalog(AlgorithmCatalog catalog) {
        if (!LOGGER.isInfoEnabled()) {
            return;
        }
        String name = null;
        String version = null;
        String publisher = null;
        AlgorithmCatalogMetaInformation catalogMetaData = catalog.getCatalogMetaData();
        if (catalogMetaData != null) {
            name = catalogMetaData.getName();
            version = catalogMetaData.getVersion();
            publisher = catalogMetaData.getPublisher();
        }
        if (name == null) {
            name = "unnamed";
        }
        if (version == null) {
            version = "unversioned";
        }
        if (publisher == null) {
            publisher = "unknown publisher";
        }
        LOGGER.info("Adding algorithm catalog with name '{}' in version '{}' published by '{}'", new Object[]{name, version, publisher});
    }
}

