/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.algorithm_catalog;

import de.governikus.csl.algorithm_catalog.AlgorithmCatalogResponse;
import de.governikus.csl.algorithm_catalog.SortableEvaluationType;
import de.governikus.csl.algorithm_catalog.Usage;
import de.governikus.csl.algorithm_catalog.gen.AlgorithmCatalogType;
import de.governikus.csl.algorithm_catalog.gen.AlgorithmValidityType;
import de.governikus.csl.algorithm_catalog.gen.EvaluationType;
import de.governikus.csl.algorithm_catalog.gen.ObjectFactory;
import de.governikus.csl.algorithm_catalog.gen.ParameterType;
import de.governikus.csl.algorithm_catalog.gen.PolicyInformationType;
import de.governikus.csl.algorithm_catalog.gen.PublisherType;
import de.governikus.csl.algorithm_catalog.gen.UsageType;
import de.governikus.csl.algorithm_catalog.gen.ValidityType;
import de.governikus.csl.uom.validate.AlgorithmCatalogMetaInformation;
import de.governikus.csl.uom.validate.SignatureAlgorithmParameter;
import de.governikus.utils.secutils.SecurityUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlgorithmCatalog {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlgorithmCatalog.class);
    static final String EXCP_MSG_MISSING_USAGE = "Usage must be defined. Expiration date can only be provided for a specific usage.";
    private AlgorithmCatalogType catalog;
    private Map<String, List<SortableEvaluationType>> mapAlgorithmValidities = new HashMap<String, List<SortableEvaluationType>>();
    private AlgorithmCatalogMetaInformation metaInf;

    AlgorithmCatalog() {
    }

    void load(InputStream file) throws JAXBException, IOException, XMLStreamException {
        PublisherType publisher;
        LOGGER.info("Loading algorithm catalog");
        if (file == null) {
            LOGGER.warn("The given source does not exist. No algorithm catalog loaded!");
            throw new IOException("The given source does not exist. No algorithm catalog loaded!");
        }
        JAXBContext jaxbContext = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName(), (ClassLoader)AlgorithmCatalog.class.getClassLoader());
        Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
        XMLInputFactory xif = XMLInputFactory.newInstance();
        SecurityUtils.protectFactoryAgainstXXE((XMLInputFactory)xif);
        XMLStreamReader xsr = xif.createXMLStreamReader(file);
        this.catalog = (AlgorithmCatalogType)unmarshaller.unmarshal(xsr, AlgorithmCatalogType.class).getValue();
        this.metaInf = new AlgorithmCatalogMetaInformation();
        PolicyInformationType policyInformation = this.getPolicyInformation();
        if (policyInformation != null) {
            this.metaInf.setVersion(policyInformation.getVersion().trim());
            this.metaInf.setName(policyInformation.getName().trim());
            this.metaInf.setInformationURL(policyInformation.getURI().trim());
            this.metaInf.setIssueDate(policyInformation.getIssueDate());
        }
        if ((publisher = this.getPublisher()) != null) {
            this.metaInf.setCountry(publisher.getCountry().trim());
            this.metaInf.setPublisher(publisher.getName().trim());
            this.metaInf.setPublisherURL(publisher.getURI().trim());
        }
        List<AlgorithmValidityType> lst = this.catalog.getAlgorithmValidity();
        for (AlgorithmValidityType val : lst) {
            ArrayList<SortableEvaluationType> l = new ArrayList<SortableEvaluationType>();
            for (EvaluationType e : val.getEvaluation()) {
                for (ValidityType v : e.getValidity()) {
                    SortableEvaluationType se = new SortableEvaluationType(e.getParameter(), v.getEnd(), v.getUsages(), v.isWithoutExpirationDate());
                    l.add(se);
                }
            }
            String algorithm = val.getAlgorithm();
            List<SortableEvaluationType> existingAlgorithms = this.mapAlgorithmValidities.get(algorithm);
            if (existingAlgorithms != null) {
                existingAlgorithms.addAll(l);
                existingAlgorithms.sort(null);
                continue;
            }
            l.sort(null);
            this.mapAlgorithmValidities.put(algorithm, l);
        }
    }

    Map<String, List<SortableEvaluationType>> getAlgorithmValidities() {
        return this.mapAlgorithmValidities;
    }

    private boolean containsUsage(List<UsageType> val, Usage usage) {
        boolean contains = false;
        for (UsageType u : val) {
            if (!u.value().equals(usage.getId())) continue;
            contains = true;
            break;
        }
        return contains;
    }

    AlgorithmCatalogResponse getExpirationInfo(String algorithmName, List<SignatureAlgorithmParameter> parameters, Usage usage) {
        if (usage == null) {
            LOGGER.warn(EXCP_MSG_MISSING_USAGE);
            throw new IllegalArgumentException(EXCP_MSG_MISSING_USAGE);
        }
        AlgorithmCatalogResponse response = new AlgorithmCatalogResponse();
        List<SortableEvaluationType> evaluations = this.mapAlgorithmValidities.get(algorithmName);
        if (evaluations == null) {
            LOGGER.warn("No expiration date for algorithm " + algorithmName + " with the specified parameters in the provided catalog.");
            return response;
        }
        boolean found = false;
        for (SortableEvaluationType e : evaluations) {
            if (!this.containsUsage(e.getUsages(), usage) || !this.isGivenAlgo(e, algorithmName, parameters)) continue;
            response.setWithoutExpirationDate(e.isWithoutExpirationDate());
            response.setExpirationDate(e.getEnd());
            found = true;
            break;
        }
        if (!found) {
            LOGGER.warn("The provided catalog doesn't contain an expiration date for algorithm " + algorithmName + ".");
        }
        return response;
    }

    private boolean isGivenAlgo(SortableEvaluationType e, String name, List<SignatureAlgorithmParameter> param) {
        if (e.getParameter().isEmpty()) {
            return true;
        }
        if (name.equals("ECDSA")) {
            return this.compareEcdsaParams(e, param);
        }
        return this.compareGeneralParams(e, param);
    }

    private boolean compareGeneralParams(SortableEvaluationType e, List<SignatureAlgorithmParameter> param) {
        boolean matches = true;
        Iterator<ParameterType> i = e.getParameter().iterator();
        while (i.hasNext() && matches) {
            ParameterType p = i.next();
            matches = this.compareParams(param, p, false);
        }
        return matches;
    }

    private boolean compareEcdsaParams(SortableEvaluationType e, List<SignatureAlgorithmParameter> param) {
        boolean matches = true;
        Iterator<ParameterType> i = e.getParameter().iterator();
        block8: while (i.hasNext() && matches) {
            ParameterType p = i.next();
            switch (p.getName()) {
                case "class": {
                    matches = this.compareParams(param, p, true);
                    continue block8;
                }
                case "r0": {
                    matches = this.compareParams(param, p, true);
                    continue block8;
                }
            }
            matches = this.compareParams(param, p, false);
        }
        return matches;
    }

    private boolean compareParams(List<SignatureAlgorithmParameter> params, ParameterType p, boolean returnIfNotFound) {
        boolean matches = true;
        if (p.getMin() != null) {
            SignatureAlgorithmParameter param = this.getParamByName(params, p.getName());
            if (param == null) {
                return returnIfNotFound;
            }
            boolean bl = matches = param.getValue() >= p.getMin();
            if (matches && p.getMax() != null) {
                matches = param.getValue() <= p.getMax();
            }
        }
        return matches;
    }

    private SignatureAlgorithmParameter getParamByName(List<SignatureAlgorithmParameter> param, String name) {
        for (SignatureAlgorithmParameter p : param) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public String getCountry() {
        return this.catalog.getPublisher().getCountry();
    }

    Date getPolicyIssueDate(String country) {
        return this.catalog.getPolicyInformation().getIssueDate();
    }

    PublisherType getPublisher() {
        return this.catalog.getPublisher();
    }

    PolicyInformationType getPolicyInformation() {
        return this.catalog.getPolicyInformation();
    }

    public void addReliabilityConcern(String concern) {
        this.metaInf.addReliabilityConcern(concern);
    }

    public List<String> getReliabilityConcerns() {
        return this.metaInf.getReliabilityConcerns();
    }

    public AlgorithmCatalogMetaInformation getCatalogMetaData() {
        return this.metaInf;
    }
}

