/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csc.keycloak.client;

import de.governikus.csc.keycloak.client.AccessTokenClient;
import de.governikus.csc.keycloak.client.AccessTokenClientBuilder;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.KeycloakDeploymentBuilder;
import org.keycloak.authorization.client.AuthzClient;
import org.keycloak.authorization.client.ClientAuthenticator;
import org.keycloak.authorization.client.Configuration;
import org.keycloak.crypto.AsymmetricSignatureSignerContext;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureException;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.jose.jws.JWSBuilder;
import org.keycloak.jose.jws.JWSInput;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.representations.adapters.config.AdapterConfig;
import org.keycloak.util.JsonSerialization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthClient
implements AccessTokenClient {
    private static final Logger log = LoggerFactory.getLogger(OAuthClient.class);
    private static final String CLASSPATH = "classpath:";
    private JsonWebToken jwt;
    private String accessToken;
    private String tokenType;
    private AuthzClient authzClient;
    private KeycloakDeployment keycloakDeployment;

    public OAuthClient(AdapterConfig config) {
        this.keycloakDeployment = KeycloakDeploymentBuilder.build((AdapterConfig)config);
        this.initAuthzClient();
    }

    public OAuthClient(String jsonConfig) throws IOException {
        if (jsonConfig.startsWith(CLASSPATH)) {
            try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(jsonConfig.replace(CLASSPATH, ""));){
                this.keycloakDeployment = KeycloakDeploymentBuilder.build((InputStream)inputStream);
            }
        }
        try (FileInputStream inputStream = new FileInputStream(jsonConfig);){
            this.keycloakDeployment = KeycloakDeploymentBuilder.build((InputStream)inputStream);
        }
        this.initAuthzClient();
    }

    public OAuthClient(KeycloakDeployment keycloakDeployment) {
        this.keycloakDeployment = keycloakDeployment;
        this.initAuthzClient();
    }

    public String getBearerTokenHeader() throws IOException {
        this.updateTokenIfNecessary();
        return this.tokenType + " " + this.accessToken;
    }

    public String getAccessToken() throws IOException {
        this.updateTokenIfNecessary();
        return this.accessToken;
    }

    private synchronized void updateTokenIfNecessary() throws IOException {
        if (this.accessToken == null || this.jwt == null || this.jwt.isExpired()) {
            log.debug("Fetching new access token from the authorization server");
            AccessTokenResponse response = this.authzClient.obtainAccessToken();
            this.accessToken = response.getToken();
            this.tokenType = response.getTokenType();
            try {
                JWSInput jwsInput = new JWSInput(this.accessToken);
                this.jwt = (JsonWebToken)JsonSerialization.readValue((byte[])jwsInput.getContent(), JsonWebToken.class);
                log.debug("Got new access token (expires at: {})", (Object)Instant.ofEpochSecond(this.jwt.getExp()).toString());
            }
            catch (JWSInputException e) {
                throw new IOException(e);
            }
        } else {
            log.debug("Token is still valid (expires at: {})", (Object)Instant.ofEpochSecond(this.jwt.getExp()).toString());
        }
    }

    private ClientAuthenticator getJwtClientAuthenticator() {
        return (requestParams, requestHeaders) -> {
            String signedRequestToken = this.getSignedRequestToken();
            requestParams.put("client_assertion_type", Collections.singletonList("urn:ietf:params:oauth:client-assertion-type:jwt-bearer"));
            requestParams.put("client_assertion", Collections.singletonList(signedRequestToken));
        };
    }

    private String getSignedRequestToken() {
        try {
            PrivateKey signatureKey = this.loadSignatureKey();
            KeyWrapper keyWrapper = new KeyWrapper();
            keyWrapper.setPrivateKey((Key)signatureKey);
            keyWrapper.setAlgorithm("RS256");
            return new JWSBuilder().jsonContent((Object)this.getJwt()).sign((SignatureSignerContext)new AsymmetricSignatureSignerContext(keyWrapper));
        }
        catch (IOException | URISyntaxException | GeneralSecurityException | SignatureException e) {
            log.error("Could not sign JSON web token", e);
            return null;
        }
    }

    private JsonWebToken getJwt() throws URISyntaxException {
        String authServerBaseUrl = this.keycloakDeployment.getAuthServerBaseUrl();
        while (authServerBaseUrl.endsWith("/")) {
            authServerBaseUrl = authServerBaseUrl.substring(0, authServerBaseUrl.lastIndexOf(47));
        }
        String audience = String.format("%s/realms/%s", authServerBaseUrl, this.keycloakDeployment.getRealm());
        return new JsonWebToken().id(UUID.randomUUID().toString()).issuer(this.keycloakDeployment.getResourceName()).subject(this.keycloakDeployment.getResourceName()).audience(new String[]{audience}).issuedNow();
    }

    private PrivateKey loadSignatureKey() throws GeneralSecurityException, IOException {
        Map jwtObject = (Map)this.keycloakDeployment.getResourceCredentials().get("jwt");
        String keystorePath = (String)jwtObject.get("client-keystore-file");
        String keystorePassword = (String)jwtObject.get("client-keystore-password");
        String alias = this.keycloakDeployment.getResourceName();
        KeyStore keyStore = KeyStore.getInstance("JKS");
        boolean isClasspath = keystorePath.startsWith(CLASSPATH);
        if (isClasspath) {
            try (InputStream is = OAuthClient.class.getClassLoader().getResourceAsStream(keystorePath.replaceFirst("^classpath:", ""));){
                keyStore.load(is, keystorePassword.toCharArray());
            }
        }
        try (FileInputStream inputStream = new FileInputStream(keystorePath);){
            keyStore.load(inputStream, keystorePassword.toCharArray());
        }
        return (PrivateKey)keyStore.getKey(alias, keystorePassword.toCharArray());
    }

    private void initAuthzClient() {
        if (this.keycloakDeployment != null && this.keycloakDeployment.getResourceCredentials().containsKey("jwt")) {
            this.authzClient = AuthzClient.create((Configuration)new Configuration(this.keycloakDeployment.getAuthServerBaseUrl(), this.keycloakDeployment.getRealm(), this.keycloakDeployment.getResourceName(), this.keycloakDeployment.getResourceCredentials(), this.keycloakDeployment.getClient()), (ClientAuthenticator)this.getJwtClientAuthenticator());
        } else if (this.keycloakDeployment != null && this.keycloakDeployment.getResourceCredentials().containsKey("secret")) {
            this.authzClient = AuthzClient.create((Configuration)new Configuration(this.keycloakDeployment.getAuthServerBaseUrl(), this.keycloakDeployment.getRealm(), this.keycloakDeployment.getResourceName(), this.keycloakDeployment.getResourceCredentials(), this.keycloakDeployment.getClient()));
        } else {
            throw new IllegalArgumentException("Resource credentials missing!");
        }
    }

    public OAuthClient() {
    }

    public static class OAuthClientBuilder
    implements AccessTokenClientBuilder<OAuthClient> {
        private String jsonConfigFile;

        public OAuthClientBuilder(String jsonConfigFile) {
            this.jsonConfigFile = jsonConfigFile;
        }

        public OAuthClient build() {
            try {
                return new OAuthClient(this.jsonConfigFile);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

