/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xades.ats;

import de.governikus.csl.uom.StreamProvider;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class ArchiveTimestampMessageDigestStream
extends InputStream {
    private List<StreamProvider> delegates;
    private InputStream currentDelegate;
    private int nextDelegate;

    public ArchiveTimestampMessageDigestStream(List<StreamProvider> delegates) {
        this.delegates = delegates;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read() throws IOException {
        if (this.currentDelegate == null) {
            this.getNextDelegate();
        }
        if (this.currentDelegate == null) {
            return -1;
        }
        int read = this.currentDelegate.read();
        if (read < 0) {
            this.getNextDelegate();
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.currentDelegate == null) {
            this.getNextDelegate();
        }
        if (this.currentDelegate == null) {
            return -1;
        }
        int totalRead = 0;
        int toRead = len;
        while (toRead > 0) {
            if (this.currentDelegate == null) {
                return totalRead;
            }
            int read = this.currentDelegate.read(b, off + totalRead, toRead);
            if (read < toRead) {
                this.getNextDelegate();
            }
            if (read < 0) continue;
            totalRead += read;
            toRead -= read;
        }
        return totalRead;
    }

    private void getNextDelegate() throws IOException {
        if (this.currentDelegate != null) {
            this.currentDelegate.close();
        }
        this.currentDelegate = this.nextDelegate < this.delegates.size() ? this.delegates.get(this.nextDelegate).getInputStream() : null;
        ++this.nextDelegate;
    }
}

