/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xades.ats;

import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.StreamProvider;
import de.governikus.csl.xades.ats.ArchiveTimestampMessageDigestStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ArchiveTimestampMessageDigestProvider
implements StreamProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchiveTimestampMessageDigestProvider.class);
    private static final String XADES_NS_1_3_2 = "http://uri.etsi.org/01903/v1.3.2#";
    private static final String XADES_NS_1_4_1 = "http://uri.etsi.org/01903/v1.4.1#";
    private XMLSignature signature;
    private SignedInfo signedInfo;
    private String canonAlgo;
    private int archiveTimestampPos;
    private List<? extends Document> contentFiles;
    private int detachedContentCtr = 0;

    public ArchiveTimestampMessageDigestProvider(XMLSignature aSig, String canonAlgo, int archiveTimestampPos, List<? extends Document> contentFiles) {
        this.signature = aSig;
        this.signedInfo = aSig.getSignedInfo();
        this.archiveTimestampPos = archiveTimestampPos;
        this.canonAlgo = canonAlgo;
        this.contentFiles = contentFiles;
    }

    public InputStream getInputStream() throws IOException {
        try {
            return new ArchiveTimestampMessageDigestStream(this.getStreamContent());
        }
        catch (XMLSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private List<StreamProvider> getStreamContent() throws XMLSecurityException {
        ArrayList<StreamProvider> result = new ArrayList<StreamProvider>();
        for (int i = 0; i < this.signedInfo.getLength(); ++i) {
            Reference ref = this.signedInfo.item(i);
            result.add(() -> this.getStreamFromReference(ref));
        }
        result.add(this::getSignedInfoStream);
        result.add(this::getSignatureValueStream);
        result.add(this::getKeyInfoStream);
        result.addAll(this.getUnsignedAttributeStreams());
        result.addAll(this.getObjectsStream());
        return result;
    }

    private Collection<? extends StreamProvider> getObjectsStream() {
        ArrayList<StreamProvider> result = new ArrayList<StreamProvider>();
        for (int i = 0; i < this.signature.getObjectLength(); ++i) {
            ObjectContainer objectItem = this.signature.getObjectItem(i);
            Element element = objectItem.getElement();
            NodeList qualifyingProperties = element.getElementsByTagNameNS(XADES_NS_1_3_2, "QualifyingProperties");
            if (qualifyingProperties.getLength() > 0) continue;
            result.add(() -> this.canonicalize(element));
        }
        return result;
    }

    private Collection<? extends StreamProvider> getUnsignedAttributeStreams() {
        ArrayList<? extends StreamProvider> result = new ArrayList<StreamProvider>();
        for (int i = 0; i < this.signature.getObjectLength(); ++i) {
            Element eItem;
            NodeList unsignedSignaturePropertiesList;
            Node item;
            ObjectContainer objectItem = this.signature.getObjectItem(i);
            Element element = objectItem.getElement();
            NodeList qualifyingProperties = element.getElementsByTagNameNS(XADES_NS_1_3_2, "QualifyingProperties");
            if (qualifyingProperties.getLength() <= 0 || !((item = qualifyingProperties.item(0)) instanceof Element) || (unsignedSignaturePropertiesList = (eItem = (Element)item).getElementsByTagNameNS(XADES_NS_1_3_2, "UnsignedSignatureProperties")).getLength() <= 0) continue;
            Node unsignedSignatureProperties = unsignedSignaturePropertiesList.item(0);
            result.addAll(this.getUnsignedAttributeStreams((Element)unsignedSignatureProperties));
        }
        return result;
    }

    private Collection<? extends StreamProvider> getUnsignedAttributeStreams(Element unsignedSignatureProperties) {
        NodeList childNodes = unsignedSignatureProperties.getChildNodes();
        ArrayList<StreamProvider> result = new ArrayList<StreamProvider>();
        int numArchiveTimestamps = 0;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (item.getNodeType() != 1) continue;
            if (this.isArchiveTimestampNode(item)) {
                if (numArchiveTimestamps >= this.archiveTimestampPos) break;
                ++numArchiveTimestamps;
            }
            result.add(() -> this.canonicalize(item));
        }
        return result;
    }

    private boolean isArchiveTimestampNode(Node item) {
        String namespaceURI = item.getNamespaceURI();
        if (namespaceURI == null) {
            return false;
        }
        return (namespaceURI.equals(XADES_NS_1_3_2) || namespaceURI.equals(XADES_NS_1_4_1)) && item.getLocalName().equals("ArchiveTimeStamp");
    }

    private InputStream getKeyInfoStream() {
        Element sigElement = this.signature.getElement();
        NodeList sigValue = sigElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        if (sigValue.getLength() == 0) {
            return new EmptyInputStream();
        }
        return this.canonicalize(sigValue.item(0));
    }

    private InputStream canonicalize(Node n) {
        if (n instanceof Element) {
            return this.canonicalize((Element)n);
        }
        throw new RuntimeException();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream canonicalize(Element n) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            Canonicalizer canonicalizer = Canonicalizer.getInstance((String)this.canonAlgo);
            canonicalizer.canonicalizeSubtree((Node)n, (OutputStream)baos);
            byte[] byteArray = baos.toByteArray();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArray);
            return byteArrayInputStream;
        }
        catch (IOException | CanonicalizationException | InvalidCanonicalizerException e) {
            throw new RuntimeException(e);
        }
    }

    private InputStream getSignatureValueStream() {
        Element sigElement = this.signature.getElement();
        NodeList sigValue = sigElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureValue");
        return this.canonicalize(sigValue.item(0));
    }

    private InputStream getSignedInfoStream() {
        return this.canonicalize(this.signedInfo.getElement());
    }

    private InputStream getStreamFromReference(Reference ref) throws IOException {
        try {
            byte[] referencedBytes = ref.getReferencedBytes();
            return new ByteArrayInputStream(referencedBytes);
        }
        catch (XMLSecurityException e) {
            if (this.contentFiles != null && !this.contentFiles.isEmpty() && ref != null && this.contentFiles.size() > this.detachedContentCtr) {
                Document content = this.contentFiles.get(this.detachedContentCtr++);
                return content.getInputStream();
            }
            throw new IOException("Can't find the referenced content");
        }
    }

    private static final class EmptyInputStream
    extends InputStream {
        private EmptyInputStream() {
        }

        @Override
        public int read() throws IOException {
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return -1;
        }
    }
}

