/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xades;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLNSCollector {
    private static final String XMLNAMESPACE = "xmlns";

    public List<String[]> getAllPrefixes(Element e) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        this.getPrefixesRecursive(e, result);
        return result;
    }

    private void getPrefixesRecursive(Element element, List<String[]> prefixes) {
        this.getPrefixes(element, prefixes);
        NodeList childs = element.getChildNodes();
        if (childs != null) {
            for (int i = 0; i < childs.getLength(); ++i) {
                Node child = childs.item(i);
                if (!(child instanceof Element)) continue;
                this.getPrefixesRecursive((Element)child, prefixes);
            }
        }
    }

    private void getPrefixes(Element element, List<String[]> prefixes) {
        NamedNodeMap atts = element.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Node node = atts.item(i);
            String name = node.getNodeName();
            if (name == null || !XMLNAMESPACE.equals(name) && !name.startsWith("xmlns:")) continue;
            String[] prefixMapping = new String[]{node.getLocalName(), node.getTextContent()};
            prefixes.add(prefixMapping);
        }
    }
}

