/*
 * Decompiled with CFR 0.152.
 */
package de.governikus.csl.xades;

import de.governikus.csl.uom.CoreException;
import de.governikus.csl.uom.Document;
import de.governikus.csl.uom.SignedData;
import de.governikus.utils.secutils.SecurityUtils;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class DocumentParser {
    public org.w3c.dom.Document parse(InputStream is) throws SAXException, IOException, XPathExpressionException, CoreException {
        DocumentBuilder documentBuilder = this.newNamespaceAwareDocumentBuilder(true);
        documentBuilder.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
        org.w3c.dom.Document d = documentBuilder.parse(is);
        DocumentParser.markIds(d.getDocumentElement());
        return d;
    }

    public org.w3c.dom.Document parse(Document signedData) throws IOException, SAXException, XPathExpressionException, CoreException {
        try (InputStream is = signedData.getInputStream();){
            org.w3c.dom.Document document = this.parse(is);
            return document;
        }
    }

    public org.w3c.dom.Document parse(SignedData signedData) throws IOException, SAXException, XPathExpressionException, CoreException {
        return this.parse(signedData.getSignature());
    }

    private DocumentBuilder newNamespaceAwareDocumentBuilder(boolean namespaceAware) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            SecurityUtils.protectFactoryAgainstXXE((DocumentBuilderFactory)dbf);
            dbf.setNamespaceAware(namespaceAware);
            return dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void markIds(Node node) throws XPathExpressionException, CoreException {
        NodeList childNodes;
        Node namedItem;
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null && (namedItem = attributes.getNamedItem("Id")) != null && namedItem.getNodeType() == 2) {
            Attr attrib = (Attr)namedItem;
            Element element = attrib.getOwnerElement();
            element.setIdAttributeNode(attrib, true);
        }
        if ((childNodes = node.getChildNodes()) == null) {
            return;
        }
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            DocumentParser.markIds(child);
        }
    }
}

