/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.soapheader;

import de.osci.osci12.common.Constants;
import de.osci.osci12.roles.Addressee;
import de.osci.osci12.roles.Author;
import de.osci.osci12.roles.OSCIRoleException;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.roles.Reader;
import de.osci.osci12.soapheader.CertificateH;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;

public class NonIntermediaryCertificatesH
extends CertificateH {
    private Originator cipherCertificateOriginator;
    private Author[] cipherCertificatesOtherAuthors;
    private Addressee cipherCertificateAddressee;
    private Reader[] cipherCertificatesOtherReaders;
    private Originator signatureCertificateOriginator;
    private Addressee signatureCertificateAddressee;
    private Author[] signatureCertificatesOtherAuthors;

    public void setCipherCertificateAddressee(Addressee cipherCertificateAddressee) throws OSCIRoleException {
        this.certificates.put(cipherCertificateAddressee.getCipherCertificateId(), cipherCertificateAddressee.getCipherCertificate());
        this.cipherCertificateAddressee = cipherCertificateAddressee;
    }

    public void setCipherCertificateOriginator(Originator cipherCertificateOriginator) throws OSCIRoleException {
        this.certificates.put(cipherCertificateOriginator.getCipherCertificateId(), cipherCertificateOriginator.getCipherCertificate());
        this.cipherCertificateOriginator = cipherCertificateOriginator;
    }

    public void setCipherCertificatesOtherAuthors(Author[] cipherCertificatesOtherAuthors) throws OSCIRoleException {
        Hashtable<String, Author> hs = new Hashtable<String, Author>();
        for (int i = 0; i < cipherCertificatesOtherAuthors.length; ++i) {
            if (hs.containsKey(cipherCertificatesOtherAuthors[i].getCipherCertificateId())) {
                if (((Author)hs.get(cipherCertificatesOtherAuthors[i].getCipherCertificateId())).getCipherCertificate().equals(cipherCertificatesOtherAuthors[i].getCipherCertificate())) continue;
                throw new OSCIRoleException("id_conflict_cipher_author", cipherCertificatesOtherAuthors[i].getCipherCertificateId());
            }
            hs.put(cipherCertificatesOtherAuthors[i].getCipherCertificateId(), cipherCertificatesOtherAuthors[i]);
            this.certificates.put(cipherCertificatesOtherAuthors[i].getCipherCertificateId(), cipherCertificatesOtherAuthors[i].getCipherCertificate());
        }
        this.cipherCertificatesOtherAuthors = hs.values().toArray(new Author[hs.size()]);
    }

    public void setCipherCertificatesOtherReaders(Reader[] cipherCertificatesOtherReaders) throws OSCIRoleException {
        Hashtable<String, Reader> hs = new Hashtable<String, Reader>();
        for (int i = 0; i < cipherCertificatesOtherReaders.length; ++i) {
            if (hs.containsKey(cipherCertificatesOtherReaders[i].getCipherCertificateId())) {
                if (((Reader)hs.get(cipherCertificatesOtherReaders[i].getCipherCertificateId())).getCipherCertificate().equals(cipherCertificatesOtherReaders[i].getCipherCertificate())) continue;
                throw new OSCIRoleException("id_conflict_reader", cipherCertificatesOtherReaders[i].getCipherCertificateId());
            }
            hs.put(cipherCertificatesOtherReaders[i].getCipherCertificateId(), cipherCertificatesOtherReaders[i]);
            this.certificates.put(cipherCertificatesOtherReaders[i].getCipherCertificateId(), cipherCertificatesOtherReaders[i].getCipherCertificate());
        }
        this.cipherCertificatesOtherReaders = hs.values().toArray(new Reader[hs.size()]);
    }

    public void setSignatureCertificateOriginator(Originator signatureCertificateOriginator) throws OSCIRoleException {
        this.certificates.put(signatureCertificateOriginator.getSignatureCertificateId(), signatureCertificateOriginator.getSignatureCertificate());
        this.signatureCertificateOriginator = signatureCertificateOriginator;
    }

    public void setSignatureCertificateAddressee(Addressee signatureCertificateAddressee) throws OSCIRoleException {
        this.certificates.put(signatureCertificateAddressee.getSignatureCertificateId(), signatureCertificateAddressee.getSignatureCertificate());
        this.signatureCertificateAddressee = signatureCertificateAddressee;
    }

    public void setSignatureCertificatesOtherAuthors(Author[] signatureCertificatesOtherAuthors) throws OSCIRoleException {
        Hashtable<String, Author> hs = new Hashtable<String, Author>();
        for (int i = 0; i < signatureCertificatesOtherAuthors.length; ++i) {
            if (hs.containsKey(signatureCertificatesOtherAuthors[i].getSignatureCertificateId())) {
                if (((Author)hs.get(signatureCertificatesOtherAuthors[i].getSignatureCertificateId())).getSignatureCertificate().equals(signatureCertificatesOtherAuthors[i].getSignatureCertificate())) continue;
                throw new OSCIRoleException("id_conflict_signer_author", signatureCertificatesOtherAuthors[i].getSignatureCertificateId());
            }
            hs.put(signatureCertificatesOtherAuthors[i].getSignatureCertificateId(), signatureCertificatesOtherAuthors[i]);
            this.certificates.put(signatureCertificatesOtherAuthors[i].getSignatureCertificateId(), signatureCertificatesOtherAuthors[i].getSignatureCertificate());
        }
        this.signatureCertificatesOtherAuthors = hs.values().toArray(new Author[hs.size()]);
    }

    @Override
    public void writeXML(OutputStream out) throws IOException, OSCIRoleException {
        int i;
        out.write(("<" + this.osciNSPrefix + ":NonIntermediaryCertificates").getBytes(Constants.CHARSET_ENCODING));
        out.write(this.ns);
        out.write((" Id=\"nonintermediarycertificates\" " + this.soapNSPrefix + ":actor=\"http://www.w3.org/2001/12/soap-envelope/actor/none\" " + this.soapNSPrefix + ":mustUnderstand=\"1\">").getBytes(Constants.CHARSET_ENCODING));
        if (this.cipherCertificateOriginator != null) {
            this.addCipherCertificate(this.cipherCertificateOriginator, out);
        }
        if (this.cipherCertificatesOtherAuthors != null) {
            for (i = 0; i < this.cipherCertificatesOtherAuthors.length; ++i) {
                this.addCipherCertificate(this.cipherCertificatesOtherAuthors[i], out);
            }
        }
        if (this.cipherCertificateAddressee != null) {
            this.addCipherCertificate(this.cipherCertificateAddressee, out);
        }
        if (this.cipherCertificatesOtherReaders != null) {
            for (i = 0; i < this.cipherCertificatesOtherReaders.length; ++i) {
                this.addCipherCertificate(this.cipherCertificatesOtherReaders[i], out);
            }
        }
        if (this.signatureCertificateOriginator != null) {
            this.addSignatureCertificate(this.signatureCertificateOriginator, out);
        }
        if (this.signatureCertificateAddressee != null) {
            this.addSignatureCertificate(this.signatureCertificateAddressee, out);
        }
        if (this.signatureCertificatesOtherAuthors != null) {
            for (i = 0; i < this.signatureCertificatesOtherAuthors.length; ++i) {
                this.addSignatureCertificate(this.signatureCertificatesOtherAuthors[i], out);
            }
        }
        out.write(("</" + this.osciNSPrefix + ":NonIntermediaryCertificates>").getBytes(Constants.CHARSET_ENCODING));
    }

    public Addressee getCipherCertificateAddressee() {
        return this.cipherCertificateAddressee;
    }

    public Originator getCipherCertificateOriginator() {
        return this.cipherCertificateOriginator;
    }

    public Author[] getCipherCertificatesOtherAuthors() {
        return this.cipherCertificatesOtherAuthors;
    }

    public Reader[] getCipherCertificatesOtherReaders() {
        return this.cipherCertificatesOtherReaders;
    }

    public Addressee getSignatureCertificateAddressee() {
        return this.signatureCertificateAddressee;
    }

    public Originator getSignatureCertificateOriginator() {
        return this.signatureCertificateOriginator;
    }

    public Author[] getSignatureCertificatesOtherAuthors() {
        return this.signatureCertificatesOtherAuthors;
    }
}

