/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.soapheader;

import de.osci.helper.Base64InputStream;
import de.osci.helper.ParserHelper;
import de.osci.helper.Tools;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.MessagePartParser;
import de.osci.osci12.messagetypes.OSCIMessage;
import de.osci.osci12.messagetypes.OSCIMessageBuilder;
import de.osci.osci12.roles.Intermed;
import de.osci.osci12.soapheader.IntermediaryCertificatesH;
import java.io.ByteArrayInputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class IntermediaryCertificatesHBuilder
extends MessagePartParser {
    private static Log log = LogFactory.getLog(IntermediaryCertificatesHBuilder.class);
    private static final int CIPHER_CERTIFICATE_INTERMEDIARY = 0;
    private static final int SIGNATURE_CERTIFICATE_INTERMEDIARY = 1;
    private int[] check;
    private IntermediaryCertificatesH ich;
    private int typ;
    private String refId;
    private Intermed intermed;

    public IntermediaryCertificatesHBuilder(OSCIMessageBuilder parentHandler, Attributes atts, int[] check) throws SAXException {
        super(parentHandler);
        parentHandler.addFoundMsgPartIds(atts.getValue("Id"), Constants.HeaderTags.IntermediaryCertificates.getNamespace().getUri() + ":" + Constants.HeaderTags.IntermediaryCertificates.getElementName());
        this.check = check;
        this.ich = new IntermediaryCertificatesH();
        OSCIMessage msg = parentHandler.getOSCIMessage();
        this.ich.setNSPrefixes(msg);
        int msgTyp = msg.getMessageType();
        if (msgTyp == 1 || msgTyp == 16 || msgTyp == 9 || msgTyp == 144) {
            this.intermed = (Intermed)msg.dialogHandler.getClient();
            if (this.intermed == null) {
                this.intermed = new Intermed(null, null, null);
                msg.dialogHandler.client = this.intermed;
            }
        } else {
            this.intermed = (Intermed)msg.dialogHandler.getSupplier();
        }
        if (atts.getValue("Id") != null) {
            this.ich.setRefID(atts.getValue("Id"));
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start-Element: " + localName));
        }
        if (localName.equals("CipherCertificateIntermediary") && uri.equals(OSCI_XMLNS)) {
            this.typ = 0;
        } else if (localName.equals("SignatureCertificateIntermediary") && uri.equals(OSCI_XMLNS)) {
            this.typ = 1;
        } else if (localName.equals("X509Certificate") && uri.equals(DS_XMLNS)) {
            this.currentElement = new StringBuffer();
        } else if (!localName.equals("X509Data") || !uri.equals(DS_XMLNS)) {
            throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
        }
        if (this.check[this.typ] == 0) {
            throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": IntermediaryCertificate");
        }
        if (attributes.getValue("Id") != null) {
            this.refId = attributes.getValue("Id");
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        block18: {
            try {
                X509Certificate cert;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("End-Element: " + localName));
                }
                if (ParserHelper.isElement(Constants.HeaderTags.IntermediaryCertificates, localName, uri)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Setze IntermedCertificates");
                    }
                    this.msg.intermediaryCertificatesH = this.ich;
                    this.xmlReader.setContentHandler(this.parentHandler);
                    break block18;
                }
                if (!localName.equals("X509Certificate") || !uri.equals(DS_XMLNS)) break block18;
                try {
                    ByteArrayInputStream byteStream = new ByteArrayInputStream(this.currentElement.toString().getBytes(Constants.CHARSET_ENCODING));
                    Base64InputStream base64In = new Base64InputStream(byteStream);
                    cert = Tools.createCertificate(base64In);
                }
                catch (CertificateException ex) {
                    throw new SAXException(DialogHandler.text.getString("cert_gen_error"), ex);
                }
                if (this.typ == 0) {
                    if (this.intermed.hasCipherCertificate()) {
                        if (!this.intermed.getCipherCertificate().equals(cert)) {
                            throw new IllegalStateException(DialogHandler.text.getString("not_matching_cipher_certs") + " Intermediary");
                        }
                    } else {
                        this.intermed.setCipherCertificate(cert);
                    }
                    this.intermed.cipherRefId = this.refId;
                    this.ich.setCipherCertificateIntermediary(this.intermed);
                } else if (this.typ == 1) {
                    if (this.intermed.hasSignatureCertificate()) {
                        if (!this.intermed.getSignatureCertificate().equals(cert)) {
                            throw new IllegalStateException(DialogHandler.text.getString("not_matching_sig_certs") + " Intermediary");
                        }
                    } else {
                        this.intermed.setSignatureCertificate(cert);
                    }
                    this.intermed.signatureRefId = this.refId;
                    this.ich.setSignatureCertificateIntermediary(this.intermed);
                }
            }
            catch (SAXException ex) {
                throw ex;
            }
            catch (Exception ex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fehler im End-Element.", (Throwable)ex);
                }
                throw new SAXException(ex);
            }
        }
        this.typ = -1;
        this.currentElement = null;
    }
}

