/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.soapheader;

import de.osci.helper.ParserHelper;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.MessagePartParser;
import de.osci.osci12.messagetypes.OSCIMessageBuilder;
import de.osci.osci12.soapheader.FeatureDescriptionH;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FeatureDescriptionHBuilder
extends MessagePartParser {
    private static Log log = LogFactory.getLog(FeatureDescriptionHBuilder.class);
    private FeatureDescriptionH featureDesc = null;
    private boolean insideSupportedFeatures = false;

    public FeatureDescriptionHBuilder(OSCIMessageBuilder parent, Attributes atts) throws SAXException {
        super(parent);
        parent.addFoundMsgPartIds(atts.getValue("Id"), Constants.HeaderTags.FeatureDescription.getNamespace().getUri() + ":" + Constants.HeaderTags.FeatureDescription.getElementName());
        this.featureDesc = new FeatureDescriptionH();
        this.featureDesc.setNSPrefixes(this.msg);
        if (atts.getValue("Id") != null) {
            this.featureDesc.setRefID(atts.getValue("Id"));
        }
    }

    public FeatureDescriptionH getFeatureDescriptionH() {
        return this.featureDesc;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("FeatureDescription Element: " + localName));
        }
        if (ParserHelper.isElement(Constants.HeaderTags.FeatureDescription, localName, uri)) {
            if (attributes.getValue("MaxChunkSize") != null) {
                this.featureDesc.setMaxChunkSize(Long.valueOf(attributes.getValue("MaxChunkSize")));
            }
            if (attributes.getValue("MaxMessageSize") != null) {
                this.featureDesc.setMaxMessageSize(Long.valueOf(attributes.getValue("MaxMessageSize")));
            }
            if (attributes.getValue("MinChunkSize") != null) {
                this.featureDesc.setMinChunkSize(Long.valueOf(attributes.getValue("MinChunkSize")));
            }
            if (attributes.getValue("ChunkMessageTimeout") != null) {
                this.featureDesc.setChunkMessageTimeout(Long.valueOf(attributes.getValue("ChunkMessageTimeout")));
            }
        } else if ("SupportedFeatures".equals(localName) && uri.equals(Constants.Namespaces.OSCI2017.getUri())) {
            this.insideSupportedFeatures = true;
        } else if (this.insideSupportedFeatures && "Feature".equals(localName) && uri.equals(Constants.Namespaces.OSCI2017.getUri())) {
            if (attributes.getValue("Key") != null) {
                try {
                    Constants.OSCIFeatures feature = Constants.OSCIFeatures.valueOf(attributes.getValue("Key"));
                    this.featureDesc.getSupportedFeatures().add(feature);
                }
                catch (IllegalArgumentException | NullPointerException ex) {
                    log.info((Object)("Could not parse key from feature description! Unknown feature (maybe new?): " + attributes.getValue("Key")));
                }
            }
        } else {
            throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("End-Element Von FeatureDescription: " + localName));
        }
        if ("SupportedFeatures".equals(localName) && uri.equals(Constants.Namespaces.OSCI2017.getUri())) {
            this.insideSupportedFeatures = false;
        } else if (!"Feature".equals(localName) || !uri.equals(Constants.Namespaces.OSCI2017.getUri())) {
            if (ParserHelper.isElement(Constants.HeaderTags.FeatureDescription, localName, uri)) {
                this.xmlReader.setContentHandler(this.parentHandler);
                this.msg.setFeatureDescription(this.featureDesc);
            } else {
                throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
            }
        }
    }
}

