/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.soapheader;

import de.osci.helper.ParserHelper;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.common.OSCIErrorException;
import de.osci.osci12.common.OSCIExceptionCodes;
import de.osci.osci12.common.SoapClientException;
import de.osci.osci12.extinterfaces.TransportI;
import de.osci.osci12.messageparts.MessagePartParser;
import de.osci.osci12.messagetypes.OSCIMessageBuilder;
import de.osci.osci12.messagetypes.OSCIRequest;
import de.osci.osci12.roles.Intermed;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.soapheader.ControlBlockH;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ControlBlockHBuilder
extends MessagePartParser {
    private static Log log = LogFactory.getLog(ControlBlockHBuilder.class);
    private int[] check;
    private ControlBlockH cb = null;

    public ControlBlockHBuilder(OSCIMessageBuilder parent, Attributes atts, int[] check) throws SAXException {
        super(parent);
        parent.addFoundMsgPartIds(atts.getValue("Id"), Constants.HeaderTags.ControlBlock.getNamespace().getUri() + ":" + Constants.HeaderTags.ControlBlock.getElementName());
        this.check = check;
        this.cb = new ControlBlockH();
        this.cb.setNSPrefixes(this.msg);
        if (atts.getValue("Id") != null) {
            this.cb.setRefID(atts.getValue("Id"));
        }
        this.cb.setConversationID(atts.getValue("ConversationId"));
        if (atts.getValue("SequenceNumber") != null) {
            this.cb.setSequenceNumber(Integer.parseInt(atts.getValue("SequenceNumber")));
        }
    }

    public ControlBlockH getControlBlock() {
        return this.cb;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init ControlBlock  Element: " + localName));
        }
        if (!(localName.equals("Response") && uri.equals(OSCI_XMLNS) || localName.equals("Challenge") && uri.equals(OSCI_XMLNS))) {
            throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
        }
        this.currentElement = new StringBuffer();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("End-Element Von ControlBlock: " + localName));
        }
        try {
            if (localName.equals("Response") && uri.equals(OSCI_XMLNS)) {
                this.cb.setResponse(this.currentElement.toString());
            } else if (localName.equals("Challenge") && uri.equals(OSCI_XMLNS)) {
                this.cb.setChallenge(this.currentElement.toString());
            } else if (ParserHelper.isElement(Constants.HeaderTags.ControlBlock, localName, uri)) {
                if (this.check[0] == 1 && this.cb.getResponse() == null || this.check[0] == 0 && this.cb.getResponse() != null) {
                    throw new SoapClientException(OSCIExceptionCodes.OSCIErrorCodes.WrongControlBlock);
                }
                if (this.check[1] == 1 && this.cb.getChallenge() == null) {
                    throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Challenge");
                }
                if (this.check[1] == 0 && this.cb.getChallenge() != null) {
                    throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": Challenge");
                }
                if (this.check[2] == 1 && this.cb.getConversationID() == null) {
                    throw new OSCIErrorException((OSCIExceptionCodes.OSCIExceptionCodesI)OSCIExceptionCodes.OSCIErrorCodes.NoExplicitDialog, this.msg);
                }
                if (this.check[2] == 0 && this.cb.getConversationID() != null) {
                    throw new SoapClientException(OSCIExceptionCodes.OSCIErrorCodes.WrongControlBlock);
                }
                if (this.check[3] == 1 && this.cb.getSequenceNumber() == -1) {
                    throw new SoapClientException(OSCIExceptionCodes.OSCIErrorCodes.WrongControlBlock);
                }
                if (this.check[3] == 0 && this.cb.getSequenceNumber() != -1) {
                    throw new SoapClientException(OSCIExceptionCodes.OSCIErrorCodes.WrongControlBlock);
                }
                DialogHandler dh = this.msg.dialogHandler;
                if ((this.check[0] & this.check[1] & this.check[2] & this.check[3]) < 0) {
                    log.debug((Object)"neuer Dialog wird erstellt.");
                    dh = new DialogHandler((Originator)null, new Intermed(null, null, null), (TransportI)null);
                    dh.getControlblock().setConversationID(this.cb.getConversationID());
                    dh.getControlblock().setChallenge(this.cb.getChallenge());
                    dh.getControlblock().setResponse(this.cb.getResponse());
                    dh.getControlblock().setSequenceNumber(this.cb.getSequenceNumber());
                } else {
                    if (dh == null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Dialog wird gesucht: " + this.cb.getConversationID()));
                        }
                        dh = this.cb.getConversationID() != null && !this.cb.getConversationID().equals("") ? DialogHandler.findDialog(this.cb) : new DialogHandler((Originator)null, (Intermed)null, (TransportI)null);
                    }
                    if (this.msg instanceof OSCIRequest && this.cb.getSequenceNumber() > -1) {
                        dh.getControlblock().setSequenceNumber(dh.getControlblock().getSequenceNumber() + 1);
                    }
                    dh.checkControlBlock(this.cb);
                }
                this.msg.dialogHandler = dh;
                this.msg.controlBlock = this.cb;
                this.xmlReader.setContentHandler(this.parentHandler);
            }
            this.currentElement = null;
        }
        catch (SAXException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SAXException(ex);
        }
    }
}

