/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.soapheader;

import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.soapheader.HeaderEntry;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ControlBlockH
extends HeaderEntry {
    private static Log log = LogFactory.getLog(ControlBlockH.class);
    private String challenge = null;
    private String response = null;
    private int sequenceNumber = -1;
    private String conversationID = null;

    public String getChallenge() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("challenge:" + this.challenge));
        }
        return this.challenge;
    }

    public String getConversationID() {
        return this.conversationID;
    }

    public String getResponse() {
        return this.response;
    }

    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void setConversationID(String conversationID) {
        this.conversationID = conversationID;
    }

    public void setChallenge(String challenge) {
        this.challenge = challenge;
    }

    public void setResponse(String response) {
        this.response = response;
    }

    @Override
    public byte[] getDigestValue(String digestAlgorithm) throws NoSuchAlgorithmException, IOException, OSCIException {
        this.digestValues.remove(digestAlgorithm);
        return super.getDigestValue(digestAlgorithm);
    }

    @Override
    public long getLength() throws IOException, OSCIException {
        this.length = -1L;
        return super.getLength();
    }

    @Override
    protected void writeXML(OutputStream out) throws IOException {
        out.write(("<" + this.osciNSPrefix + ":ControlBlock").getBytes(Constants.CHARSET_ENCODING));
        out.write(this.ns);
        if (this.conversationID != null) {
            out.write((" ConversationId=\"" + this.conversationID + "\"").getBytes(Constants.CHARSET_ENCODING));
        }
        out.write(" Id=\"controlblock\"".getBytes(Constants.CHARSET_ENCODING));
        if (this.sequenceNumber != -1) {
            out.write((" SequenceNumber=\"" + this.sequenceNumber + "\"").getBytes(Constants.CHARSET_ENCODING));
        }
        out.write((" " + this.soapNSPrefix + ":actor=\"http://schemas.xmlsoap.org/soap/actor/next\" " + this.soapNSPrefix + ":mustUnderstand=\"1\">").getBytes(Constants.CHARSET_ENCODING));
        if (this.response != null) {
            out.write(("<" + this.osciNSPrefix + ":Response>" + this.response + "</" + this.osciNSPrefix + ":Response>").getBytes(Constants.CHARSET_ENCODING));
        }
        if (this.challenge != null) {
            out.write(("<" + this.osciNSPrefix + ":Challenge>" + this.challenge + "</" + this.osciNSPrefix + ":Challenge>").getBytes(Constants.CHARSET_ENCODING));
        }
        out.write(("</" + this.osciNSPrefix + ":ControlBlock>").getBytes(Constants.CHARSET_ENCODING));
    }
}

