/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.signature;

import de.osci.helper.Base64InputStream;
import de.osci.helper.Tools;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.signature.KeyInfoBuilder;
import de.osci.osci12.signature.X509Data;
import java.io.ByteArrayInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class X509DataBuilder
extends DefaultHandler {
    DefaultHandler parentHandler = null;
    private StringBuffer currentElement = null;
    private X509Data x509Data;
    XMLReader xmlReader = null;
    protected static Log log = LogFactory.getLog(X509DataBuilder.class);
    private final StringBuffer buffer = new StringBuffer();
    protected static final String DS_XMLNS = "http://www.w3.org/2000/09/xmldsig#";
    protected static final String XENC_XMLNS = "http://www.w3.org/2001/04/xmlenc#";

    public X509DataBuilder(XMLReader xmlReader, DefaultHandler parentHandler, Attributes attributes) {
        this.xmlReader = xmlReader;
        this.parentHandler = parentHandler;
        if (attributes == null) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_thirdargument.name()) + " null");
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start-Element: " + localName + "localName: " + localName));
        }
        if (localName.equals("X509Certificate") && uri.equals(DS_XMLNS)) {
            this.currentElement = new StringBuffer();
        } else {
            if (localName.equals("X509IssuerSerial") && uri.equals(DS_XMLNS)) {
                throw new SAXException(DialogHandler.text.getString("unsupported_entry") + ": " + localName);
            }
            if (localName.equals("X509SKI") && uri.equals(DS_XMLNS)) {
                this.currentElement = new StringBuffer();
            } else if (localName.equals("X509SubjectName") && uri.equals(DS_XMLNS)) {
                this.currentElement = new StringBuffer();
            } else if (localName.equals("X509CRL") && uri.equals(DS_XMLNS)) {
                this.currentElement = new StringBuffer();
            } else {
                throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        block12: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("End-Element: " + localName));
            }
            try {
                if (localName.equals("X509Data") && uri.equals(DS_XMLNS)) {
                    if (this.parentHandler instanceof KeyInfoBuilder) {
                        ((KeyInfoBuilder)this.parentHandler).getKeyInfo().x509Data = this.x509Data;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Parent ist KeyInfo");
                        }
                    }
                    this.xmlReader.setContentHandler(this.parentHandler);
                    break block12;
                }
                if (localName.equals("X509Certificate") && uri.equals(DS_XMLNS)) {
                    ByteArrayInputStream bytesStream = new ByteArrayInputStream(this.currentElement.toString().getBytes(Constants.CHARSET_ENCODING));
                    Base64InputStream base64In = new Base64InputStream(bytesStream);
                    this.x509Data = new X509Data(Tools.createCertificate(base64In));
                    break block12;
                }
                if (localName.equals("X509IssuerSerial") && uri.equals(DS_XMLNS)) {
                    throw new SAXException(DialogHandler.text.getString("unsupported_entry") + ": " + localName);
                }
                if (localName.equals("X509SKI") && uri.equals(DS_XMLNS)) {
                    this.x509Data.setX509SKI(this.currentElement.toString());
                    break block12;
                }
                if (localName.equals("X509SubjectName") && uri.equals(DS_XMLNS)) {
                    this.x509Data.setX509SubjectName(this.currentElement.toString());
                    break block12;
                }
                if (localName.equals("X509CRL") && uri.equals(DS_XMLNS)) {
                    this.x509Data.setX509CRL(this.currentElement.toString());
                    break block12;
                }
                throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
            }
            catch (SAXException ex) {
                throw ex;
            }
            catch (Exception ex) {
                log.error((Object)"Fehler im End-Element X509Data.", (Throwable)ex);
                throw new SAXException(DialogHandler.text.getString("sax_exception"), ex);
            }
        }
        this.currentElement = null;
    }

    public StringBuffer getX509DataBuffer() {
        return this.buffer;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Character: " + new String(ch, start, length)));
        }
        if (this.currentElement == null) {
            for (int i = 0; i < length; ++i) {
                if (ch[start + i] <= ' ') continue;
                throw new SAXException(DialogHandler.text.getString("unexpected_char"));
            }
        } else {
            this.currentElement.append(ch, start, length);
        }
    }
}

