/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.signature;

import de.osci.helper.Base64OutputStream;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class X509Data {
    private X509Certificate x509Cert = null;
    private String x509SKI = null;
    private String x509SubjectName = null;
    private String x509CRL = null;
    private IssuerSerial issuerSerial = null;
    private int dataState = -1;
    private static final int STATE_ISSUER_SERIAL = 0;
    private static final int STATE_SKI = 1;
    private static final int STATE_SUBJECT_NAME = 2;
    private static final int STATE_CERTIFICATE = 3;
    private static final int STATE_CRL = 4;

    public X509Data(X509Certificate cert) {
        this.x509Cert = cert;
    }

    public X509Certificate getX509Certificate() {
        return this.x509Cert;
    }

    public String getX509CRL() {
        return this.x509CRL;
    }

    public String getX509SKI() {
        return this.x509SKI;
    }

    public String getX509SubjectName() {
        return this.x509SubjectName;
    }

    public void setX509SubjectName(String x509SubjectName) throws Exception {
        if (this.dataState > -1) {
            throw new IllegalStateException();
        }
        this.dataState = 2;
        this.x509SubjectName = x509SubjectName;
    }

    public void setX509CRL(String x509CRL) {
        this.x509CRL = x509CRL;
    }

    public void setX509SKI(String x509SKI) throws Exception {
        if (this.dataState > -1) {
            throw new IllegalStateException();
        }
        this.dataState = 1;
        this.x509SKI = x509SKI;
    }

    public void setIssuerName(String issuerName) throws Exception {
        if (this.dataState > -1 && this.dataState != 0) {
            throw new IllegalStateException();
        }
        this.dataState = 0;
        if (this.issuerSerial == null) {
            this.issuerSerial = new IssuerSerial();
        }
        this.issuerSerial.x509IssuerName = issuerName;
    }

    public void setSerialNumber(String serialNumber) throws Exception {
        if (this.dataState > -1 && this.dataState != 0) {
            throw new IllegalStateException();
        }
        this.dataState = 0;
        if (this.issuerSerial == null) {
            this.issuerSerial = new IssuerSerial();
        }
        this.issuerSerial.x509SerialNumber = serialNumber;
    }

    public void writeXML(OutputStream out, String ds) throws IOException {
        out.write(("<" + ds + ":X509Data>").getBytes(Constants.CHARSET_ENCODING));
        if (this.dataState == 3) {
            out.write(("<" + ds + ":X509Certificate>").getBytes(Constants.CHARSET_ENCODING));
            Base64OutputStream myOut = new Base64OutputStream(out, true);
            try {
                myOut.write(this.x509Cert.getEncoded());
            }
            catch (CertificateEncodingException ex) {
                throw new IOException(DialogHandler.text.getString("cert_gen_error") + " - " + ex.getClass() + ": " + ex.getMessage());
            }
            myOut.flush();
            out.write(("</" + ds + ":X509Certificate>").getBytes(Constants.CHARSET_ENCODING));
        } else if (this.dataState == 4) {
            out.write(("<" + ds + ":X509CRL>" + this.x509CRL + "</" + ds + ":X509CRL>").getBytes(Constants.CHARSET_ENCODING));
        } else if (this.dataState == 0) {
            out.write(("<" + ds + ":X509IssuerSerial><" + ds + ":X509IssuerName>" + this.issuerSerial.getX509IssuerName() + "</" + ds + ":X509IssuerName><" + ds + ":X509SerisalNumber>" + this.issuerSerial.getX509SerialNumber() + "</" + ds + ":X509SerisalNumber></" + ds + ":X509IssuerSerial>").getBytes(Constants.CHARSET_ENCODING));
        } else if (this.dataState == 1) {
            out.write(("<" + ds + ":X509SKI>" + this.x509SKI + "</" + ds + ":X509SKI>").getBytes(Constants.CHARSET_ENCODING));
        } else if (this.dataState == 2) {
            out.write(("<" + ds + ":X509SubjectName>" + this.x509SubjectName + "</" + ds + ":X509SubjectName>").getBytes(Constants.CHARSET_ENCODING));
        }
        out.write(("</" + ds + ":X509Data>").getBytes(Constants.CHARSET_ENCODING));
    }

    public class IssuerSerial {
        String x509IssuerName = null;
        String x509SerialNumber = null;

        IssuerSerial() {
        }

        public String getX509IssuerName() {
            return this.x509IssuerName;
        }

        public String getX509SerialNumber() {
            return this.x509SerialNumber;
        }
    }
}

