/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.samples.impl.crypto;

import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.extinterfaces.crypto.Signer;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PKCS12Signer
extends Signer {
    private static Log log = LogFactory.getLog(PKCS12Signer.class);
    private X509Certificate cert;
    private String alias;
    private char[] pin = null;
    private KeyStore keyStore = null;
    private boolean usePSSforRSAkey = false;

    public PKCS12Signer(String p12_fileName, String pin) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        this(PKCS12Signer.class.getResourceAsStream(p12_fileName), pin, false);
    }

    public PKCS12Signer(InputStream in, String pin) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        this(in, pin, false);
    }

    public PKCS12Signer(String p12_fileName, String pin, boolean usePSSforRSAkey) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        this(PKCS12Signer.class.getResourceAsStream(p12_fileName), pin, usePSSforRSAkey);
    }

    public PKCS12Signer(InputStream in, String pin, boolean usePSSforRSAkey) throws KeyStoreException, CertificateException, NoSuchAlgorithmException, IOException {
        this.pin = pin.toCharArray();
        this.keyStore = DialogHandler.getSecurityProvider() == null ? KeyStore.getInstance("PKCS12") : KeyStore.getInstance("PKCS12", DialogHandler.getSecurityProvider());
        this.keyStore.load(in, this.pin);
        String al = null;
        Enumeration<String> e = this.keyStore.aliases();
        while (e.hasMoreElements() && !this.keyStore.isKeyEntry(al = e.nextElement())) {
        }
        if (al == null) {
            throw new NullPointerException("No private key found in keystore.");
        }
        this.alias = al;
        this.cert = (X509Certificate)this.keyStore.getCertificate(this.alias);
        this.usePSSforRSAkey = usePSSforRSAkey;
    }

    @Override
    public String getVendor() {
        return "BOS";
    }

    @Override
    public String getVersion() {
        return "1.5";
    }

    @Override
    public String getAlgorithm() {
        String algo = DialogHandler.getSignatureAlgorithm();
        try {
            String synKeyType = this.keyStore.getKey(this.alias, this.pin).getAlgorithm();
            if (algo.endsWith("sha256") && synKeyType.equals("EC")) {
                algo = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256";
            } else if (algo.endsWith("sha512") && synKeyType.equals("EC")) {
                algo = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512";
            } else if (synKeyType.equals("RSA")) {
                if (this.usePSSforRSAkey) {
                    if (algo.contains("sha256")) {
                        algo = "http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1";
                    } else if (algo.contains("sha512")) {
                        algo = "http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1";
                    }
                } else if (algo.endsWith("sha256")) {
                    algo = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
                } else if (algo.endsWith("sha512")) {
                    algo = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Problem getting private key type, return to default", (Throwable)e);
        }
        return algo;
    }

    @Override
    public X509Certificate getCertificate() {
        return this.cert;
    }

    @Override
    public byte[] sign(byte[] data, String algorithm) throws SignatureException {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Algorithm: " + algorithm));
            }
            Signature sigengine = DialogHandler.getSecurityProvider() == null ? Signature.getInstance(Constants.JCA_JCE_MAP.get(algorithm)) : Signature.getInstance(Constants.JCA_JCE_MAP.get(algorithm), DialogHandler.getSecurityProvider());
            sigengine.initSign((PrivateKey)this.keyStore.getKey(this.alias, this.pin));
            sigengine.update(data);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Fertig mit dem Signieren");
            }
            return sigengine.sign();
        }
        catch (Exception ex) {
            throw new SignatureException(DialogHandler.text.getString("signature_creation_error") + " - " + ex.getClass() + ": " + ex.getLocalizedMessage());
        }
    }
}

