/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.roles;

import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.encryption.Crypto;
import de.osci.osci12.extinterfaces.crypto.Decrypter;
import de.osci.osci12.extinterfaces.crypto.Signer;
import de.osci.osci12.roles.OSCIRoleException;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Role {
    private static Log log = LogFactory.getLog(Role.class);
    private static MessageDigest md;
    protected Signer signer = null;
    protected Decrypter decrypter = null;
    protected X509Certificate signatureCertificate = null;
    protected X509Certificate cipherCertificate = null;
    public String id = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1).toLowerCase().replace('$', '_');
    public String cipherRefId;
    public String signatureRefId;
    private String cipherHash;
    private String signatureHash;
    protected String signatureAlgorithm;

    protected Role() {
    }

    protected Role(Signer signer, Decrypter decrypter) {
        this();
        this.setSigner(signer);
        this.setDecrypter(decrypter);
    }

    protected Role(X509Certificate signatureCertificate, X509Certificate cipherCertificate) {
        this();
        if (signatureCertificate != null) {
            this.setSignatureCertificate(signatureCertificate);
        }
        this.setCipherCertificate(cipherCertificate);
    }

    public String getCipherCertificateId() {
        try {
            if (!this.hasCipherCertificate()) {
                return this.id;
            }
            if (this.cipherRefId != null) {
                return this.cipherRefId;
            }
            if (this.cipherHash == null) {
                this.cipherHash = Role.hashCertificate(this.getCipherCertificate());
            }
            return this.id + "_cipher_" + this.cipherHash;
        }
        catch (Exception ex) {
            return this.id;
        }
    }

    public String getSignatureCertificateId() {
        try {
            if (!this.hasSignatureCertificate()) {
                return this.id;
            }
            if (this.signatureRefId != null) {
                return this.signatureRefId;
            }
            if (this.signatureHash == null) {
                this.signatureHash = Role.hashCertificate(this.getSignatureCertificate());
            }
            return this.id + "_signature_" + this.signatureHash;
        }
        catch (Exception ex) {
            return this.id;
        }
    }

    private static synchronized String hashCertificate(X509Certificate cert) {
        if (cert == null) {
            return "no_hash_available";
        }
        try {
            if (md == null) {
                md = DialogHandler.getSecurityProvider() == null ? MessageDigest.getInstance(Constants.JCA_JCE_MAP.get("http://www.w3.org/2001/04/xmlenc#sha256")) : MessageDigest.getInstance(Constants.JCA_JCE_MAP.get("http://www.w3.org/2001/04/xmlenc#sha256"), DialogHandler.getSecurityProvider());
            }
            md.reset();
            return Crypto.toHex(md.digest(cert.getEncoded()));
        }
        catch (Exception ex) {
            return "no_hash_available";
        }
    }

    public Signer getSigner() throws OSCIRoleException {
        if (this.signer == null) {
            throw new OSCIRoleException("no_signer");
        }
        return this.signer;
    }

    public boolean hasSignaturePrivateKey() {
        return this.signer != null;
    }

    public Decrypter getDecrypter() throws OSCIRoleException {
        if (this.decrypter == null) {
            throw new OSCIRoleException("no_decrypter");
        }
        return this.decrypter;
    }

    public boolean hasCipherPrivateKey() {
        return this.decrypter != null;
    }

    public void setSigner(Signer signer) {
        this.signer = signer;
        this.signatureHash = null;
    }

    public void setDecrypter(Decrypter decrypter) {
        this.decrypter = decrypter;
        this.cipherHash = null;
    }

    public void setSignatureCertificate(X509Certificate signatureCertificate) {
        this.signatureCertificate = signatureCertificate;
        this.signatureHash = Role.hashCertificate(signatureCertificate);
    }

    public X509Certificate getSignatureCertificate() throws OSCIRoleException {
        if (this.signer == null && this.signatureCertificate == null) {
            throw new OSCIRoleException("no_signature_cert", this.id);
        }
        if (this.signer == null) {
            return this.signatureCertificate;
        }
        return this.signer.getCertificate();
    }

    public boolean hasSignatureCertificate() {
        return this.signer != null || this.signatureCertificate != null;
    }

    public void setCipherCertificate(X509Certificate cipherCertificate) {
        this.cipherCertificate = cipherCertificate;
        this.cipherHash = Role.hashCertificate(cipherCertificate);
    }

    public X509Certificate getCipherCertificate() throws OSCIRoleException {
        if (this.decrypter == null && this.cipherCertificate == null) {
            throw new OSCIRoleException("no_cipher_cert", this.id);
        }
        if (this.decrypter == null) {
            return this.cipherCertificate;
        }
        return this.decrypter.getCertificate();
    }

    public boolean hasCipherCertificate() {
        return this.decrypter != null || this.cipherCertificate != null;
    }

    public String getSignatureAlgorithm() {
        if (!this.hasSignaturePrivateKey()) {
            throw new IllegalStateException("Kein Signer-Objekt gesetzt.");
        }
        try {
            this.signatureAlgorithm = this.signer.getAlgorithm();
            if (this.signatureAlgorithm == null) {
                this.signatureAlgorithm = DialogHandler.getSignatureAlgorithm();
            }
        }
        catch (AbstractMethodError ame) {
            log.warn((Object)("No implementaion of Signer.getAlgorithm() found in Role '" + this.id + "', probably old Signer implementaion (< 1.3) in use. Defaulting to " + DialogHandler.getSignatureAlgorithm()));
            this.signatureAlgorithm = DialogHandler.getSignatureAlgorithm();
        }
        return this.signatureAlgorithm;
    }
}

