/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.osci12.OSCIException;
import de.osci.osci12.common.OSCIExceptionCodes;
import de.osci.osci12.messageparts.Attachment;
import de.osci.osci12.messageparts.Content;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messageparts.EncryptedDataOSCI;
import de.osci.osci12.messageparts.FeedbackObject;
import de.osci.osci12.messageparts.MessagePartsFactory;
import de.osci.osci12.messageparts.ProcessCardBundle;
import de.osci.osci12.messagetypes.ContentPackageI;
import de.osci.osci12.messagetypes.OSCIMessage;
import de.osci.osci12.messagetypes.OSCIResponseTo;
import de.osci.osci12.messagetypes.StoredMessageParser;
import de.osci.osci12.roles.Intermed;
import eu.osci.ws._2014._10.transport.MessageMetaData;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;

public class StoredMessage
extends OSCIResponseTo
implements ContentPackageI {
    ProcessCardBundle[] processCardBundles;
    ProcessCardBundle processCardBundleReply;
    String subject;
    URI uriReceiver;
    String selectionRule;
    int selectionMode = -1;
    long quantityLimit = -1L;
    Vector<String[]> insideFeedBack;
    FeedbackObject[] insideFeedbackObjects;

    StoredMessage(int messageType) {
        this.messageType = messageType;
    }

    public static void storeMessage(OSCIMessage msg, OutputStream output) throws IOException, OSCIException, NoSuchAlgorithmException {
        if (msg instanceof StoredMessage) {
            throw new UnsupportedOperationException();
        }
        msg.writeXML(output);
    }

    public static StoredMessage loadMessage(InputStream input) throws IOException, OSCIException, NoSuchAlgorithmException {
        return new StoredMessageParser().parseStream(input);
    }

    public static StoredMessage loadMessageCheckingSignature(InputStream input) throws IOException, OSCIException, NoSuchAlgorithmException {
        StoredMessageParser smp = new StoredMessageParser();
        StoredMessage sm = smp.parseStream(input);
        if (sm.isSigned()) {
            if (sm.getMessageType() <= 16) {
                sm.dialogHandler.supplier.setSignatureCertificate(sm.dialogHandler.client.getSignatureCertificate());
            }
            if (!smp.checkMsgHashes(sm)) {
                throw new OSCIException(OSCIExceptionCodes.OSCIErrorCodes.SignatureInvalid);
            }
        }
        return sm;
    }

    public void exportAttachments(OSCIMessage destinationMessage) {
        Attachment[] atts = this.getAttachments();
        for (int i = 0; i < atts.length; ++i) {
            destinationMessage.addAttachment(atts[i]);
        }
    }

    public void exportAttachment(OSCIMessage destinationMessage, Attachment att) {
        Attachment[] atts = this.getAttachments();
        for (int i = 0; i < atts.length; ++i) {
            if (!att.equals(atts[i])) continue;
            destinationMessage.addAttachment(atts[i]);
            return;
        }
    }

    public ProcessCardBundle getProcessCardBundle() {
        if (this.processCardBundles == null) {
            return null;
        }
        return this.processCardBundles[0];
    }

    public ProcessCardBundle[] getProcessCardBundles() {
        if (this.messageType != 64) {
            throw new UnsupportedOperationException();
        }
        return this.processCardBundles;
    }

    public ProcessCardBundle getProcessCardBundleReply() {
        if (this.messageType != 128) {
            throw new UnsupportedOperationException();
        }
        return this.processCardBundleReply;
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public Intermed getIntermediary() {
        if (this.dialogHandler.getSupplier() instanceof Intermed) {
            return (Intermed)this.dialogHandler.getSupplier();
        }
        return (Intermed)this.dialogHandler.getClient();
    }

    @Override
    public ContentContainer[] getContentContainer() {
        return super.getContentContainer();
    }

    @Override
    public EncryptedDataOSCI[] getEncryptedData() {
        return super.getEncryptedData();
    }

    @Override
    public MessageMetaData getMessageMetaDataXTA2V3() {
        return super.getMessageMetaDataXTA2V3();
    }

    @Override
    public ContentContainer getContentContainerByRefID(String refID) {
        return super.getContentContainerByRefID(refID);
    }

    @Override
    public Content getContentByRefID(String refID) {
        return super.getContentByRefID(refID);
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    public URI getUriReceiver() {
        return this.uriReceiver;
    }

    public boolean getQualityOfTimeStampCreation() {
        if (this.messageType != 10 && this.messageType != 5 && this.messageType != 8 && this.messageType != 144 && this.messageType != 11) {
            throw new UnsupportedOperationException();
        }
        return this.qualityOfTimestampTypeCreation.isQualityCryptographic();
    }

    public boolean getQualityOfTimeStampReception() {
        if (this.messageType != 10 && this.messageType != 5 && this.messageType != 8 && this.messageType != 144 && this.messageType != 11) {
            throw new UnsupportedOperationException();
        }
        return this.qualityOfTimestampTypeReception.isQualityCryptographic();
    }

    public int getSelectionMode() {
        if (this.messageType != 3 && this.messageType != 4 && this.messageType != 48 && this.messageType != 64) {
            throw new UnsupportedOperationException();
        }
        return this.selectionMode;
    }

    public String getSelectionRule() {
        if (this.messageType != 3 && this.messageType != 4 && this.messageType != 48 && this.messageType != 64) {
            throw new UnsupportedOperationException();
        }
        return this.selectionRule;
    }

    public long getQuantityLimit() {
        if (this.messageType != 4 && this.messageType != 64) {
            throw new UnsupportedOperationException();
        }
        return this.quantityLimit;
    }

    public String[][] getInsideFeedback() {
        if (this.insideFeedBack == null) {
            return null;
        }
        return (String[][])this.insideFeedBack.toArray((T[])new String[this.insideFeedBack.size()][3]);
    }

    public FeedbackObject[] getInsideFeedbackObjects() {
        if (this.insideFeedBack == null) {
            return null;
        }
        if (this.insideFeedbackObjects == null) {
            this.insideFeedbackObjects = new FeedbackObject[this.insideFeedBack.size()];
            for (int i = 0; i < this.insideFeedBack.size(); ++i) {
                this.insideFeedbackObjects[i] = MessagePartsFactory.createFeedbackObject(this.insideFeedBack.get(i));
            }
        }
        return this.insideFeedbackObjects;
    }
}

