/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messagetypes.OSCIEnvelopeBuilder;
import de.osci.osci12.messagetypes.SOAPFaultBuilder;
import de.osci.osci12.messagetypes.StoredMessageBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class StoredEnvelopeBuilder
extends OSCIEnvelopeBuilder {
    private static Log log = LogFactory.getLog(StoredEnvelopeBuilder.class);

    public StoredEnvelopeBuilder(XMLReader xmlReader) {
        super(xmlReader, null);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start-Element: " + localName));
        }
        if (this.soapNSPrefix == null || !localName.equals("Envelope")) {
            throw new SAXException(DialogHandler.text.getString("msg_format_error") + ": " + localName);
        }
        String schemaLocation = attributes.getValue("xsi:schemaLocation");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Nachrichtentyp: " + schemaLocation));
        }
        if (schemaLocation == null) {
            this.childBuilder = new SOAPFaultBuilder(this);
            this.xmlReader.setContentHandler(this.childBuilder);
        } else {
            int msgType;
            if (schemaLocation.equals("http://schemas.xmlsoap.org/soap/envelope/ soapMessageEncrypted.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd")) {
                throw new SAXException(new IllegalArgumentException(DialogHandler.text.getString("encrypted_message")));
            }
            if (schemaLocation.equals("http://schemas.xmlsoap.org/soap/envelope/ soapStoreDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd")) {
                msgType = 10;
            } else if (schemaLocation.equals("http://schemas.xmlsoap.org/soap/envelope/ soapResponseToStoreDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd")) {
                msgType = 160;
            } else if (schemaLocation.equals("http://schemas.xmlsoap.org/soap/envelope/ soapFetchDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd")) {
                msgType = 3;
            } else if (schemaLocation.equals("http://schemas.xmlsoap.org/soap/envelope/ soapResponseToFetchDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd")) {
                msgType = 48;
            } else if (schemaLocation.equals("http://schemas.xmlsoap.org/soap/envelope/ soapForwardDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd")) {
                msgType = 5;
            } else if (schemaLocation.equals("http://schemas.xmlsoap.org/soap/envelope/ soapAcceptDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd")) {
                msgType = 1;
            } else if (schemaLocation.equals("http://schemas.xmlsoap.org/soap/envelope/ soapResponseToAcceptDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd")) {
                msgType = 16;
            } else if (schemaLocation.equals("http://schemas.xmlsoap.org/soap/envelope/ soapResponseToForwardDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd")) {
                msgType = 80;
            } else if (schemaLocation.equals("http://schemas.xmlsoap.org/soap/envelope/ soapMediateDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd")) {
                msgType = 8;
            } else if (schemaLocation.equals("http://schemas.xmlsoap.org/soap/envelope/ soapProcessDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd")) {
                msgType = 9;
            } else if (schemaLocation.equals("http://schemas.xmlsoap.org/soap/envelope/ soapResponseToProcessDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd")) {
                msgType = 144;
            } else if (schemaLocation.equals("http://schemas.xmlsoap.org/soap/envelope/ soapResponseToMediateDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd")) {
                msgType = 128;
            } else if (schemaLocation.equals("http://schemas.xmlsoap.org/soap/envelope/ soapFetchProcessCard.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd")) {
                msgType = 4;
            } else if (schemaLocation.equals("http://schemas.xmlsoap.org/soap/envelope/ soapResponseToFetchProcessCard.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd")) {
                msgType = 64;
            } else if (schemaLocation.equals("http://schemas.xmlsoap.org/soap/envelope/ soapPartialStoreDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd")) {
                msgType = 11;
            } else if (schemaLocation.equals("http://schemas.xmlsoap.org/soap/envelope/ soapPartialFetchDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd")) {
                msgType = 50;
            } else if (schemaLocation.equals("http://schemas.xmlsoap.org/soap/envelope/ soapResponseToPartialStoreDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd")) {
                msgType = 161;
            } else if (schemaLocation.equals("http://schemas.xmlsoap.org/soap/envelope/ soapResponseToPartialFetchDelivery.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd")) {
                msgType = 49;
            } else {
                log.error((Object)("Nicht erlaubter Nachrichtentyp ! Nachrichtentypt ist:\n" + schemaLocation + "\nhttp://schemas.xmlsoap.org/soap/envelope/ soapResponseToFetchProcessCard.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd"));
                throw new SAXException(DialogHandler.text.getString("sax_exception_msgtype"));
            }
            this.childBuilder = new StoredMessageBuilder(this, msgType);
            this.xmlReader.setContentHandler(this.childBuilder);
        }
        this.childBuilder.getOSCIMessage().soapNSPrefix = this.soapNSPrefix;
        this.childBuilder.getOSCIMessage().osciNSPrefix = this.osciNSPrefix;
        this.childBuilder.getOSCIMessage().osci2017NSPrefix = this.osci2017NSPrefix;
        this.childBuilder.getOSCIMessage().osci2019NSPrefix = this.osci2019NSPrefix;
        this.childBuilder.getOSCIMessage().dsNSPrefix = this.dsNSPrefix;
        this.childBuilder.getOSCIMessage().xencNSPrefix = this.xencNSPrefix;
        this.childBuilder.getOSCIMessage().ns = this.ns.toString();
    }
}

