/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.Base64;
import de.osci.helper.Tools;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.Body;
import de.osci.osci12.messageparts.Content;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messageparts.EncryptedDataOSCI;
import de.osci.osci12.messagetypes.ContentPackageI;
import de.osci.osci12.messagetypes.OSCIRequest;
import de.osci.osci12.messagetypes.ResponseToStoreDelivery;
import de.osci.osci12.roles.Addressee;
import de.osci.osci12.roles.OSCIRoleException;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.soapheader.OsciH;
import de.osci.osci12.soapheader.QualityOfTimestampH;
import eu.osci.ws._2014._10.transport.MessageMetaData;
import java.io.IOException;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StoreDelivery
extends OSCIRequest
implements ContentPackageI {
    protected static Log log = LogFactory.getLog(StoreDelivery.class);
    private String subject;

    StoreDelivery() {
        this.messageType = 10;
    }

    public StoreDelivery(DialogHandler dh, Addressee addressee, String messageId) throws OSCIRoleException, NoSuchAlgorithmException {
        super(dh);
        this.messageType = 10;
        this.originator = (Originator)dh.getClient();
        this.addressee = addressee;
        addressee.getCipherCertificate();
        this.messageId = messageId;
        if (!this.dialogHandler.isExplicitDialog()) {
            this.dialogHandler.resetControlBlock();
        }
        this.dialogHandler.getControlblock().setResponse(this.dialogHandler.getControlblock().getChallenge());
        this.dialogHandler.getControlblock().setChallenge(Tools.createRandom(10));
        this.dialogHandler.getControlblock().setSequenceNumber(this.dialogHandler.getControlblock().getSequenceNumber() + 1);
        this.setQualityOfTimeStampCreation(false);
        this.setQualityOfTimeStampReception(false);
    }

    public void setQualityOfTimeStampCreation(boolean cryptographic) {
        this.qualityOfTimestampTypeCreation = new QualityOfTimestampH(false, cryptographic);
    }

    public boolean getQualityOfTimeStampCreation() {
        return this.qualityOfTimestampTypeCreation.isQualityCryptographic();
    }

    public void setQualityOfTimeStampReception(boolean cryptographic) {
        this.qualityOfTimestampTypeReception = new QualityOfTimestampH(true, cryptographic);
    }

    public boolean getQualityOfTimeStampReception() {
        return this.qualityOfTimestampTypeReception.isQualityCryptographic();
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public void addContentContainer(ContentContainer container) throws OSCIRoleException {
        super.addContentContainer(container);
    }

    @Override
    public void removeContentContainer(ContentContainer container) {
        super.removeContentContainer(container);
    }

    @Override
    public ContentContainer getContentContainerByRefID(String refID) {
        return super.getContentContainerByRefID(refID);
    }

    @Override
    public Content getContentByRefID(String refID) {
        return super.getContentByRefID(refID);
    }

    @Override
    public ContentContainer[] getContentContainer() {
        return super.getContentContainer();
    }

    @Override
    public void addEncryptedData(EncryptedDataOSCI encData) throws OSCIRoleException {
        super.addEncryptedData(encData);
    }

    @Override
    public void removeEncryptedData(EncryptedDataOSCI encData) {
        super.removeEncryptedData(encData);
    }

    @Override
    public EncryptedDataOSCI[] getEncryptedData() {
        return super.getEncryptedData();
    }

    @Override
    public void addMessageMetaDataXTA2V3(MessageMetaData mmd) {
        super.addMessageMetaDataXTA2V3(mmd);
    }

    @Override
    public void addMessageMetaDataXTA2V3(String mmd) {
        super.addMessageMetaDataXTA2V3(mmd);
    }

    @Override
    public MessageMetaData getMessageMetaDataXTA2V3() {
        return super.getMessageMetaDataXTA2V3();
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }

    public ResponseToStoreDelivery send() throws IOException, OSCIException, NoSuchAlgorithmException {
        return (ResponseToStoreDelivery)this.transmit(null, null);
    }

    public ResponseToStoreDelivery send(OutputStream storeOutput, OutputStream storeInput) throws IOException, OSCIException, NoSuchAlgorithmException {
        return (ResponseToStoreDelivery)this.transmit(storeOutput, storeInput);
    }

    public void writeMessage(OutputStream out) throws NoSuchAlgorithmException, IOException, OSCIException {
        this.writeXML(out);
    }

    @Override
    void sign() throws IOException, OSCIException, NoSuchAlgorithmException {
        super.sign();
        this.messageParts.set(3, null);
        this.messageParts.set(7, this.nonIntermediaryCertificatesH);
    }

    @Override
    protected void compose() throws OSCIException, IOException, NoSuchAlgorithmException {
        super.compose();
        this.messageParts.set(3, null);
        this.messageParts.add(this.qualityOfTimestampTypeCreation);
        this.messageParts.add(this.qualityOfTimestampTypeReception);
        if (this.messageId == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Message-Id");
        }
        if (this.dialogHandler.getControlblock().getChallenge() == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Challenge");
        }
        if (this.dialogHandler.getControlblock().getSequenceNumber() == -1) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": SequenceNumber");
        }
        this.importAllCertificates();
        String head = "<" + this.osciNSPrefix + ":MessageId>" + Base64.encode(this.messageId.getBytes(Constants.CHARSET_ENCODING)) + "</" + this.osciNSPrefix + ":MessageId>";
        if (this.subject != null) {
            head = head + "<" + this.osciNSPrefix + ":Subject>" + this.subject + "</" + this.osciNSPrefix + ":Subject>";
        }
        this.osciH = new OsciH(Constants.HeaderTags.storeDelivery.getElementName(), head);
        this.messageParts.add(this.osciH);
        this.createNonIntermediaryCertificatesH();
        this.nonIntermediaryCertificatesH.getCipherCertificateAddressee();
        this.messageParts.add(this.nonIntermediaryCertificatesH);
        if (this.featureDescription != null && this.dialogHandler.isSendFeatureDescription()) {
            this.messageParts.add(this.featureDescription);
        }
        this.messageParts.addAll(this.customHeaders);
        this.body = new Body(this.getContentContainer(), this.getEncryptedData());
        this.messageParts.add(this.body);
        this.stateOfMsg |= 1;
    }
}

