/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.Base64;
import de.osci.helper.Base64OutputStream;
import de.osci.helper.StoreOutputStream;
import de.osci.helper.SymCipherOutputStream;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.encryption.Crypto;
import de.osci.osci12.encryption.EncryptedData;
import de.osci.osci12.messagetypes.OSCIMessage;
import de.osci.osci12.messagetypes.OSCIRequest;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class SOAPMessageEncrypted
extends OSCIMessage {
    private static Log log = LogFactory.getLog(SOAPMessageEncrypted.class);
    public EncryptedData encData;
    private OSCIMessage msg;
    private String symmetricCipherAlgorithm = null;
    private int ivLength = 12;
    private SecretKey symKey;
    private byte[] encSymKey;
    private OutputStream storeStream;
    private static byte[] xml_0 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n\r\n<soap:Envelope xmlns:ds=\"http://www.w3.org/2000/09/xmldsig#\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xenc=\"http://www.w3.org/2001/04/xmlenc#\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://schemas.xmlsoap.org/soap/envelope/ soapMessageEncrypted.xsd http://www.w3.org/2000/09/xmldsig# oscisig.xsd http://www.w3.org/2001/04/xmlenc# oscienc.xsd\"><soap:Body><xenc:EncryptedData MimeType=\"Multipart/Related\"><xenc:EncryptionMethod Algorithm=\"".getBytes(Constants.CHARSET_ENCODING);
    private static byte[] xml_1a1 = "\">".getBytes(Constants.CHARSET_ENCODING);
    private static byte[] xml_1a2 = "</xenc:EncryptionMethod><ds:KeyInfo><xenc:EncryptedKey><xenc:EncryptionMethod Algorithm=\"".getBytes(Constants.CHARSET_ENCODING);
    private static byte[] xml_1b = "</xenc:EncryptionMethod><ds:KeyInfo><ds:X509Data><ds:X509Certificate>".getBytes(Constants.CHARSET_ENCODING);
    private static byte[] xml_2 = "</ds:X509Certificate></ds:X509Data></ds:KeyInfo><xenc:CipherData><xenc:CipherValue>".getBytes(Constants.CHARSET_ENCODING);
    private static byte[] xml_3 = "</xenc:CipherValue></xenc:CipherData></xenc:EncryptedKey></ds:KeyInfo><xenc:CipherData><xenc:CipherReference URI=\"cid:osci_enc\"><xenc:Transforms><ds:Transform Algorithm=\"http://www.w3.org/2000/09/xmldsig#base64\"></ds:Transform></xenc:Transforms></xenc:CipherReference></xenc:CipherData></xenc:EncryptedData></soap:Body></soap:Envelope>".getBytes(Constants.CHARSET_ENCODING);
    private byte[] ivLengthElement;
    private byte[] algo;
    private byte[] asymAlgo;
    private int length;
    private X509Certificate cipherCert;

    public SOAPMessageEncrypted(OSCIMessage msg, OutputStream storeStream) throws NoSuchAlgorithmException {
        this.messageType = 256;
        this.msg = msg;
        if (this.msg != null) {
            this.symmetricCipherAlgorithm = msg.dialogHandler.getSymmetricCipherAlgorithm();
            this.ivLength = msg.dialogHandler.getIvLength();
            this.symKey = Crypto.createSymKey(this.symmetricCipherAlgorithm);
        }
        this.storeStream = storeStream;
    }

    public SOAPMessageEncrypted(OSCIMessage msg, OutputStream storeStream, String symmetricCipherAlgorithm) throws NoSuchAlgorithmException {
        this(msg, storeStream, symmetricCipherAlgorithm, 12);
    }

    public SOAPMessageEncrypted(OSCIMessage msg, OutputStream storeStream, String symmetricCipherAlgorithm, int ivLength) throws NoSuchAlgorithmException {
        this.messageType = 256;
        this.msg = msg;
        this.symmetricCipherAlgorithm = symmetricCipherAlgorithm;
        this.ivLength = ivLength;
        if (this.msg != null) {
            this.symKey = Crypto.createSymKey(symmetricCipherAlgorithm);
        }
        this.storeStream = storeStream;
    }

    @Override
    protected long calcLength() throws IOException, OSCIException, NoSuchAlgorithmException {
        if ((this.stateOfMsg & 1) == 0) {
            this.compose();
        }
        long len = 288L;
        len += (long)this.length;
        len += (long)Integer.toString(this.length).getBytes(Constants.CHARSET_ENCODING).length;
        len += (long)(4 * this.msg.boundaryString.getBytes(Constants.CHARSET_ENCODING).length);
        len += (long)"osci@message".getBytes(Constants.CHARSET_ENCODING).length;
        try {
            len += Base64.calcB64Length(this.cipherCert.getEncoded().length);
        }
        catch (CertificateEncodingException ex) {
            throw new IOException(DialogHandler.text.getString("cert_gen_error") + ": " + ex.getClass() + ": " + ex.getMessage());
        }
        if (this.msg.base64) {
            len += 6L;
            len += Base64.calcB64Length(Crypto.calcSymEncLength(this.msg.calcLength(), this.symmetricCipherAlgorithm, this.ivLength));
        } else {
            len += 21L;
            len += Crypto.calcSymEncLength(this.msg.calcLength(), this.symmetricCipherAlgorithm, this.ivLength);
        }
        log.debug((Object)("Laenge der Nachricht: " + len));
        return len;
    }

    @Override
    protected void compose() throws OSCIException, NoSuchAlgorithmException, IOException {
        if ((this.msg.stateOfMsg & 1) == 0) {
            this.msg.compose();
        }
        this.cipherCert = this.msg instanceof OSCIRequest ? this.msg.getDialogHandler().getSupplier().getCipherCertificate() : this.msg.getDialogHandler().getClient().getCipherCertificate();
        this.encSymKey = Base64.encode(Crypto.doRSAEncryption(this.cipherCert, this.symKey, this.msg.getDialogHandler().getAsymmetricCipherAlgorithm())).getBytes(Constants.CHARSET_ENCODING);
        this.algo = this.symmetricCipherAlgorithm.getBytes(Constants.CHARSET_ENCODING);
        this.asymAlgo = this.constructEncryptionAlgo();
        this.length = xml_0.length + this.algo.length + xml_1a1.length + xml_1a2.length + this.asymAlgo.length + xml_1b.length + xml_2.length + this.encSymKey.length + xml_3.length;
        if (this.ivLength != 16) {
            this.ivLengthElement = ("<" + Constants.Namespaces.OSCI128.getPrefix() + ":IvLength xmlns:" + Constants.Namespaces.OSCI128.getPrefix() + "=\"" + Constants.Namespaces.OSCI128.getUri() + "\" Value=\"" + this.ivLength + "\"></" + Constants.Namespaces.OSCI128.getPrefix() + ":IvLength>").getBytes(Constants.CHARSET_ENCODING);
            this.length += this.ivLengthElement.length;
        }
        this.stateOfMsg |= 1;
    }

    private byte[] constructEncryptionAlgo() throws UnsupportedEncodingException {
        Object ret;
        if ("http://www.w3.org/2009/xmlenc11#rsa-oaep".equals(this.msg.getDialogHandler().getAsymmetricCipherAlgorithm())) {
            if ("http://www.w3.org/2001/04/xmlenc#sha512".equals(DialogHandler.getDigestAlgorithm()) || "http://www.w3.org/2007/05/xmldsig-more#sha3-384".equals(DialogHandler.getDigestAlgorithm()) || "http://www.w3.org/2007/05/xmldsig-more#sha3-512".equals(DialogHandler.getDigestAlgorithm())) {
                ret = "http://www.w3.org/2009/xmlenc11#rsa-oaep\"><xenc11:MGF xmlns:xenc11=\"http://www.w3.org/2009/xmlenc11#\" Algorithm=\"http://www.w3.org/2009/xmlenc11#mgf1sha512\"></xenc11:MGF>";
                ret = (String)ret + "<ds:DigestMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#sha512\"></ds:DigestMethod>";
            } else if ("http://www.w3.org/2001/04/xmlenc#sha256".equals(DialogHandler.getDigestAlgorithm()) || "http://www.w3.org/2007/05/xmldsig-more#sha3-256".equals(DialogHandler.getDigestAlgorithm())) {
                ret = "http://www.w3.org/2009/xmlenc11#rsa-oaep\"><xenc11:MGF xmlns:xenc11=\"http://www.w3.org/2009/xmlenc11#\" Algorithm=\"http://www.w3.org/2009/xmlenc11#mgf1sha256\"></xenc11:MGF>";
                ret = (String)ret + "<ds:DigestMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#sha256\"></ds:DigestMethod>";
            } else {
                ret = "http://www.w3.org/2009/xmlenc11#rsa-oaep\"><xenc11:MGF xmlns:xenc11=\"http://www.w3.org/2009/xmlenc11#\" Algorithm=\"http://www.w3.org/2009/xmlenc11#mgf1sha256\"></xenc11:MGF>";
                ret = (String)ret + "<ds:DigestMethod Algorithm=\"http://www.w3.org/2001/04/xmlenc#sha256\"></ds:DigestMethod>";
            }
        } else {
            ret = "http://www.w3.org/2001/04/xmlenc#rsa-1_5\">";
        }
        return ((String)ret).getBytes(Constants.CHAR_ENCODING);
    }

    @Override
    protected void writeXML(OutputStream out) throws IOException, OSCIException, NoSuchAlgorithmException {
        SymCipherOutputStream tdesOut;
        if ((this.stateOfMsg & 1) == 0) {
            this.compose();
        }
        out.write(("MIME-Version: 1.0\r\nContent-Type: Multipart/Related; boundary=" + this.msg.boundaryString + "; type=text/xml\r\n").getBytes(Constants.CHARSET_ENCODING));
        out.write(("\r\n--" + this.msg.boundaryString + "\r\nContent-Type: text/xml; charset=UTF-8\r\n").getBytes(Constants.CHARSET_ENCODING));
        out.write("Content-Transfer-Encoding: 8bit\r\nContent-ID: <osci@message>\r\n".getBytes(Constants.CHARSET_ENCODING));
        out.write(("Content-Length: " + this.length + "\r\n\r\n").getBytes(Constants.CHARSET_ENCODING));
        out.write(xml_0);
        out.write(this.algo);
        out.write(xml_1a1);
        if (this.ivLengthElement != null) {
            out.write(this.ivLengthElement);
        }
        out.write(xml_1a2);
        out.write(this.asymAlgo);
        out.write(xml_1b);
        try {
            out.write(Base64.encode(this.cipherCert.getEncoded()).getBytes(Constants.CHARSET_ENCODING));
        }
        catch (CertificateEncodingException ex) {
            throw new IOException(DialogHandler.text.getString("cert_gen_error") + ": " + ex.getClass() + ": " + ex.getMessage());
        }
        out.write(xml_2);
        out.write(this.encSymKey);
        out.write(xml_3);
        out.write(("\r\n\r\n--" + this.msg.boundaryString + "\r\nContent-Type: ").getBytes(Constants.CHARSET_ENCODING));
        out.write((this.msg.base64 ? "text/base64" : "application/octet-stream").getBytes(Constants.CHARSET_ENCODING));
        out.write("\r\nContent-Transfer-Encoding: ".getBytes(Constants.CHARSET_ENCODING));
        out.write((this.msg.base64 ? "7bit" : "binary").getBytes(Constants.CHARSET_ENCODING));
        out.write("\r\nContent-ID: <osci_enc>\r\n\r\n".getBytes(Constants.CHARSET_ENCODING));
        Base64OutputStream b64out = null;
        if (this.msg.base64) {
            b64out = new Base64OutputStream(out, false);
            tdesOut = new SymCipherOutputStream((OutputStream)b64out, this.symKey, this.symmetricCipherAlgorithm, this.ivLength, true);
        } else {
            tdesOut = new SymCipherOutputStream(out, this.symKey, this.symmetricCipherAlgorithm, this.ivLength, true);
        }
        if (this.storeStream == null) {
            this.msg.writeXML(tdesOut);
            tdesOut.close();
        } else {
            StoreOutputStream sos = new StoreOutputStream(tdesOut, this.storeStream);
            this.msg.writeXML(sos);
            sos.close();
        }
        if (this.msg.base64) {
            b64out.flush(true);
        }
        out.write(("\r\n--" + this.msg.boundaryString + "--\r\n").getBytes(Constants.CHARSET_ENCODING));
    }
}

