/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.common.OSCIExceptionCodes;
import de.osci.osci12.common.SoapClientException;
import de.osci.osci12.common.SoapServerException;
import de.osci.osci12.messagetypes.OSCIEnvelopeBuilder;
import de.osci.osci12.messagetypes.OSCIMessageBuilder;
import de.osci.osci12.messagetypes.SOAPFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class SOAPFaultBuilder
extends OSCIMessageBuilder {
    private static Log log = LogFactory.getLog(SOAPFaultBuilder.class);
    private String faultcode;
    private String faultstring;
    private String oscicode;

    public SOAPFaultBuilder(OSCIEnvelopeBuilder parentHandler) {
        super(parentHandler);
        this.msg = new SOAPFault("");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start Element SOAPFaultBuilder: " + localName + uri));
        }
        if (localName.equals("Body")) {
            this.insideBody = true;
        } else if (this.insideBody) {
            if (localName.equals("faultcode") || localName.equals("faultstring") || localName.equals("Code") && uri.equals(OSCI_XMLNS)) {
                this.currentElement = new StringBuffer();
            }
        } else if (!localName.equals("detail")) {
            throw new SAXException(DialogHandler.text.getString(Constants.LanguageTextEntries.unexpected_entry.name()) + ": " + localName);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("End-Element: " + localName));
        }
        if (localName.equals("faultcode")) {
            this.faultcode = this.currentElement.toString();
        } else if (localName.equals("faultstring")) {
            this.faultstring = this.currentElement.toString();
        } else if (localName.equals("Code") && uri.equals(OSCI_XMLNS)) {
            this.oscicode = this.currentElement.toString();
        } else if (localName.equals("Envelope") && uri.equals(SOAP_XMLNS)) {
            log.debug((Object)("SOAP-Error " + this.oscicode + "-" + this.faultstring));
            OSCIExceptionCodes.OSCIErrorCodes errorCode = null;
            errorCode = OSCIExceptionCodes.OSCIErrorCodes.fromErrorCode(this.oscicode);
            if (errorCode == null) {
                log.error((Object)("Could not find error Code: " + this.oscicode));
                errorCode = OSCIExceptionCodes.OSCIErrorCodes.InternalErrorSupplier;
                this.faultstring = this.faultstring.concat("Error code not found in Enumeration. Code: " + this.oscicode);
            }
            if (this.faultcode.equals(this.getOSCIMessage().soapNSPrefix + ":Server")) {
                throw new SAXException(new SoapServerException(errorCode, this.faultstring));
            }
            throw new SAXException(new SoapClientException(errorCode, this.faultstring));
        }
        this.currentElement = null;
    }
}

