/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.common.OSCIExceptionCodes;
import de.osci.osci12.messagetypes.OSCIResponseTo;
import java.io.IOException;
import java.io.OutputStream;

public class SOAPFault
extends OSCIResponseTo {
    private static final String soapFaultIntro = "<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:osci=\"http://www.osci.de/2002/04/osci\"><soap:Body><soap:Fault><faultcode>soap:";
    private static final String soapFaultExtro = "</osci:Code></detail></soap:Fault></soap:Body></soap:Envelope>";
    private String oscicode;
    private String soapfault;

    public SOAPFault(String oscicode) {
        this.oscicode = oscicode;
        this.messageType = 32;
    }

    @Override
    protected void compose() {
        this.soapfault = soapFaultIntro;
        this.soapfault = this.oscicode.equals(OSCIExceptionCodes.OSCIErrorCodes.SoapServerInternalErrorSupplier.getOSCICode()) || this.oscicode.equals(OSCIExceptionCodes.OSCIErrorCodes.SoapServerInternalErrorSupplierOnEncCertClient.getOSCICode()) ? this.soapfault + "Server" : this.soapfault + "Client";
        this.soapfault = this.soapfault + "</faultcode><faultstring>" + DialogHandler.text.getString(this.oscicode) + "</faultstring><detail><osci:Code>" + this.oscicode + soapFaultExtro;
        this.stateOfMsg |= 1;
    }

    @Override
    protected void writeXML(OutputStream out) throws IOException {
        this.compose();
        out.write(("\r\nMIME-Version: 1.0\r\nContent-Type: Multipart/Related; boundary=" + DialogHandler.boundary + "; type=text/xml\r\n").getBytes(Constants.CHARSET_ENCODING));
        out.write(("\r\n--" + DialogHandler.boundary + "\r\nContent-Type: text/xml; charset=UTF-8\r\n").getBytes(Constants.CHARSET_ENCODING));
        out.write("Content-Transfer-Encoding: 8bit\r\nContent-ID: <osci@message>\r\n\r\n".getBytes(Constants.CHARSET_ENCODING));
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n\r\n".getBytes(Constants.CHARSET_ENCODING));
        out.write(this.soapfault.getBytes(Constants.CHARSET_ENCODING));
        out.write(("\r\n--" + DialogHandler.boundary + "--\r\n").getBytes(Constants.CHARSET_ENCODING));
    }

    public void writeToStream(OutputStream out) throws IOException {
        this.writeXML(out);
    }
}

