/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.Tools;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.Body;
import de.osci.osci12.messageparts.ChunkInformation;
import de.osci.osci12.messageparts.FeedbackObject;
import de.osci.osci12.messageparts.Inspection;
import de.osci.osci12.messageparts.MessagePartsFactory;
import de.osci.osci12.messageparts.ProcessCardBundle;
import de.osci.osci12.messageparts.Timestamp;
import de.osci.osci12.messagetypes.OSCIResponseTo;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.soapheader.OsciH;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;

public class ResponseToPartialStoreDelivery
extends OSCIResponseTo {
    ProcessCardBundle processCardBundle;
    Vector<String[]> insideFeedBack;
    FeedbackObject[] insideFeedbackObjects;
    ChunkInformation chunkInformation = MessagePartsFactory.creatChunkInformation(ChunkInformation.CheckInstance.ResponsePartialStoreDelivery);

    ResponseToPartialStoreDelivery(DialogHandler dh) throws NoSuchAlgorithmException {
        this(dh, null, false);
    }

    ResponseToPartialStoreDelivery(DialogHandler dh, boolean parser) throws NoSuchAlgorithmException {
        this(dh, null, parser);
    }

    ResponseToPartialStoreDelivery(DialogHandler dh, ProcessCardBundle processCardBundle, boolean parser) throws NoSuchAlgorithmException {
        super(dh);
        this.messageType = 161;
        this.originator = (Originator)dh.getClient();
        this.processCardBundle = processCardBundle;
        if (!parser) {
            this.dialogHandler.getControlblock().setResponse(this.dialogHandler.prevChallenge);
            this.dialogHandler.getControlblock().setChallenge(Tools.createRandom(10));
        }
        this.body = new Body("");
        this.body.setNSPrefixes(this);
    }

    public ProcessCardBundle getProcessCardBundle() {
        return this.processCardBundle;
    }

    public Timestamp getTimestampCreation() {
        return this.processCardBundle.getCreation();
    }

    public Inspection[] getInspections() {
        return this.processCardBundle.getInspections();
    }

    public String getSubject() {
        return this.processCardBundle.getSubject();
    }

    public ChunkInformation getChunkInformation() {
        return this.chunkInformation;
    }

    public void setChunkInformation(ChunkInformation chunkInformation) {
        this.chunkInformation = chunkInformation;
    }

    void setInsideFeedback(String[] code) {
        this.insideFeedBack = new Vector();
        for (int i = 0; i < code.length; ++i) {
            String[] fb = new String[]{this.dialogHandler.getLanguageList(), code[i], DialogHandler.text.getString(code[i])};
            this.insideFeedBack.add(fb);
        }
    }

    public String[][] getInsideFeedback() {
        if (this.insideFeedBack == null) {
            return null;
        }
        return (String[][])this.insideFeedBack.toArray((T[])new String[this.insideFeedBack.size()][3]);
    }

    public FeedbackObject[] getInsideFeedbackObjects() {
        if (this.insideFeedBack == null) {
            return null;
        }
        if (this.insideFeedbackObjects == null) {
            this.insideFeedbackObjects = new FeedbackObject[this.insideFeedBack.size()];
            for (int i = 0; i < this.insideFeedBack.size(); ++i) {
                this.insideFeedbackObjects[i] = MessagePartsFactory.createFeedbackObject(this.insideFeedBack.get(i));
            }
        }
        return this.insideFeedbackObjects;
    }

    public String getRecentModification() {
        return this.processCardBundle.getRecentModification();
    }

    public String getMessageId() {
        return this.processCardBundle.getMessageId();
    }

    @Override
    void sign() throws IOException, OSCIException, NoSuchAlgorithmException {
        super.sign();
        this.messageParts.set(4, this.intermediaryCertificatesH);
        this.messageParts.set(2, null);
    }

    @Override
    protected void compose() throws IOException, OSCIException, NoSuchAlgorithmException {
        super.compose();
        this.messageParts.set(2, null);
        if (this.dialogHandler.getControlblock().getResponse() == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Response");
        }
        if (this.dialogHandler.getControlblock().getConversationID() == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Conversation-Id");
        }
        if (this.dialogHandler.getControlblock().getSequenceNumber() == -1) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": SequenceNumber");
        }
        if (this.feedBack == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Feedback");
        }
        ByteArrayOutputStream chunkInformationXml = new ByteArrayOutputStream();
        MessagePartsFactory.writeXML(this.chunkInformation, chunkInformationXml);
        String msgElement = "";
        if (this.insideFeedBack != null && !this.insideFeedBack.isEmpty()) {
            msgElement = msgElement.concat(this.writeInsideFeedBack());
        }
        this.osciH = this.processCardBundle == null ? new OsciH(Constants.HeaderTags.responseToPartialStoreDelivery.getElementName(), msgElement + this.writeFeedBack() + chunkInformationXml.toString(), this.osci2017NSPrefix) : new OsciH(Constants.HeaderTags.responseToPartialStoreDelivery.getElementName(), msgElement + this.writeFeedBack() + this.processCardBundle.writeToString() + chunkInformationXml.toString(), this.osci2017NSPrefix);
        this.messageParts.add(this.osciH);
        this.messageParts.add(this.intermediaryCertificatesH);
        if (this.featureDescription != null && this.dialogHandler.isSendFeatureDescription()) {
            this.messageParts.add(this.featureDescription);
        }
        this.messageParts.addAll(this.customHeaders);
        this.messageParts.add(this.body);
        this.stateOfMsg |= 1;
    }

    String writeInsideFeedBack() {
        StringBuilder sb = new StringBuilder("<");
        String namespace = this.osciNSPrefix;
        sb.append(this.osci2017NSPrefix);
        sb.append(":InsideFeedback>");
        for (int i = 0; i < this.insideFeedBack.size(); ++i) {
            sb.append("<");
            sb.append(namespace);
            sb.append(":Entry xml:lang=\"");
            sb.append(this.insideFeedBack.get(i)[0]);
            sb.append("\"><");
            sb.append(namespace);
            sb.append(":Code>");
            sb.append(this.insideFeedBack.get(i)[1]);
            sb.append("</");
            sb.append(namespace);
            sb.append(":Code><");
            sb.append(namespace);
            sb.append(":Text>");
            sb.append(this.insideFeedBack.get(i)[2]);
            sb.append("</");
            sb.append(namespace);
            sb.append(":Text></");
            sb.append(namespace);
            sb.append(":Entry>");
        }
        sb.append("</");
        sb.append(this.osci2017NSPrefix);
        sb.append(":InsideFeedback>");
        return sb.toString();
    }
}

