/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.Tools;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.extinterfaces.crypto.Decrypter;
import de.osci.osci12.extinterfaces.crypto.Signer;
import de.osci.osci12.messageparts.Attachment;
import de.osci.osci12.messageparts.Body;
import de.osci.osci12.messageparts.Content;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messageparts.EncryptedDataOSCI;
import de.osci.osci12.messageparts.Inspection;
import de.osci.osci12.messageparts.MessagePartsFactory;
import de.osci.osci12.messageparts.ProcessCardBundle;
import de.osci.osci12.messageparts.Timestamp;
import de.osci.osci12.messagetypes.ContentPackageI;
import de.osci.osci12.messagetypes.MediateDelivery;
import de.osci.osci12.messagetypes.OSCIResponseTo;
import de.osci.osci12.messagetypes.ResponseToProcessDelivery;
import de.osci.osci12.roles.Addressee;
import de.osci.osci12.roles.Author;
import de.osci.osci12.roles.OSCIRoleException;
import de.osci.osci12.roles.Reader;
import de.osci.osci12.soapheader.OsciH;
import eu.osci.ws._2014._10.transport.MessageMetaData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;

public class ResponseToMediateDelivery
extends OSCIResponseTo
implements ContentPackageI {
    public ProcessCardBundle processCardBundleRequest;
    public ProcessCardBundle processCardBundleReply;

    ResponseToMediateDelivery(DialogHandler dh) throws OSCIRoleException {
        super(dh);
        this.messageType = 128;
        Signer signer = null;
        Decrypter decrypter = null;
        if (this.dialogHandler.getClient().hasSignaturePrivateKey()) {
            signer = this.dialogHandler.getClient().getSigner();
        }
        if (this.dialogHandler.getClient().hasCipherPrivateKey()) {
            decrypter = this.dialogHandler.getClient().getDecrypter();
        }
        this.addressee = new Addressee(signer, decrypter);
    }

    ResponseToMediateDelivery(MediateDelivery medDel, ResponseToProcessDelivery rspProcDel) throws NoSuchAlgorithmException, OSCIRoleException {
        super(medDel.dialogHandler);
        this.messageType = 128;
        this.addressee = rspProcDel.addressee;
        this.originator = rspProcDel.originator;
        ContentContainer[] con = rspProcDel.getContentContainer();
        for (int i = 0; i < con.length; ++i) {
            this.addContentContainer(con[i]);
        }
        EncryptedDataOSCI[] enc = rspProcDel.getEncryptedData();
        for (int i = 0; i < enc.length; ++i) {
            this.addEncryptedData(enc[i]);
        }
        Attachment[] att = rspProcDel.getAttachments();
        for (int i = 0; i < att.length; ++i) {
            this.addAttachment(att[i]);
        }
        Author[] auth = rspProcDel.getOtherAuthors();
        for (int i = 0; i < auth.length; ++i) {
            this.otherAutors.put(auth[i].id, auth[i]);
        }
        Reader[] read = rspProcDel.getOtherReaders();
        for (int i = 0; i < read.length; ++i) {
            this.otherReaders.put(read[i].id, read[i]);
        }
        this.dialogHandler.getControlblock().setResponse(this.dialogHandler.prevChallenge);
        this.dialogHandler.getControlblock().setChallenge(Tools.createRandom(10));
    }

    public ProcessCardBundle getProcessCardBundleRequest() {
        return this.processCardBundleRequest;
    }

    public ProcessCardBundle getProcessCardBundleReply() {
        return this.processCardBundleReply;
    }

    public Timestamp getTimestampCreationRequest() {
        if (this.processCardBundleRequest == null) {
            return null;
        }
        return this.processCardBundleRequest.getCreation();
    }

    public Timestamp getTimestampCreationReply() {
        if (this.processCardBundleReply == null) {
            return null;
        }
        return this.processCardBundleReply.getCreation();
    }

    public Timestamp getTimestampForwardingRequest() {
        if (this.processCardBundleRequest == null) {
            return null;
        }
        return this.processCardBundleRequest.getForwarding();
    }

    public Timestamp getTimestampForwardingReply() {
        if (this.processCardBundleReply == null) {
            return null;
        }
        return this.processCardBundleReply.getForwarding();
    }

    public Timestamp getTimestampReceptionRequest() {
        if (this.processCardBundleRequest == null) {
            return null;
        }
        return this.processCardBundleRequest.getReception();
    }

    public Inspection[] getInspectionsRequest() {
        if (this.processCardBundleRequest == null) {
            return null;
        }
        return this.processCardBundleRequest.getInspections();
    }

    public Inspection[] getInspectionsReply() {
        if (this.processCardBundleReply == null) {
            return null;
        }
        return this.processCardBundleReply.getInspections();
    }

    public String getSubjectRequest() {
        if (this.processCardBundleRequest == null) {
            return null;
        }
        return this.processCardBundleRequest.getSubject();
    }

    @Override
    public String getSubject() {
        if (this.processCardBundleReply == null) {
            return null;
        }
        return this.processCardBundleReply.getSubject();
    }

    public String getRecentModificationRequest() {
        if (this.processCardBundleRequest == null) {
            return null;
        }
        return this.processCardBundleRequest.getRecentModification();
    }

    public String getRecentModificationReply() {
        if (this.processCardBundleReply == null) {
            return null;
        }
        return this.processCardBundleReply.getRecentModification();
    }

    public String getMessageIdRequest() {
        return this.messageId;
    }

    @Override
    public String getMessageId() {
        if (this.processCardBundleReply == null) {
            return null;
        }
        return this.processCardBundleReply.getMessageId();
    }

    @Override
    public ContentContainer[] getContentContainer() {
        return super.getContentContainer();
    }

    @Override
    public ContentContainer getContentContainerByRefID(String refID) {
        return super.getContentContainerByRefID(refID);
    }

    @Override
    public Content getContentByRefID(String refID) {
        return super.getContentByRefID(refID);
    }

    @Override
    public EncryptedDataOSCI[] getEncryptedData() {
        return super.getEncryptedData();
    }

    @Override
    public void addMessageMetaDataXTA2V3(MessageMetaData mmd) {
        super.addMessageMetaDataXTA2V3(mmd);
    }

    @Override
    public void addMessageMetaDataXTA2V3(String mmd) {
        super.addMessageMetaDataXTA2V3(mmd);
    }

    @Override
    public MessageMetaData getMessageMetaDataXTA2V3() {
        return super.getMessageMetaDataXTA2V3();
    }

    @Override
    void sign() throws IOException, OSCIException, NoSuchAlgorithmException {
        super.sign();
        this.messageParts.set(4, this.intermediaryCertificatesH);
        this.messageParts.set(2, null);
    }

    @Override
    protected void compose() throws OSCIException, IOException, NoSuchAlgorithmException {
        super.compose();
        this.messageParts.set(2, null);
        this.importAllCertificates();
        Object head = this.writeFeedBack();
        if (this.processCardBundleRequest != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            MessagePartsFactory.writeXML(this.processCardBundleRequest, out);
            if (this.processCardBundleReply != null) {
                MessagePartsFactory.writeXML(this.processCardBundleReply, out);
            }
            head = (String)head + out.toString(Constants.CHARSET_ENCODING);
        }
        this.osciH = new OsciH(Constants.HeaderTags.responseToMediateDelivery.getElementName(), (String)head);
        this.messageParts.add(this.osciH);
        this.messageParts.add(this.intermediaryCertificatesH);
        this.createNonIntermediaryCertificatesH();
        this.messageParts.add(this.nonIntermediaryCertificatesH);
        if (this.featureDescription != null && this.dialogHandler.isSendFeatureDescription()) {
            this.messageParts.add(this.featureDescription);
        }
        this.messageParts.addAll(this.customHeaders);
        this.body = new Body(this.getContentContainer(), this.getEncryptedData());
        this.messageParts.add(this.body);
        this.stateOfMsg |= 1;
    }
}

