/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.Base64;
import de.osci.helper.Tools;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.Body;
import de.osci.osci12.messagetypes.OSCIResponseTo;
import de.osci.osci12.roles.Originator;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;

public class ResponseToGetMessageId
extends OSCIResponseTo {
    ResponseToGetMessageId(DialogHandler dh, boolean parser) throws NoSuchAlgorithmException {
        super(dh);
        this.messageType = 96;
        this.originator = (Originator)dh.getClient();
        if (!parser) {
            this.dialogHandler.getControlblock().setResponse(this.dialogHandler.prevChallenge);
            this.dialogHandler.getControlblock().setChallenge(Tools.createRandom(10));
        }
    }

    ResponseToGetMessageId(DialogHandler dh) throws NoSuchAlgorithmException {
        this(dh, false);
    }

    public String getMessageId() {
        return this.messageId;
    }

    void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    @Override
    protected void compose() throws OSCIException, IOException, NoSuchAlgorithmException {
        super.compose();
        if (this.featureDescription != null && this.dialogHandler.isSendFeatureDescription()) {
            this.messageParts.add(this.featureDescription);
        }
        this.messageParts.addAll(this.customHeaders);
        if (this.dialogHandler.getControlblock().getSequenceNumber() == -1) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": SequenceNumber");
        }
        if (this.feedBack == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Feedback");
        }
        StringBuffer bd = new StringBuffer("<");
        bd.append(this.osciNSPrefix);
        bd.append(":responseToGetMessageId>");
        bd.append(this.writeFeedBack());
        if (this.messageId != null && this.messageId.length() > 0) {
            bd.append("<");
            bd.append(this.osciNSPrefix);
            bd.append(":MessageId>");
            bd.append(Base64.encode(this.messageId.getBytes(Constants.CHARSET_ENCODING)));
            bd.append("</");
            bd.append(this.osciNSPrefix);
            bd.append(":MessageId>");
        }
        bd.append("</");
        bd.append(this.osciNSPrefix);
        bd.append(":responseToGetMessageId>");
        this.body = new Body(bd.toString());
        this.body.setNSPrefixes(this);
        this.messageParts.add(this.body);
        this.stateOfMsg |= 1;
    }
}

