/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.Base64;
import de.osci.helper.Tools;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.Body;
import de.osci.osci12.messageparts.MessagePartsFactory;
import de.osci.osci12.messageparts.ProcessCardBundle;
import de.osci.osci12.messagetypes.FetchProcessCard;
import de.osci.osci12.messagetypes.OSCIResponseTo;
import de.osci.osci12.roles.Originator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;

public class ResponseToFetchProcessCard
extends OSCIResponseTo {
    private String selectionRule;
    private int selectionMode = -1;
    private int selectionRole = -1;
    private boolean selectNoReceptionOnly = false;
    private long quantityLimit = -1L;
    ProcessCardBundle[] processCardBundles = new ProcessCardBundle[0];

    ResponseToFetchProcessCard(DialogHandler dh) {
        super(dh);
        this.messageType = 64;
        this.originator = (Originator)this.dialogHandler.getClient();
    }

    ResponseToFetchProcessCard(FetchProcessCard fpc) throws NoSuchAlgorithmException {
        super(fpc.dialogHandler);
        this.originator = (Originator)this.dialogHandler.getClient();
        this.messageType = 64;
        this.setSelectionMode(fpc.getSelectionMode());
        this.setSelectionRule(fpc.getSelectionRule());
        this.setRoleForSelection(fpc.getRoleForSelection());
        this.setSelectNoReceptionOnly(fpc.isSelectNoReception());
        if (fpc.getQuantityLimit() > 0L) {
            this.setQuantityLimit(fpc.getQuantityLimit());
        }
        this.dialogHandler.getControlblock().setResponse(this.dialogHandler.prevChallenge);
        this.dialogHandler.getControlblock().setChallenge(Tools.createRandom(10));
    }

    public ProcessCardBundle[] getProcessCardBundles() {
        return this.processCardBundles;
    }

    void setSelectionRule(String selectionRule) {
        this.selectionRule = selectionRule;
    }

    public String getSelectionRule() {
        return this.selectionRule;
    }

    void setSelectionMode(int selectionMode) {
        this.selectionMode = selectionMode;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    void setRoleForSelection(int role) {
        this.selectionRole = role;
    }

    public int getRoleForSelection() {
        return this.selectionRole;
    }

    void setSelectNoReceptionOnly(boolean noReceptionOnly) {
        this.selectNoReceptionOnly = noReceptionOnly;
    }

    public boolean isSelectNoReception() {
        return this.selectNoReceptionOnly;
    }

    public long getQuantityLimit() {
        return this.quantityLimit;
    }

    void setQuantityLimit(long quantityLimit) {
        if (quantityLimit <= 0L) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + ": " + quantityLimit);
        }
        this.quantityLimit = quantityLimit;
    }

    @Override
    protected void compose() throws OSCIException, IOException, NoSuchAlgorithmException {
        super.compose();
        if (this.featureDescription != null && this.dialogHandler.isSendFeatureDescription()) {
            this.messageParts.add(this.featureDescription);
        }
        this.messageParts.addAll(this.customHeaders);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(60);
        bos.write(this.osciNSPrefix.getBytes(Constants.CHARSET_ENCODING));
        bos.write(":responseToFetchProcessCard>".getBytes(Constants.CHARSET_ENCODING));
        bos.write(this.writeFeedBack().getBytes(Constants.CHARSET_ENCODING));
        bos.write(60);
        bos.write(this.osciNSPrefix.getBytes(Constants.CHARSET_ENCODING));
        bos.write(":fetchProcessCard>".getBytes(Constants.CHARSET_ENCODING));
        Object selectionAttributes = "";
        if (this.selectNoReceptionOnly) {
            selectionAttributes = (String)selectionAttributes + " NoReception=\"true\"";
        }
        if (this.selectionRole == 0) {
            selectionAttributes = (String)selectionAttributes + " Role=\"Addressee\"";
        } else if (this.selectionRole == 1) {
            selectionAttributes = (String)selectionAttributes + " Role=\"Originator\"";
        }
        StringBuffer selection = new StringBuffer("<");
        selection.append(this.osciNSPrefix);
        selection.append(":SelectionRule>");
        if (this.selectionMode == 0) {
            String[] msgIds = this.selectionRule.split(";");
            for (int i = 0; i < msgIds.length; ++i) {
                selection.append("<");
                selection.append(this.osciNSPrefix);
                selection.append(":MessageId>");
                selection.append(Base64.encode(msgIds[i].getBytes(Constants.CHARSET_ENCODING)));
                selection.append("</");
                selection.append(this.osciNSPrefix);
                selection.append(":MessageId>");
            }
            selection.append("</");
        } else if (this.selectionMode == 1) {
            selection.append("<");
            selection.append(this.osciNSPrefix);
            selection.append(":ReceptionOfDelivery" + (String)selectionAttributes + ">" + this.selectionRule + "</");
            selection.append(this.osciNSPrefix);
            selection.append(":ReceptionOfDelivery></");
        } else if (this.selectionMode == 2) {
            selection.append("<");
            selection.append(this.osciNSPrefix);
            selection.append(":RecentModification" + (String)selectionAttributes + ">" + this.selectionRule + "</");
            selection.append(this.osciNSPrefix);
            selection.append(":RecentModification></");
        } else {
            selection.delete(0, selection.length());
        }
        if (selection.length() > 0) {
            selection.append(this.osciNSPrefix);
            selection.append(":SelectionRule>");
        }
        if (this.quantityLimit >= 0L) {
            selection.append("<");
            selection.append(this.osciNSPrefix);
            selection.append(":Quantity Limit=\"" + this.quantityLimit + "\"></");
            selection.append(this.osciNSPrefix);
            selection.append(":Quantity>");
        }
        bos.write(selection.toString().getBytes(Constants.CHARSET_ENCODING));
        bos.write(("</" + this.osciNSPrefix + ":fetchProcessCard>").getBytes(Constants.CHARSET_ENCODING));
        for (int i = 0; i < this.processCardBundles.length; ++i) {
            MessagePartsFactory.writeXML(this.processCardBundles[i], bos);
        }
        bos.write(("</" + this.osciNSPrefix + ":responseToFetchProcessCard>").getBytes(Constants.CHARSET_ENCODING));
        this.body = new Body(bos.toString(Constants.CHARSET_ENCODING));
        this.body.setNSPrefixes(this);
        this.messageParts.add(this.body);
        this.stateOfMsg |= 1;
    }
}

