/*
 * Decompiled with CFR 0.152.
 */
package de.osci.osci12.messagetypes;

import de.osci.helper.Base64;
import de.osci.helper.Tools;
import de.osci.osci12.OSCIException;
import de.osci.osci12.common.Constants;
import de.osci.osci12.common.DialogHandler;
import de.osci.osci12.messageparts.Attachment;
import de.osci.osci12.messageparts.Body;
import de.osci.osci12.messageparts.ChunkInformation;
import de.osci.osci12.messageparts.Content;
import de.osci.osci12.messageparts.ContentContainer;
import de.osci.osci12.messageparts.EncryptedDataOSCI;
import de.osci.osci12.messageparts.MessagePartsFactory;
import de.osci.osci12.messagetypes.ContentPackageI;
import de.osci.osci12.messagetypes.OSCIRequest;
import de.osci.osci12.messagetypes.ResponseToPartialStoreDelivery;
import de.osci.osci12.roles.Addressee;
import de.osci.osci12.roles.OSCIRoleException;
import de.osci.osci12.roles.Originator;
import de.osci.osci12.soapheader.OsciH;
import de.osci.osci12.soapheader.QualityOfTimestampH;
import eu.osci.ws._2014._10.transport.MessageMetaData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PartialStoreDelivery
extends OSCIRequest
implements ContentPackageI {
    protected static Log log = LogFactory.getLog(PartialStoreDelivery.class);
    private String subject;
    private boolean infoOnly = false;
    private ChunkInformation chunkInformation;

    PartialStoreDelivery() {
        this.messageType = 11;
        this.setBase64Encoding(false);
    }

    public PartialStoreDelivery(DialogHandler dh, Addressee addressee, ChunkInformation chunkInforamtion, String messageId) throws OSCIRoleException, NoSuchAlgorithmException {
        super(dh);
        this.messageType = 11;
        this.originator = (Originator)dh.getClient();
        this.addressee = addressee;
        addressee.getCipherCertificate();
        this.setChunkInformation(chunkInforamtion);
        this.messageId = !messageId.endsWith("_Partial") ? messageId.concat("_Partial") : messageId;
        this.setBase64Encoding(false);
        if (!this.dialogHandler.isExplicitDialog()) {
            this.dialogHandler.resetControlBlock();
        }
        this.setQualityOfTimeStampCreation(false);
        this.dialogHandler.getControlblock().setResponse(this.dialogHandler.getControlblock().getChallenge());
        this.dialogHandler.getControlblock().setChallenge(Tools.createRandom(10));
        this.dialogHandler.getControlblock().setSequenceNumber(this.dialogHandler.getControlblock().getSequenceNumber() + 1);
    }

    public PartialStoreDelivery(DialogHandler dh, Addressee addressee, boolean infoOnly, String messageId) throws OSCIRoleException, NoSuchAlgorithmException {
        this(dh, addressee, null, messageId);
        if (!infoOnly) {
            log.error((Object)"Error create constructor with infoOnly set to false");
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_thirdargument.name()) + " InfoOnly");
        }
        this.setInfoOnly(true);
    }

    public ChunkInformation getChunkInformation() {
        return this.chunkInformation;
    }

    public void setChunkInformation(ChunkInformation chunkInformation) {
        if (this.infoOnly) {
            throw new IllegalArgumentException(DialogHandler.text.getString(Constants.LanguageTextEntries.invalid_firstargument.name()) + " InfoOnly");
        }
        this.chunkInformation = chunkInformation;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public boolean isInfoOnly() {
        return this.infoOnly;
    }

    public void setInfoOnly(boolean infoOnly) {
        this.infoOnly = infoOnly;
    }

    public void setChunkBlob(InputStream chunkBlob) throws OSCIRoleException, NoSuchAlgorithmException, IOException {
        ContentContainer container = new ContentContainer();
        container.setRefID("ChunkContentContainer");
        Attachment atta = new Attachment(chunkBlob, "ChunkBlobStoreDelivery");
        atta.setBase64Encoding(false);
        Content content = new Content(atta);
        content.setRefID("ChunkContent");
        container.addContent(content);
        super.addContentContainer(container);
    }

    public ResponseToPartialStoreDelivery send() throws IOException, OSCIException, NoSuchAlgorithmException {
        if (this.base64) {
            throw new IllegalStateException("Base64 should be disabled!");
        }
        return (ResponseToPartialStoreDelivery)this.transmit(null, null);
    }

    public ResponseToPartialStoreDelivery send(OutputStream storeOutput, OutputStream storeInput) throws IOException, OSCIException, NoSuchAlgorithmException {
        if (this.base64) {
            throw new IllegalStateException("Base64 should be disabled!");
        }
        return (ResponseToPartialStoreDelivery)this.transmit(storeOutput, storeInput);
    }

    @Override
    void sign() throws IOException, OSCIException, NoSuchAlgorithmException {
        super.sign();
        this.messageParts.set(3, null);
        this.messageParts.set(7, this.nonIntermediaryCertificatesH);
    }

    @Override
    protected void compose() throws OSCIException, IOException, NoSuchAlgorithmException {
        super.compose();
        this.messageParts.set(3, null);
        this.messageParts.add(this.qualityOfTimestampTypeCreation);
        this.messageParts.add(null);
        if (this.dialogHandler.getControlblock().getChallenge() == null) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": Challenge");
        }
        if (this.dialogHandler.getControlblock().getSequenceNumber() == -1) {
            throw new IllegalStateException(DialogHandler.text.getString(Constants.LanguageTextEntries.missing_entry.name()) + ": SequenceNumber");
        }
        this.importAllCertificates();
        ByteArrayOutputStream parStrDelHeader = new ByteArrayOutputStream();
        String msgIdElement = "<" + this.osciNSPrefix + ":MessageId>" + Base64.encode(this.messageId.getBytes(Constants.CHARSET_ENCODING)) + "</" + this.osciNSPrefix + ":MessageId>";
        parStrDelHeader.write(msgIdElement.getBytes());
        if (this.subject != null) {
            parStrDelHeader.write(("<" + this.osciNSPrefix + ":Subject>" + this.subject + "</" + this.osciNSPrefix + ":Subject>").getBytes());
        }
        if (this.infoOnly) {
            parStrDelHeader.write(("<" + this.osci2017NSPrefix + ":InfoOnly></" + this.osci2017NSPrefix + ":InfoOnly>").getBytes());
        } else {
            MessagePartsFactory.writeXML(this.chunkInformation, parStrDelHeader);
        }
        this.osciH = new OsciH(Constants.HeaderTags.partialStoreDelivery.getElementName(), new String(parStrDelHeader.toByteArray(), Constants.CHARSET_ENCODING), this.osci2017NSPrefix);
        this.messageParts.add(this.osciH);
        this.createNonIntermediaryCertificatesH();
        this.nonIntermediaryCertificatesH.getCipherCertificateAddressee();
        this.messageParts.add(this.nonIntermediaryCertificatesH);
        if (this.featureDescription != null && this.dialogHandler.isSendFeatureDescription()) {
            this.messageParts.add(this.featureDescription);
        }
        this.messageParts.addAll(this.customHeaders);
        if (this.infoOnly) {
            this.body = new Body(new ContentContainer[0], new EncryptedDataOSCI[0]);
        } else {
            if (this.contentContainer == null || this.contentContainer.size() != 1) {
                throw new IllegalStateException("Wrong count of ContentContainer objects.");
            }
            if (this.encryptedData != null && !this.encryptedData.isEmpty()) {
                throw new IllegalStateException("Wrong count of EncryptedData objects.");
            }
            this.body = new Body(this.getContentContainer(), this.getEncryptedData());
        }
        this.messageParts.add(this.body);
        this.stateOfMsg |= 1;
    }

    public void setQualityOfTimeStampCreation(boolean cryptographic) {
        this.qualityOfTimestampTypeCreation = new QualityOfTimestampH(false, cryptographic);
    }

    public boolean getQualityOfTimeStampCreation() {
        return this.qualityOfTimestampTypeCreation.isQualityCryptographic();
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public ContentContainer getContentContainerByRefID(String refID) {
        return super.getContentContainerByRefID(refID);
    }

    @Override
    public Content getContentByRefID(String refID) {
        return super.getContentByRefID(refID);
    }

    @Override
    public ContentContainer[] getContentContainer() {
        return super.getContentContainer();
    }

    @Override
    public EncryptedDataOSCI[] getEncryptedData() {
        return super.getEncryptedData();
    }

    @Override
    public void addMessageMetaDataXTA2V3(MessageMetaData mmd) {
        super.addMessageMetaDataXTA2V3(mmd);
    }

    @Override
    public void addMessageMetaDataXTA2V3(String mmd) {
        super.addMessageMetaDataXTA2V3(mmd);
    }

    @Override
    public MessageMetaData getMessageMetaDataXTA2V3() {
        return super.getMessageMetaDataXTA2V3();
    }

    @Override
    public String getMessageId() {
        return this.messageId;
    }
}

